/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.modules.util.RegionConfiguration;
import com.gemstone.gemfire.modules.util.RegionHelper;
import java.util.Properties;

public class RegionConfigurationCacheListener
extends CacheListenerAdapter<String, RegionConfiguration>
implements Declarable {
    private Cache cache = CacheFactory.getAnyInstance();

    public void afterCreate(EntryEvent<String, RegionConfiguration> event) {
        RegionConfiguration configuration = (RegionConfiguration)event.getNewValue();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("RegionConfigurationCacheListener received afterCreate for region " + (String)event.getKey());
        }
        try {
            Region region = RegionHelper.createRegion(this.cache, configuration);
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("RegionConfigurationCacheListener created region: " + region);
            }
        }
        catch (RegionExistsException exists) {
            this.cache.getLogger().fine("Region with configuration " + configuration + " existed");
        }
    }

    public void afterUpdate(EntryEvent<String, RegionConfiguration> event) {
        this.afterCreate(event);
    }

    public void afterRegionCreate(RegionEvent<String, RegionConfiguration> event) {
        StringBuilder builder1 = null;
        StringBuilder builder2 = null;
        Region region = event.getRegion();
        if (this.cache.getLogger().fineEnabled()) {
            builder1 = new StringBuilder();
            int regionSize = region.size();
            if (regionSize > 0) {
                builder1.append("RegionConfigurationCacheListener region ").append(region.getName()).append(" has been initialized with the following ").append(regionSize).append(" region configurations:\n");
                builder2 = new StringBuilder();
                builder2.append("RegionConfigurationCacheListener created the following ").append(regionSize).append(" regions:\n");
            } else {
                builder1.append("RegionConfigurationCacheListener region ").append(region.getName()).append(" has been initialized with no region configurations");
            }
        }
        for (RegionConfiguration configuration : region.values()) {
            if (this.cache.getLogger().fineEnabled()) {
                builder1.append("\t").append(configuration);
            }
            try {
                Region createRegion = RegionHelper.createRegion(this.cache, configuration);
                if (!this.cache.getLogger().fineEnabled()) continue;
                builder2.append("\t").append(createRegion);
            }
            catch (RegionExistsException exists) {
                if (!this.cache.getLogger().fineEnabled()) continue;
                builder2.append("\t").append(" region existed");
            }
        }
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine(builder1.toString());
            if (builder2 != null) {
                this.cache.getLogger().fine(builder2.toString());
            }
        }
    }

    public void init(Properties p) {
    }
}

