/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.gatewaydelta;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.modules.gatewaydelta.AbstractGatewayDeltaEvent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GatewayDeltaDestroyEvent
extends AbstractGatewayDeltaEvent {
    public GatewayDeltaDestroyEvent() {
    }

    public GatewayDeltaDestroyEvent(String regionName, String key) {
        super(regionName, key);
    }

    @Override
    public void apply(Cache cache) {
        Region region = this.getRegion(cache);
        try {
            region.destroy((Object)this.key);
            if (cache.getLogger().fineEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Applied ").append(this);
                cache.getLogger().fine(builder.toString());
            }
        }
        catch (EntryNotFoundException e) {
            StringBuilder builder = new StringBuilder();
            builder.append(this).append(": Session ").append(this.key).append(" was not found");
            cache.getLogger().warning(builder.toString());
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    public static void registerInstantiator(int id) {
        Instantiator.register((Instantiator)new Instantiator(GatewayDeltaDestroyEvent.class, id){

            public DataSerializable newInstance() {
                return new GatewayDeltaDestroyEvent();
            }
        });
    }

    public String toString() {
        return "GatewayDeltaDestroyEvent[" + "regionName=" + this.regionName + "; key=" + this.key + "]";
    }
}

