/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class JoinResponseMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID> {
    private GMSMembershipView<ID> currentView;
    private String rejectionMessage;
    private ID memberID;
    private byte[] messengerData;
    private int requestId;
    private byte[] secretPk;

    public JoinResponseMessage(ID memberID, GMSMembershipView<ID> view, int requestId) {
        this.currentView = view;
        this.memberID = memberID;
        this.requestId = requestId;
        this.setRecipient(memberID);
    }

    public JoinResponseMessage(ID memberID, byte[] sPk, int requestId) {
        this.memberID = memberID;
        this.requestId = requestId;
        this.secretPk = sPk;
        this.setRecipient(memberID);
    }

    public JoinResponseMessage(String rejectionMessage, int requestId) {
        this.rejectionMessage = rejectionMessage;
        this.requestId = requestId;
    }

    public JoinResponseMessage() {
    }

    public byte[] getSecretPk() {
        return this.secretPk;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public GMSMembershipView<ID> getCurrentView() {
        return this.currentView;
    }

    public ID getMemberID() {
        return this.memberID;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    public byte[] getMessengerData() {
        return this.messengerData;
    }

    public void setMessengerData(byte[] data) {
        this.messengerData = data;
    }

    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; " + (this.currentView == null ? "" : this.currentView.toString()) + (this.rejectionMessage == null ? "" : "; " + this.rejectionMessage) + ")";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return -143;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.currentView, out);
        context.getSerializer().writeObject(this.memberID, out);
        StaticSerialization.writeString((String)this.rejectionMessage, (DataOutput)out);
        StaticSerialization.writeByteArray((byte[])this.messengerData, (DataOutput)out);
        StaticSerialization.writeByteArray((byte[])this.secretPk, (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.currentView = (GMSMembershipView)context.getDeserializer().readObject(in);
        this.memberID = (MemberIdentifier)context.getDeserializer().readObject(in);
        this.rejectionMessage = StaticSerialization.readString((DataInput)in);
        this.messengerData = StaticSerialization.readByteArray((DataInput)in);
        this.secretPk = StaticSerialization.readByteArray((DataInput)in);
    }

    public int hashCode() {
        return Objects.hash(this.memberID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinResponseMessage other = (JoinResponseMessage)obj;
        if (this.currentView == null ? other.currentView != null : !this.currentView.equals(other.currentView)) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        if (!Arrays.equals(this.messengerData, other.messengerData)) {
            return false;
        }
        if (this.rejectionMessage == null ? other.rejectionMessage != null : !this.rejectionMessage.equals(other.rejectionMessage)) {
            return false;
        }
        return Arrays.equals(this.secretPk, other.secretPk);
    }
}

