/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.logging.log4j.Logger;

public class GMSMembershipView<ID extends MemberIdentifier>
implements DataSerializableFixedID {
    private int viewId;
    private List<ID> members;
    private final Map<ID, Object> publicKeys = new ConcurrentHashMap<ID, Object>();
    private int[] failureDetectionPorts = new int[10];
    private Set<ID> shutdownMembers;
    private Set<ID> crashedMembers;
    private ID creator;
    private Set<ID> hashedMembers;
    private final Object membersLock = new Object();
    @Immutable
    public static final Random RANDOM = new Random();

    public GMSMembershipView() {
        this.viewId = 0;
        this.members = new ArrayList<ID>(4);
        this.hashedMembers = new HashSet<ID>(this.members);
        this.shutdownMembers = Collections.emptySet();
        this.crashedMembers = new HashSet<ID>();
        this.creator = null;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public GMSMembershipView(ID creator) {
        this.viewId = 0;
        this.members = new ArrayList<ID>(4);
        this.members.add(creator);
        this.hashedMembers = new HashSet<ID>(this.members);
        this.shutdownMembers = new HashSet<ID>();
        this.crashedMembers = Collections.emptySet();
        this.creator = creator;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public GMSMembershipView(ID creator, int viewId, List<ID> members) {
        this.viewId = viewId;
        this.members = new ArrayList<ID>(members);
        this.hashedMembers = new HashSet<ID>(this.members);
        this.shutdownMembers = new HashSet<ID>();
        this.crashedMembers = Collections.emptySet();
        this.creator = creator;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public GMSMembershipView(int size, long viewId) {
        this.viewId = (int)viewId;
        this.members = new ArrayList<ID>(size);
        this.hashedMembers = new HashSet<ID>();
        this.shutdownMembers = new HashSet<ID>();
        this.crashedMembers = Collections.emptySet();
        this.creator = null;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public GMSMembershipView(GMSMembershipView<ID> other, int viewId) {
        this.creator = other.creator;
        this.viewId = viewId;
        this.members = new ArrayList<ID>(other.members);
        this.hashedMembers = new HashSet<ID>(other.members);
        this.failureDetectionPorts = new int[other.failureDetectionPorts.length];
        System.arraycopy(other.failureDetectionPorts, 0, this.failureDetectionPorts, 0, other.failureDetectionPorts.length);
        this.shutdownMembers = new HashSet<ID>(other.shutdownMembers);
        this.crashedMembers = new HashSet<ID>(other.crashedMembers);
        this.publicKeys.putAll(other.publicKeys);
    }

    public GMSMembershipView(ID creator, int viewId, List<ID> mbrs, Set<ID> shutdowns, Set<ID> crashes) {
        this.creator = creator;
        this.viewId = viewId;
        this.members = mbrs;
        this.hashedMembers = new HashSet<ID>(mbrs);
        this.shutdownMembers = shutdowns;
        this.crashedMembers = crashes;
        this.failureDetectionPorts = new int[mbrs.size() + 10];
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public int getViewId() {
        return this.viewId;
    }

    public ID getCreator() {
        return this.creator;
    }

    public void setCreator(ID creator) {
        this.creator = creator;
    }

    public Object getPublicKey(ID mbr) {
        return this.publicKeys.get(mbr);
    }

    public void setPublicKey(ID mbr, Object key) {
        if (mbr != null && key != null) {
            this.publicKeys.put(mbr, key);
        }
    }

    public void setPublicKeys(GMSMembershipView<ID> otherView) {
        this.publicKeys.putAll(otherView.publicKeys);
    }

    public void setViewId(int viewId) {
        this.viewId = viewId;
    }

    public int[] getFailureDetectionPorts() {
        return this.failureDetectionPorts;
    }

    public int getFailureDetectionPort(ID mbr) {
        int idx = this.members.indexOf(mbr);
        if (idx < 0 || idx >= this.failureDetectionPorts.length) {
            return -1;
        }
        return this.failureDetectionPorts[idx];
    }

    public void setFailureDetectionPort(ID mbr, int port) {
        int idx = this.members.indexOf(mbr);
        if (idx < 0) {
            throw new IllegalArgumentException("element not found in members list:" + mbr);
        }
        this.ensureFDCapacity(idx);
        this.failureDetectionPorts[idx] = port;
    }

    public void setFailureDetectionPorts(GMSMembershipView<ID> otherView) {
        int[] ports = otherView.getFailureDetectionPorts();
        if (ports != null) {
            int idx = 0;
            int portsSize = ports.length;
            for (MemberIdentifier mbr : otherView.getMembers()) {
                if (this.contains(mbr)) {
                    if (idx < portsSize) {
                        this.setFailureDetectionPort(mbr, ports[idx]);
                    } else {
                        this.setFailureDetectionPort(mbr, -1);
                    }
                }
                ++idx;
            }
        }
    }

    private void ensureFDCapacity(int idx) {
        if (idx >= this.failureDetectionPorts.length) {
            int[] p = new int[idx + 10];
            if (this.failureDetectionPorts.length > 0) {
                System.arraycopy(this.failureDetectionPorts, 0, p, 0, this.failureDetectionPorts.length);
            }
            Arrays.fill(p, idx, idx + 9, -1);
            this.failureDetectionPorts = p;
        }
    }

    public ID get(int i) {
        return (ID)((MemberIdentifier)this.members.get(i));
    }

    public void add(ID mbr) {
        this.hashedMembers.add(mbr);
        this.members.add(mbr);
        int idx = this.members.size() - 1;
        this.ensureFDCapacity(idx);
        this.failureDetectionPorts[idx] = -1;
    }

    public void addCrashedMembers(Set<ID> mbr) {
        this.crashedMembers.addAll(mbr);
    }

    public List<ID> getNewMembers(GMSMembershipView<ID> olderView) {
        ArrayList<ID> result = new ArrayList<ID>(this.members);
        result.removeAll(olderView.getMembers());
        return result;
    }

    public List<ID> getNewMembers() {
        ArrayList result = new ArrayList(5);
        result.addAll(this.members.stream().filter(mbr -> mbr.getVmViewId() == this.viewId).collect(Collectors.toList()));
        return result;
    }

    public boolean remove(ID mbr) {
        this.hashedMembers.remove(mbr);
        int idx = this.members.indexOf(mbr);
        if (idx >= 0) {
            System.arraycopy(this.failureDetectionPorts, idx + 1, this.failureDetectionPorts, idx, this.failureDetectionPorts.length - idx - 1);
            this.failureDetectionPorts[this.failureDetectionPorts.length - 1] = -1;
        }
        return this.members.remove(mbr);
    }

    public void removeAll(Collection<ID> ids) {
        this.hashedMembers.removeAll(ids);
        ids.forEach(this::remove);
    }

    public boolean contains(ID mbr) {
        return this.hashedMembers.contains(mbr);
    }

    public int size() {
        return this.members.size();
    }

    public ID getLeadMember() {
        for (MemberIdentifier mbr : this.members) {
            if (mbr.getVmKind() != 10) continue;
            return (ID)mbr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getCoordinator() {
        Object object = this.membersLock;
        synchronized (object) {
            for (MemberIdentifier addr : this.members) {
                if (!addr.preferredForCoordinator()) continue;
                return (ID)addr;
            }
            if (this.members.size() > 0) {
                return (ID)((MemberIdentifier)this.members.get(0));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getCoordinator(Collection<ID> rejections) {
        if (rejections == null) {
            return this.getCoordinator();
        }
        Object object = this.membersLock;
        synchronized (object) {
            for (MemberIdentifier addr : this.members) {
                if (!addr.preferredForCoordinator() || rejections.contains(addr)) continue;
                return (ID)addr;
            }
            for (MemberIdentifier addr : this.members) {
                if (rejections.contains(addr)) continue;
                return (ID)addr;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ID> getPreferredCoordinators(Set<ID> filter, ID localAddress, int maxNumberDesired) {
        ArrayList<MemberIdentifier> results = new ArrayList<MemberIdentifier>();
        ArrayList<MemberIdentifier> notPreferredCoordinatorList = new ArrayList<MemberIdentifier>();
        Object object = this.membersLock;
        synchronized (object) {
            for (MemberIdentifier addr : this.members) {
                if (addr.equals(localAddress)) continue;
                if (addr.preferredForCoordinator() && !filter.contains(addr)) {
                    results.add(addr);
                    if (results.size() < maxNumberDesired) continue;
                    break;
                }
                if (filter.contains(addr)) continue;
                notPreferredCoordinatorList.add(addr);
            }
            results.add((MemberIdentifier)localAddress);
            if (results.size() < maxNumberDesired && notPreferredCoordinatorList.size() > 0) {
                Iterator it = notPreferredCoordinatorList.iterator();
                while (it.hasNext() && results.size() < maxNumberDesired) {
                    results.add((MemberIdentifier)it.next());
                }
            }
        }
        return results;
    }

    public List<ID> getGMSMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public List<ID> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public Set<ID> getShutdownMembers() {
        return this.shutdownMembers;
    }

    public Set<ID> getCrashedMembers() {
        return this.crashedMembers;
    }

    public boolean shouldBeCoordinator(ID who) {
        Iterator<ID> it = this.members.iterator();
        Object firstNonPreferred = null;
        while (it.hasNext()) {
            MemberIdentifier mbr = (MemberIdentifier)it.next();
            if (mbr.preferredForCoordinator()) {
                return mbr.equals(who);
            }
            if (firstNonPreferred != null) continue;
            firstNonPreferred = mbr;
        }
        return firstNonPreferred == null || firstNonPreferred.equals(who);
    }

    public int memberWeight() {
        int result = 0;
        ID lead = this.getLeadMember();
        block5: for (MemberIdentifier mbr : this.members) {
            result += mbr.getMemberWeight();
            switch (mbr.getVmKind()) {
                case 10: {
                    result += 10;
                    if (lead == null || !mbr.equals(lead)) continue block5;
                    result += 5;
                    continue block5;
                }
                case 11: {
                    result += 3;
                    continue block5;
                }
                case 12: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown member type: " + mbr.getVmKind());
        }
        return result;
    }

    public int getCrashedMemberWeight(GMSMembershipView<ID> oldView) {
        int result = 0;
        ID lead = oldView.getLeadMember();
        block5: for (MemberIdentifier mbr : this.crashedMembers) {
            if (!oldView.contains(mbr)) continue;
            result += mbr.getMemberWeight();
            switch (mbr.getVmKind()) {
                case 10: {
                    result += 10;
                    if (lead == null || !mbr.equals(lead)) continue block5;
                    result += 5;
                    continue block5;
                }
                case 11: {
                    result += 3;
                    continue block5;
                }
                case 12: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown member type: " + mbr.getVmKind());
        }
        return result;
    }

    public Set<ID> getActualCrashedMembers(GMSMembershipView<ID> oldView) {
        HashSet result = new HashSet(this.crashedMembers.size());
        result.addAll(this.crashedMembers.stream().filter(mbr -> mbr.getVmKind() != 12).filter(mbr -> oldView == null || oldView.contains(mbr)).collect(Collectors.toList()));
        return result;
    }

    public void logCrashedMemberWeights(GMSMembershipView<ID> oldView, Logger log) {
        ID lead = oldView.getLeadMember();
        for (MemberIdentifier mbr : this.crashedMembers) {
            if (!oldView.contains(mbr)) continue;
            int mbrWeight = mbr.getMemberWeight();
            switch (mbr.getVmKind()) {
                case 10: {
                    if (lead != null && mbr.equals(lead)) {
                        mbrWeight += 15;
                        break;
                    }
                    mbrWeight += 10;
                    break;
                }
                case 11: {
                    mbrWeight += 3;
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown member type: " + mbr.getVmKind());
                }
            }
            log.info("  " + mbr + " had a weight of " + mbrWeight);
        }
    }

    public String toString() {
        ID lead = this.getLeadMember();
        StringBuilder sb = new StringBuilder(200);
        sb.append("View[").append(this.creator).append('|').append(this.viewId).append("] members: [");
        boolean first = true;
        for (MemberIdentifier mbr : this.members) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(mbr);
            if (mbr == lead) {
                sb.append("{lead}");
            }
            first = false;
        }
        if (!this.shutdownMembers.isEmpty()) {
            sb.append("]  shutdown: [");
            first = true;
            for (MemberIdentifier mbr : this.shutdownMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        if (!this.crashedMembers.isEmpty()) {
            sb.append("]  crashed: [");
            first = true;
            for (MemberIdentifier mbr : this.crashedMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized ID getCanonicalID(ID id) {
        if (this.hashedMembers.contains(id)) {
            for (MemberIdentifier m : this.members) {
                if (!id.equals(m)) continue;
                return (ID)m;
            }
        }
        return id;
    }

    public synchronized boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GMSMembershipView) {
            return this.members.equals(((GMSMembershipView)other).getGMSMembers());
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.members.hashCode();
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.creator, out);
        out.writeInt(this.viewId);
        this.writeAsArrayList(this.members, out, context);
        GMSUtil.writeSetOfMemberIDs(this.shutdownMembers, out, context);
        GMSUtil.writeSetOfMemberIDs(this.crashedMembers, out, context);
        StaticSerialization.writeIntArray((int[])this.failureDetectionPorts, (DataOutput)out);
        StaticSerialization.writeHashMap(this.publicKeys, (DataOutput)out, (SerializationContext)context);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.creator = (MemberIdentifier)context.getDeserializer().readObject(in);
        this.viewId = in.readInt();
        this.members = GMSUtil.readArrayOfIDs(in, context);
        assert (this.members != null);
        this.hashedMembers = new HashSet<ID>(this.members);
        this.shutdownMembers = GMSUtil.readHashSetOfMemberIDs(in, context);
        this.crashedMembers = GMSUtil.readHashSetOfMemberIDs(in, context);
        this.failureDetectionPorts = StaticSerialization.readIntArray((DataInput)in);
        HashMap pubkeys = StaticSerialization.readHashMap((DataInput)in, (DeserializationContext)context);
        if (pubkeys != null) {
            this.publicKeys.putAll(pubkeys);
        }
    }

    private void writeAsArrayList(List<ID> list, DataOutput out, SerializationContext context) throws IOException {
        int size = list == null ? -1 : list.size();
        StaticSerialization.writeArrayLength((int)size, (DataOutput)out);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                context.getSerializer().writeObject(list.get(i), out);
            }
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return -148;
    }

    public void correctWrongVersionIn(ID memberID) {
        ID oldID = this.getCanonicalID(memberID);
        if (!oldID.getVersion().equals(KnownVersion.getCurrentVersion())) {
            oldID.setVersionForTest((Version)KnownVersion.getCurrentVersion());
        }
    }
}

