/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.membership;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.JoinLeave;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Locator;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HasMemberID;
import org.apache.geode.distributed.internal.membership.gms.messages.InstallViewMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinResponseMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.LeaveRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.NetworkPartitionMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.RemoveMemberMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.ViewAckMessage;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.logging.log4j.Logger;

public class GMSJoinLeave<ID extends MemberIdentifier>
implements JoinLeave<ID> {
    public static final String BYPASS_DISCOVERY_PROPERTY = "gemfire.bypass-discovery";
    private static final int DISCOVERY_TIMEOUT = Integer.getInteger("gemfire.discovery-timeout", 3000);
    private static final int JOIN_RETRY_SLEEP = Integer.getInteger("gemfire.join-retry-sleep", 1000);
    private static final long BROADCAST_MESSAGE_SLEEP_TIME = Long.getLong("gemfire.broadcast-message-sleep-time", 1000L);
    private static final int MAX_DISCOVERY_NODES = Integer.getInteger("gemfire.max-discovery-nodes", 30);
    private static final long VIEW_BROADCAST_INTERVAL = Long.getLong("gemfire.view-broadcast-interval", 60000L);
    private static final Logger logger = Services.getLogger();
    private static final boolean ALLOW_OLD_VERSION_FOR_TESTING = Boolean.getBoolean("gemfire.allow_old_members_to_join_for_testing");
    private int birthViewId;
    private ID localAddress;
    private Services<ID> services;
    private volatile boolean isJoined;
    @VisibleForTesting
    volatile boolean isCoordinator;
    private final Object viewInstallationLock = new Object();
    @VisibleForTesting
    volatile GMSMembershipView<ID> currentView;
    private volatile GMSMembershipView<ID> previousView;
    private final Set<ID> removedMembers = new HashSet<ID>();
    private final Set<ID> leftMembers = new HashSet<ID>();
    private volatile GMSMembershipView<ID> preparedView;
    private GMSMembershipView<ID> lastConflictingView;
    private List<HostAndPort> locators;
    private final List<AbstractGMSMessage<ID>> viewRequests = new LinkedList<AbstractGMSMessage<ID>>();
    long requestCollectionInterval = MembershipConfig.MEMBER_REQUEST_COLLECTION_INTERVAL;
    private final JoinResponseMessage<ID>[] joinResponse = new JoinResponseMessage[1];
    ViewReplyProcessor viewProcessor = new ViewReplyProcessor(false);
    ViewReplyProcessor prepareProcessor = new ViewReplyProcessor(true);
    private boolean quorumRequired = false;
    private long viewAckTimeout;
    private ViewCreator viewCreator;
    private volatile boolean isStopping;
    final SearchState<ID> searchState = new SearchState();
    Set<String> unitTesting = new HashSet<String>();
    private volatile boolean playingDead;
    GMSMembershipView<ID> quorumLostView;
    private final TcpClient locatorClient;

    public GMSJoinLeave(TcpClient locatorClient) {
        this.locatorClient = locatorClient;
    }

    Object getViewInstallationLock() {
        return this.viewInstallationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join() throws MemberStartupException {
        try {
            if (Boolean.getBoolean(BYPASS_DISCOVERY_PROPERTY)) {
                Object object = this.viewInstallationLock;
                synchronized (object) {
                    this.becomeCoordinator();
                }
                boolean bl = true;
                return bl;
            }
            SearchState<ID> state = this.searchState;
            long locatorWaitTime = (long)this.services.getConfig().getLocatorWaitTime() * 1000L;
            long timeout = this.services.getConfig().getJoinTimeout();
            logger.debug("join timeout is set to {}", (Object)timeout);
            long retrySleep = JOIN_RETRY_SLEEP;
            long startTime = System.currentTimeMillis();
            long locatorGiveUpTime = startTime + locatorWaitTime;
            long giveupTime = startTime + timeout;
            int minimumRetriesBeforeBecomingCoordinator = this.locators.size() * 2;
            int tries = 0;
            while (!this.isJoined && !this.isStopping) {
                logger.debug("searching for the membership coordinator");
                boolean found = this.findCoordinator();
                logger.info("Discovery state after looking for membership coordinator is {}", state);
                if (found) {
                    logger.info("found possible coordinator {}", state.possibleCoordinator);
                    if (this.localAddress.preferredForCoordinator() && state.possibleCoordinator.equals(this.localAddress)) {
                        if (state.joinedMembersContacted <= 0 && (tries >= minimumRetriesBeforeBecomingCoordinator || state.locatorsContacted >= this.locators.size())) {
                            Object object = this.viewInstallationLock;
                            synchronized (object) {
                                this.becomeCoordinator();
                            }
                            boolean bl = true;
                            return bl;
                        }
                    } else {
                        if (this.attemptToJoin()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (this.isStopping) break;
                        if (!state.possibleCoordinator.equals(this.localAddress)) {
                            state.alreadyTried.add(state.possibleCoordinator);
                        }
                        if (System.currentTimeMillis() > giveupTime) {
                            break;
                        }
                    }
                } else {
                    long now = System.currentTimeMillis();
                    if (state.locatorsContacted <= 0) {
                        if (now > locatorGiveUpTime) break;
                        tries = 0;
                        giveupTime = now + timeout;
                    } else if (now > giveupTime) break;
                }
                try {
                    if (found && !state.hasContactedAJoinedLocator) {
                        if (state.possibleCoordinator.getVmViewId() < 0) {
                            logger.debug("sleeping for {} before making another attempt to find the coordinator", (Object)retrySleep);
                            Thread.sleep(retrySleep);
                        } else {
                            tries = 0;
                            giveupTime = System.currentTimeMillis() + timeout;
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("retry sleep interrupted - giving up on joining the distributed system");
                    boolean bl = false;
                    if (this.isJoined) {
                        ID ID = this.localAddress;
                        synchronized (ID) {
                            this.localAddress.notifyAll();
                        }
                    }
                    this.searchState.cleanup();
                    return bl;
                }
                ++tries;
            }
            if (!this.isJoined) {
                logger.debug("giving up attempting to join the distributed system after " + (System.currentTimeMillis() - startTime) + "ms");
            }
            if (!this.isJoined && state.hasContactedAJoinedLocator) {
                throw new MemberStartupException("Unable to join the distributed system in " + (System.currentTimeMillis() - startTime) + "ms");
            }
            boolean bl = this.isJoined;
            return bl;
        }
        finally {
            if (this.isJoined) {
                ID ID = this.localAddress;
                synchronized (ID) {
                    this.localAddress.notifyAll();
                }
            }
            this.searchState.cleanup();
        }
    }

    @SuppressWarnings(value={"WA_NOT_IN_LOOP"})
    boolean attemptToJoin() throws MemberStartupException {
        JoinResponseMessage<ID> response;
        SearchState<ID> state = this.searchState;
        Object coord = state.possibleCoordinator;
        if (state.alreadyTried.contains(coord)) {
            logger.info("Probable coordinator is still {} - waiting for a join-response", coord);
        } else {
            logger.info("Attempting to join the distributed system through coordinator " + coord + " using address " + this.localAddress);
            int port = this.services.getHealthMonitor().getFailureDetectionPort();
            JoinRequestMessage req = new JoinRequestMessage(coord, this.localAddress, this.services.getAuthenticator().getCredentials(coord), port, this.services.getMessenger().getRequestId());
            this.services.getMessenger().send(req);
        }
        try {
            response = this.waitForJoinResponse();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        if (response == null) {
            if (!this.isJoined) {
                logger.debug("received no join response");
            }
            return this.isJoined;
        }
        logger.info("received join response {}", response);
        this.joinResponse[0] = null;
        String failReason = response.getRejectionMessage();
        if (failReason != null) {
            if (failReason.contains("Rejecting the attempt of a member using an older version") || failReason.contains("15806") || failReason.contains("ForcedDisconnectException")) {
                throw new MemberStartupException(failReason);
            }
            throw new SecurityException(failReason);
        }
        throw new RuntimeException("Join Request Failed with response " + response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JoinResponseMessage<ID> waitForJoinResponse() throws InterruptedException {
        JoinResponseMessage<ID>[] joinResponseMessageArray = this.joinResponse;
        synchronized (this.joinResponse) {
            if (this.joinResponse[0] == null && !this.isJoined) {
                long timeout = Math.max(this.services.getConfig().getMemberTimeout(), this.services.getConfig().getJoinTimeout() / 5L);
                this.joinResponse.wait(timeout);
            }
            JoinResponseMessage<ID> response = this.joinResponse[0];
            if (this.services.getConfig().getSecurityUDPDHAlgo().length() > 0) {
                if (response != null && response.getCurrentView() != null && !this.isJoined) {
                    this.joinResponse[0] = null;
                    GMSMembershipView<ID> v = response.getCurrentView();
                    ID coord = v.getCoordinator();
                    if (this.searchState.alreadyTried.contains(coord)) {
                        this.searchState.view = response.getCurrentView();
                        long timeout = Math.max(this.services.getConfig().getMemberTimeout(), this.services.getConfig().getJoinTimeout() / 5L);
                        this.joinResponse.wait(timeout);
                        response = this.joinResponse[0];
                    } else {
                        this.searchState.view = response.getCurrentView();
                        response = null;
                    }
                    this.searchState.view = v;
                }
                if (this.isJoined) {
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return null;
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemberLeaving(ID mbr) {
        if (this.getPendingRequestIDs(-152).contains(mbr) || this.getPendingRequestIDs(-153).contains(mbr) || !this.currentView.contains(mbr)) {
            return true;
        }
        Set<ID> set = this.removedMembers;
        synchronized (set) {
            if (this.removedMembers.contains(mbr)) {
                return true;
            }
        }
        set = this.leftMembers;
        synchronized (set) {
            if (this.leftMembers.contains(mbr)) {
                return true;
            }
        }
        return false;
    }

    void processMessage(JoinRequestMessage<ID> incomingRequest) {
        String rejection;
        if (this.isStopping) {
            return;
        }
        logger.info("Received a join request from {}", incomingRequest.getMemberID());
        if (!ALLOW_OLD_VERSION_FOR_TESTING && incomingRequest.getMemberID().getVersionOrdinal() < Version.getCurrentVersion().ordinal()) {
            logger.warn("detected an attempt to start a peer using an older version of the product {}", incomingRequest.getMemberID());
            JoinResponseMessage<ID> m = new JoinResponseMessage<ID>("Rejecting the attempt of a member using an older version of the product to join the distributed system", incomingRequest.getRequestId());
            m.setRecipient(incomingRequest.getMemberID());
            this.services.getMessenger().send(m);
            return;
        }
        Object creds = incomingRequest.getCredentials();
        try {
            rejection = this.services.getAuthenticator().authenticate(incomingRequest.getMemberID(), (Properties)creds);
        }
        catch (Exception e) {
            rejection = e.getMessage();
        }
        if (rejection != null && rejection.length() > 0) {
            JoinResponseMessage<ID> m = new JoinResponseMessage<ID>(rejection, 0);
            m.setRecipient(incomingRequest.getMemberID());
            this.services.getMessenger().send(m);
            return;
        }
        this.recordViewRequest(incomingRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(LeaveRequestMessage<ID> incomingRequest) {
        if (this.isStopping) {
            return;
        }
        logger.info("received leave request from {} for {}", incomingRequest.getSender(), incomingRequest.getMemberID());
        GMSMembershipView<ID> v = this.currentView;
        if (v == null) {
            this.recordViewRequest(incomingRequest);
            return;
        }
        ID mbr = incomingRequest.getMemberID();
        logger.info(() -> "JoinLeave.processMessage(LeaveRequestMessage) invoked.  isCoordinator=" + this.isCoordinator + "; isStopping=" + this.isStopping + "; cancelInProgress=" + this.services.getCancelCriterion().isCancelInProgress());
        if (!v.contains(mbr) && mbr.getVmViewId() < v.getViewId()) {
            logger.info("ignoring leave request from old member");
            return;
        }
        if (incomingRequest.getMemberID().equals(this.localAddress)) {
            logger.info("I am being told to leave the distributed system by {}", incomingRequest.getSender());
            this.forceDisconnect(incomingRequest.getReason());
            return;
        }
        if (!(this.isCoordinator || this.isStopping || this.services.getCancelCriterion().isCancelInProgress())) {
            logger.info("Checking to see if I should become coordinator.  My address is {}", this.localAddress);
            GMSMembershipView<ID> check = new GMSMembershipView<ID>(v, v.getViewId() + 1);
            check.remove(mbr);
            Set<ID> set = this.removedMembers;
            synchronized (set) {
                check.removeAll(this.removedMembers);
                check.addCrashedMembers(this.removedMembers);
            }
            set = this.leftMembers;
            synchronized (set) {
                this.leftMembers.add(mbr);
                check.removeAll(this.leftMembers);
            }
            ID coordinator = check.getCoordinator();
            logger.info("View with removed and left members removed is {} and coordinator would be {}", check, coordinator);
            if (coordinator.equals(this.localAddress)) {
                Object object = this.viewInstallationLock;
                synchronized (object) {
                    this.becomeCoordinator(mbr);
                }
            }
        } else if (!this.isStopping && !this.services.getCancelCriterion().isCancelInProgress()) {
            this.recordViewRequest(incomingRequest);
            this.viewProcessor.processLeaveRequest(incomingRequest.getMemberID());
            this.prepareProcessor.processLeaveRequest(incomingRequest.getMemberID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(RemoveMemberMessage<ID> incomingRequest) {
        if (this.isStopping) {
            return;
        }
        GMSMembershipView<ID> v = this.currentView;
        boolean fromMe = incomingRequest.getSender() == null || incomingRequest.getSender().equals(this.localAddress);
        ID mbr = incomingRequest.getMemberID();
        if (v != null && !v.contains(incomingRequest.getSender())) {
            logger.info("Membership ignoring removal request for " + mbr + " from non-member " + incomingRequest.getSender());
            return;
        }
        if (v == null) {
            return;
        }
        if (!fromMe) {
            logger.info("Membership received a request to remove " + mbr + " from " + incomingRequest.getSender() + " reason=" + incomingRequest.getReason());
        }
        if (mbr.equals(this.localAddress)) {
            this.forceDisconnect(incomingRequest.getReason());
            return;
        }
        if (this.getPendingRequestIDs(-153).contains(mbr)) {
            logger.debug("ignoring removal request as I already have a removal request for this member");
            return;
        }
        if (!(this.isCoordinator || this.isStopping || this.services.getCancelCriterion().isCancelInProgress())) {
            logger.debug("Checking to see if I should become coordinator");
            GMSMembershipView<ID> check = new GMSMembershipView<ID>(v, v.getViewId() + 1);
            Object object = this.removedMembers;
            synchronized (object) {
                this.removedMembers.add(mbr);
                check.addCrashedMembers(this.removedMembers);
                check.removeAll(this.removedMembers);
            }
            object = this.leftMembers;
            synchronized (object) {
                check.removeAll(this.leftMembers);
            }
            if (check.getCoordinator().equals(this.localAddress)) {
                object = this.viewInstallationLock;
                synchronized (object) {
                    this.becomeCoordinator(mbr);
                }
            }
        } else {
            if (!(this.isStopping || this.services.getCancelCriterion().isCancelInProgress() || this.getPendingRequestIDs(-152).contains(mbr))) {
                this.recordViewRequest(incomingRequest);
                this.viewProcessor.processRemoveRequest(mbr);
                this.prepareProcessor.processRemoveRequest(mbr);
            }
            if (this.isCoordinator && !v.contains(mbr)) {
                RemoveMemberMessage<ID> removeMemberMessage = new RemoveMemberMessage<ID>(mbr, mbr, incomingRequest.getReason());
                this.services.getMessenger().send(removeMemberMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void recordViewRequest(AbstractGMSMessage<ID> request) {
        try {
            List<AbstractGMSMessage<ID>> list = this.viewRequests;
            synchronized (list) {
                logger.debug("Recording the request to be processed in the next membership view");
                this.viewRequests.add(request);
                this.viewRequests.notifyAll();
            }
        }
        catch (Error | RuntimeException t) {
            logger.warn("unable to record a membership view request due to this exception", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AbstractGMSMessage<ID>> getViewRequests() {
        List<AbstractGMSMessage<ID>> list = this.viewRequests;
        synchronized (list) {
            return new LinkedList<AbstractGMSMessage<ID>>(this.viewRequests);
        }
    }

    ViewCreator getViewCreator() {
        return this.viewCreator;
    }

    void becomeCoordinator() {
        this.becomeCoordinator(null);
    }

    public void delayViewCreationForTest(int millis) {
        this.requestCollectionInterval = millis;
    }

    private void becomeCoordinator(ID oldCoordinator) {
        assert (Thread.holdsLock(this.viewInstallationLock));
        if (this.isCoordinator) {
            return;
        }
        logger.info("This member is becoming the membership coordinator with address {}", this.localAddress);
        this.isCoordinator = true;
        Locator<ID> locator = this.services.getLocator();
        if (locator != null) {
            locator.setIsCoordinator(true);
        }
        if (this.currentView == null) {
            GMSMembershipView<ID> newView = new GMSMembershipView<ID>(this.localAddress);
            newView.setFailureDetectionPort(this.localAddress, this.services.getHealthMonitor().getFailureDetectionPort());
            this.localAddress.setVmViewId(0);
            this.installView(newView);
            this.isJoined = true;
            this.createAndStartViewCreator(newView);
            this.startViewBroadcaster();
        } else {
            GMSMembershipView<ID> newView = this.copyCurrentViewAndAddMyAddress(oldCoordinator);
            this.createAndStartViewCreator(newView);
            this.startViewBroadcaster();
        }
    }

    private void createAndStartViewCreator(GMSMembershipView<ID> newView) {
        if (this.viewCreator == null || this.viewCreator.isShutdown()) {
            this.services.getMessenger().initClusterKey();
            this.viewCreator = new ViewCreator("Geode Membership View Creator");
            if (newView != null) {
                this.viewCreator.setInitialView(newView, newView.getNewMembers(), newView.getShutdownMembers(), newView.getCrashedMembers());
            }
            logger.info("ViewCreator starting on:" + this.localAddress);
            this.viewCreator.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GMSMembershipView<ID> copyCurrentViewAndAddMyAddress(ID oldCoordinator) {
        GMSMembershipView<ID> newView;
        boolean testing = this.unitTesting.contains("noRandomViewChange");
        HashSet<ID> leaving = new HashSet<ID>();
        Object object = this.viewInstallationLock;
        synchronized (object) {
            HashSet<ID> removals;
            ArrayList<ID> mbrs;
            int rand = testing ? 0 : GMSMembershipView.RANDOM.nextInt(10);
            int viewNumber = this.currentView.getViewId() + 5 + rand;
            if (this.localAddress.getVmViewId() < 0) {
                this.localAddress.setVmViewId(viewNumber);
            }
            if (!(mbrs = new ArrayList<ID>(this.currentView.getMembers())).contains(this.localAddress)) {
                mbrs.add(this.localAddress);
            }
            Set<ID> set = this.removedMembers;
            synchronized (set) {
                removals = new HashSet<ID>(this.removedMembers);
            }
            set = this.leftMembers;
            synchronized (set) {
                leaving.addAll(this.leftMembers);
            }
            if (oldCoordinator != null && !removals.contains(oldCoordinator)) {
                leaving.add(oldCoordinator);
            }
            mbrs.removeAll(removals);
            mbrs.removeAll(leaving);
            newView = new GMSMembershipView<ID>(this.localAddress, viewNumber, mbrs, leaving, removals);
            newView.setFailureDetectionPorts(this.currentView);
            newView.setPublicKeys(this.currentView);
            newView.setFailureDetectionPort(this.localAddress, this.services.getHealthMonitor().getFailureDetectionPort());
        }
        return newView;
    }

    private void sendRemoveMessages(List<ID> removals, List<String> reasons, Set<ID> oldIds) {
        Iterator<String> reason = reasons.iterator();
        for (MemberIdentifier mbr : removals) {
            if (!oldIds.contains(mbr)) {
                RemoveMemberMessage<MemberIdentifier> response = new RemoveMemberMessage<MemberIdentifier>(mbr, mbr, reason.next());
                this.services.getMessenger().send(response);
                continue;
            }
            reason.next();
        }
    }

    boolean isShuttingDown() {
        return this.services.getCancelCriterion().isCancelInProgress() || this.services.getManager().shutdownInProgress() || this.services.getManager().isCloseInProgress();
    }

    boolean prepareView(GMSMembershipView<ID> view, List<ID> newMembers) throws InterruptedException {
        if (this.isShuttingDown()) {
            throw new InterruptedException("shutting down");
        }
        return this.sendView(view, true, this.prepareProcessor);
    }

    void sendView(GMSMembershipView<ID> view, List<ID> newMembers) throws InterruptedException {
        if (this.isShuttingDown()) {
            throw new InterruptedException("shutting down");
        }
        this.sendView(view, false, this.viewProcessor);
    }

    private boolean sendView(GMSMembershipView<ID> view, boolean preparing, ViewReplyProcessor viewReplyProcessor) throws InterruptedException {
        int id = view.getViewId();
        InstallViewMessage<ID> msg = new InstallViewMessage<ID>(view, this.services.getAuthenticator().getCredentials(this.localAddress), preparing);
        ArrayList<ID> recips = new ArrayList<ID>(view.getMembers());
        recips.remove(this.localAddress);
        ArrayList<ID> responders = recips;
        if (!view.getCrashedMembers().isEmpty()) {
            recips = new ArrayList<ID>(recips);
            recips.addAll(view.getCrashedMembers());
        }
        if (preparing) {
            this.preparedView = view;
        } else {
            ViewCreator thread = this.viewCreator;
            if (this.isCoordinator && !this.localAddress.equals(view.getCoordinator()) && !this.localAddress.equals(view.getCreator()) && thread != null) {
                thread.markViewCreatorForShutdown(view.getCoordinator());
                this.isCoordinator = false;
            }
            this.installView(new GMSMembershipView<ID>(view, view.getViewId()));
        }
        if (recips.isEmpty()) {
            if (!preparing) {
                logger.info("no recipients for new view aside from myself");
            }
            return true;
        }
        logger.info((preparing ? "preparing" : "sending") + " new view " + view);
        msg.setRecipients(recips);
        Set<ID> pendingLeaves = this.getPendingRequestIDs(-152);
        Set<ID> pendingRemovals = this.getPendingRequestIDs(-153);
        pendingRemovals.removeAll(view.getCrashedMembers());
        viewReplyProcessor.initialize(id, new HashSet<ID>(responders));
        viewReplyProcessor.processPendingRequests(pendingLeaves, pendingRemovals);
        this.addPublicKeysToView(view);
        this.services.getMessenger().send(msg, view);
        if (preparing) {
            logger.debug("waiting for view responses");
            Set failedToRespond = viewReplyProcessor.waitForResponses();
            logger.info("finished waiting for responses to view preparation");
            Object conflictingViewSender = viewReplyProcessor.getConflictingViewSender();
            GMSMembershipView conflictingView = viewReplyProcessor.getConflictingView();
            if (conflictingView != null) {
                logger.warn("received a conflicting membership view from " + conflictingViewSender + " during preparation: " + conflictingView);
                return false;
            }
            if (!failedToRespond.isEmpty() && !this.services.getCancelCriterion().isCancelInProgress()) {
                logger.warn("these members failed to respond to the view change: " + failedToRespond);
                return false;
            }
        }
        return true;
    }

    private void addPublicKeysToView(GMSMembershipView<ID> view) {
        String sDHAlgo = this.services.getConfig().getSecurityUDPDHAlgo();
        if (sDHAlgo != null && !sDHAlgo.isEmpty()) {
            List<ID> members = view.getMembers();
            for (MemberIdentifier mbr : members) {
                if (!Objects.isNull(view.getPublicKey(mbr))) continue;
                byte[] pk = this.services.getMessenger().getPublicKey(mbr);
                view.setPublicKey(mbr, pk);
            }
        }
    }

    void processMessage(InstallViewMessage<ID> m) {
        if (this.isStopping) {
            return;
        }
        logger.debug("processing membership view message {}", m);
        GMSMembershipView<ID> view = m.getView();
        if (!(this.currentView == null || this.currentView.contains(m.getSender()) || this.preparedView != null && this.preparedView.contains(m.getSender()))) {
            logger.info("Ignoring the view {} from member {}, which is not in my current view {} ", view, m.getSender(), this.currentView);
            return;
        }
        if (this.currentView != null && view.getViewId() < this.currentView.getViewId()) {
            this.ackView(m);
            return;
        }
        boolean viewContainsMyNewAddress = false;
        if (!this.isJoined && !m.isPreparing()) {
            for (MemberIdentifier mbr : view.getMembers()) {
                if (!this.localAddress.equals(mbr)) continue;
                viewContainsMyNewAddress = true;
                break;
            }
        }
        if (m.isPreparing()) {
            if (this.preparedView != null && this.preparedView.getViewId() >= view.getViewId()) {
                if (this.preparedView.getViewId() != view.getViewId() || !this.preparedView.getCreator().equals(view.getCreator())) {
                    this.services.getMessenger().send(new ViewAckMessage(view.getViewId(), m.getSender(), this.preparedView));
                }
            } else {
                this.preparedView = view;
                for (MemberIdentifier mbr : view.getMembers()) {
                    if (!this.localAddress.equals(mbr)) continue;
                    this.birthViewId = mbr.getVmViewId();
                    this.localAddress.setVmViewId(this.birthViewId);
                    ID me = this.localAddress;
                    me.setVmViewId(this.birthViewId);
                    break;
                }
                this.ackView(m);
            }
        } else if (this.isJoined && this.currentView != null && !view.contains(this.localAddress)) {
            logger.fatal("This member is no longer in the membership view.  My ID is {} and the new view is {}", this.localAddress, view);
            this.forceDisconnect("This node is no longer in the membership view");
        } else {
            if (this.isJoined || viewContainsMyNewAddress) {
                this.installView(view);
            }
            if (!m.isRebroadcast()) {
                this.ackView(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceDisconnect(String reason) {
        this.isStopping = true;
        if (!this.isJoined) {
            this.joinResponse[0] = new JoinResponseMessage("Stopping due to ForcedDisconnectException caused by '" + reason + "'", -1);
            this.isJoined = false;
            JoinResponseMessage<ID>[] joinResponseMessageArray = this.joinResponse;
            synchronized (this.joinResponse) {
                this.joinResponse.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            this.services.getManager().forceDisconnect(reason);
        }
    }

    private void ackView(InstallViewMessage<ID> m) {
        if (!this.playingDead && m.getView().contains(m.getView().getCreator())) {
            this.services.getMessenger().send(new ViewAckMessage(m.getSender(), m.getView().getViewId(), m.isPreparing()));
        }
    }

    void processMessage(ViewAckMessage<ID> m) {
        if (this.isStopping) {
            return;
        }
        if (m.isPrepareAck()) {
            this.prepareProcessor.processViewResponse(m.getViewId(), m.getSender(), m.getAlternateView());
        } else {
            this.viewProcessor.processViewResponse(m.getViewId(), m.getSender(), m.getAlternateView());
        }
    }

    boolean findCoordinator() throws MemberStartupException {
        SearchState<ID> state = this.searchState;
        assert (this.localAddress != null);
        if (!state.hasContactedAJoinedLocator && state.registrants.size() >= this.locators.size() && state.view != null && state.viewId > state.lastFindCoordinatorInViewId) {
            state.lastFindCoordinatorInViewId = state.viewId;
            logger.info("using findCoordinatorFromView");
            return this.findCoordinatorFromView();
        }
        String dhalgo = this.services.getConfig().getSecurityUDPDHAlgo();
        FindCoordinatorRequest<ID> request = new FindCoordinatorRequest<ID>(this.localAddress, state.alreadyTried, state.viewId, this.services.getMessenger().getPublicKey(this.localAddress), this.services.getMessenger().getRequestId(), dhalgo);
        HashSet possibleCoordinators = new HashSet();
        HashSet coordinatorsWithView = new HashSet();
        long giveUpTime = System.currentTimeMillis() + (long)this.services.getConfig().getLocatorWaitTime() * 1000L;
        int connectTimeout = (int)this.services.getConfig().getMemberTimeout() * 2;
        boolean anyResponses = false;
        logger.debug("sending {} to {}", request, this.locators);
        state.hasContactedAJoinedLocator = false;
        state.locatorsContacted = 0;
        do {
            for (HostAndPort laddr : this.locators) {
                try {
                    boolean isMyOldAddress;
                    int viewId;
                    Object responseCoordinator;
                    Object o = this.locatorClient.requestToServer(laddr, request, connectTimeout, true);
                    FindCoordinatorResponse response = o instanceof FindCoordinatorResponse ? (FindCoordinatorResponse)o : null;
                    if (response == null) continue;
                    if (response.getRejectionMessage() != null) {
                        throw new MembershipConfigurationException(response.getRejectionMessage());
                    }
                    this.setCoordinatorPublicKey(response);
                    ++state.locatorsContacted;
                    if (response.getRegistrants() != null) {
                        state.registrants.addAll(response.getRegistrants());
                    }
                    logger.info("received {} from locator {}", (Object)response, (Object)laddr);
                    if (!state.hasContactedAJoinedLocator && response.getSenderId() != null && response.getSenderId().getVmViewId() >= 0) {
                        logger.info("Locator's address indicates it is part of a distributed system so I will not become membership coordinator on this attempt to join");
                        state.hasContactedAJoinedLocator = true;
                    }
                    if ((responseCoordinator = response.getCoordinator()) == null) continue;
                    anyResponses = true;
                    GMSMembershipView v = response.getView();
                    int n = viewId = v == null ? -1 : v.getViewId();
                    if (viewId > state.viewId) {
                        state.viewId = viewId;
                        state.view = v;
                        state.registrants.clear();
                    }
                    if (viewId > -1) {
                        coordinatorsWithView.add(responseCoordinator);
                    }
                    if (isMyOldAddress = this.services.getConfig().isReconnecting() && this.localAddress.equals(responseCoordinator) && responseCoordinator.getVmViewId() >= 0) continue;
                    possibleCoordinators.add(response.getCoordinator());
                }
                catch (IOException | ClassNotFoundException problem) {
                    logger.info("Exception thrown when contacting a locator", (Throwable)problem);
                    if (state.locatorsContacted != 0 || System.currentTimeMillis() >= giveUpTime) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.services.getCancelCriterion().checkCancelInProgress(e);
                        throw new MemberStartupException("Interrupted while trying to contact locators");
                    }
                }
            }
        } while (!anyResponses && System.currentTimeMillis() < giveUpTime);
        if (possibleCoordinators.isEmpty()) {
            return false;
        }
        if (coordinatorsWithView.size() > 0) {
            possibleCoordinators = coordinatorsWithView;
        }
        Iterator it = possibleCoordinators.iterator();
        if (possibleCoordinators.size() == 1) {
            state.possibleCoordinator = (MemberIdentifier)it.next();
        } else {
            MemberIdentifier oldest = (MemberIdentifier)it.next();
            while (it.hasNext()) {
                MemberIdentifier candidate = (MemberIdentifier)it.next();
                if (this.services.getMemberFactory().getComparator().compare(oldest, candidate) <= 0) continue;
                oldest = candidate;
            }
            state.possibleCoordinator = oldest;
        }
        logger.info("findCoordinator chose {} out of these possible coordinators: {}", state.possibleCoordinator, possibleCoordinators);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_NOT_IN_LOOP"})
    boolean findCoordinatorFromView() {
        ArrayList result;
        SearchState<ID> state = this.searchState;
        GMSMembershipView v = state.view;
        List<Object> recipients = new ArrayList(v.getMembers());
        logger.info("searching for coordinator in findCoordinatorFromView");
        if (recipients.size() > MAX_DISCOVERY_NODES && MAX_DISCOVERY_NODES > 0) {
            recipients = recipients.subList(0, MAX_DISCOVERY_NODES);
        }
        if (state.registrants != null) {
            recipients.addAll(state.registrants);
        }
        recipients.remove(this.localAddress);
        logger.info("sending FindCoordinatorRequests to {}", recipients);
        boolean testing = this.unitTesting.contains("findCoordinatorFromView");
        Set set = state.responses;
        synchronized (set) {
            String dhalgo;
            if (!testing) {
                state.responses.clear();
            }
            if (!(dhalgo = this.services.getConfig().getSecurityUDPDHAlgo()).isEmpty()) {
                for (MemberIdentifier memberIdentifier : recipients) {
                    ArrayList<MemberIdentifier> r = new ArrayList<MemberIdentifier>();
                    r.add(memberIdentifier);
                    FindCoordinatorRequest<MemberIdentifier> req = new FindCoordinatorRequest<MemberIdentifier>((MemberIdentifier)this.localAddress, state.alreadyTried, state.viewId, this.services.getMessenger().getPublicKey(this.localAddress), this.services.getMessenger().getRequestId(), dhalgo);
                    req.setRecipients(r);
                    this.services.getMessenger().send(req, v);
                }
            } else {
                FindCoordinatorRequest<Object> req = new FindCoordinatorRequest<Object>(this.localAddress, state.alreadyTried, state.viewId, this.services.getMessenger().getPublicKey(this.localAddress), this.services.getMessenger().getRequestId(), dhalgo);
                req.setRecipients(recipients);
                this.services.getMessenger().send(req, v);
            }
            try {
                if (!testing) {
                    state.responsesExpected = recipients.size();
                    state.responses.wait(DISCOVERY_TIMEOUT);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            result = new ArrayList(state.responses);
            state.responses.clear();
        }
        MemberIdentifier bestGuessCoordinator = null;
        if (this.localAddress.preferredForCoordinator()) {
            bestGuessCoordinator = (MemberIdentifier)this.localAddress;
        }
        state.joinedMembersContacted = 0;
        boolean bestGuessIsNotMember = true;
        for (FindCoordinatorResponse findCoordinatorResponse : result) {
            boolean suggestedIsNotMember;
            logger.info("findCoordinatorFromView processing {}", (Object)findCoordinatorResponse);
            Object suggestedCoordinator = findCoordinatorResponse.getCoordinator();
            if (findCoordinatorResponse.getSenderId().getVmViewId() >= 0) {
                ++state.joinedMembersContacted;
            }
            if (this.localAddress.equals(suggestedCoordinator) || state.alreadyTried.contains(suggestedCoordinator)) continue;
            boolean bl = suggestedIsNotMember = suggestedCoordinator.getVmViewId() < 0;
            if (suggestedIsNotMember) {
                if (bestGuessIsNotMember && (bestGuessCoordinator == null || bestGuessCoordinator.getMemberData().compareTo(suggestedCoordinator.getMemberData(), false) > 0)) {
                    bestGuessCoordinator = suggestedCoordinator;
                }
            } else if (bestGuessIsNotMember || suggestedCoordinator.getVmViewId() > bestGuessCoordinator.getVmViewId()) {
                bestGuessCoordinator = (MemberIdentifier)suggestedCoordinator;
                bestGuessIsNotMember = false;
            }
            logger.info("findCoordinatorFromView's best guess is now {}", (Object)bestGuessCoordinator);
        }
        state.possibleCoordinator = bestGuessCoordinator;
        return bestGuessCoordinator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(JoinResponseMessage<ID> rsp) {
        if (this.isStopping) {
            return;
        }
        JoinResponseMessage<ID>[] joinResponseMessageArray = this.joinResponse;
        synchronized (this.joinResponse) {
            if (!this.isJoined) {
                if (rsp.getRejectionMessage() != null) {
                    this.joinResponse[0] = rsp;
                    this.joinResponse.notifyAll();
                } else if (rsp.getCurrentView() == null) {
                    this.services.getMessenger().setClusterSecretKey(rsp.getSecretPk());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    JoinResponseMessage[] getJoinResponseMessage() {
        return this.joinResponse;
    }

    void setJoinResponseMessage(JoinResponseMessage<ID> jrm) {
        this.joinResponse[0] = jrm;
    }

    void processMessage(FindCoordinatorRequest<ID> req) {
        FindCoordinatorResponse<ID> resp;
        if (this.isStopping) {
            return;
        }
        if (this.isJoined) {
            GMSMembershipView<ID> v = this.currentView;
            resp = new FindCoordinatorResponse<ID>(v.getCoordinator(), this.localAddress, this.services.getMessenger().getPublicKey(v.getCoordinator()), req.getRequestId());
        } else {
            resp = new FindCoordinatorResponse<ID>(this.localAddress, this.localAddress, this.services.getMessenger().getPublicKey(this.localAddress), req.getRequestId());
        }
        resp.setRecipient(req.getMemberID());
        this.services.getMessenger().send(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(FindCoordinatorResponse<ID> resp) {
        if (this.isStopping) {
            return;
        }
        Set set = this.searchState.responses;
        synchronized (set) {
            this.searchState.responses.add(resp);
            if (this.searchState.responsesExpected <= this.searchState.responses.size()) {
                this.searchState.responses.notifyAll();
            }
        }
        this.setCoordinatorPublicKey(resp);
    }

    private void setCoordinatorPublicKey(FindCoordinatorResponse<ID> response) {
        if (response.getCoordinator() != null && response.getCoordinatorPublicKey() != null) {
            this.services.getMessenger().setPublicKey(response.getCoordinatorPublicKey(), response.getCoordinator());
        }
    }

    void processMessage(NetworkPartitionMessage<ID> msg) {
        if (this.isStopping) {
            return;
        }
        String str = "Membership coordinator " + msg.getSender() + " has declared that a network partition has occurred";
        this.forceDisconnect(str);
    }

    @Override
    public GMSMembershipView<ID> getView() {
        return this.currentView;
    }

    @Override
    public GMSMembershipView<ID> getPreviousView() {
        return this.previousView;
    }

    @Override
    public ID getMemberID() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void installView(GMSMembershipView<ID> newView) {
        Collection<ID> members;
        Set<ID> set = this.viewInstallationLock;
        // MONITORENTER : set
        if (this.currentView != null && this.currentView.getViewId() >= newView.getViewId()) {
            // MONITOREXIT : set
            return;
        }
        logger.info("received new view: {}\nold view is: {}", newView, this.currentView);
        if (this.currentView == null && !this.isJoined) {
            boolean found = false;
            members = newView.getMembers();
            for (MemberIdentifier mbr : members) {
                if (!this.localAddress.equals(mbr)) continue;
                found = true;
                this.birthViewId = mbr.getVmViewId();
                this.localAddress.setVmViewId(this.birthViewId);
                ID me = this.localAddress;
                me.setVmViewId(this.birthViewId);
                break;
            }
            if (!found) {
                logger.info("rejecting view (not yet joined)");
                // MONITOREXIT : set
                return;
            }
        }
        newView.correctWrongVersionIn(this.localAddress);
        if (this.isJoined && this.isNetworkPartition(newView, true) && this.quorumRequired) {
            Set<ID> crashes = newView.getActualCrashedMembers(this.currentView);
            this.forceDisconnect(String.format("Exiting due to possible network partition event due to loss of %s cache processes: %s", crashes.size(), crashes));
            // MONITOREXIT : set
            return;
        }
        this.previousView = this.currentView;
        this.currentView = newView;
        this.preparedView = null;
        this.lastConflictingView = null;
        this.services.installView(newView);
        if (!this.isJoined) {
            logger.debug("notifying join thread");
            this.isJoined = true;
            JoinResponseMessage<ID>[] crashes = this.joinResponse;
            // MONITORENTER : this.joinResponse
            this.joinResponse.notifyAll();
            // MONITOREXIT : crashes
        }
        if (!newView.getCreator().equals(this.localAddress)) {
            GMSMembershipView<ID> check = new GMSMembershipView<ID>(newView, newView.getViewId() + 1);
            members = this.leftMembers;
            // MONITORENTER : members
            check.removeAll(this.leftMembers);
            // MONITOREXIT : members
            members = this.removedMembers;
            // MONITORENTER : members
            check.removeAll(this.removedMembers);
            check.addCrashedMembers(this.removedMembers);
            // MONITOREXIT : members
            if (check.shouldBeCoordinator(this.localAddress)) {
                if (!this.isCoordinator) {
                    this.becomeCoordinator();
                }
            } else if (this.isCoordinator) {
                this.stopCoordinatorServices();
                this.isCoordinator = false;
            }
        }
        if (!this.isCoordinator) {
            List<AbstractGMSMessage<ID>> list = this.viewRequests;
            // MONITORENTER : list
            Iterator<AbstractGMSMessage<ID>> it = this.viewRequests.iterator();
            while (it.hasNext()) {
                AbstractGMSMessage<ID> m = it.next();
                if (m instanceof JoinRequestMessage) {
                    if (!this.currentView.contains(((JoinRequestMessage)m).getMemberID())) continue;
                    it.remove();
                    continue;
                }
                if (m instanceof LeaveRequestMessage) {
                    if (this.currentView.contains(((LeaveRequestMessage)m).getMemberID())) continue;
                    it.remove();
                    continue;
                }
                if (!(m instanceof RemoveMemberMessage) || this.currentView.contains(((RemoveMemberMessage)m).getMemberID())) continue;
                it.remove();
            }
            // MONITOREXIT : list
        }
        // MONITOREXIT : set
        set = this.removedMembers;
        // MONITORENTER : set
        this.removeMembersFromCollectionIfNotInView(this.removedMembers, this.currentView);
        // MONITOREXIT : set
        set = this.leftMembers;
        // MONITORENTER : set
        this.removeMembersFromCollectionIfNotInView(this.leftMembers, this.currentView);
        // MONITOREXIT : set
    }

    private void removeMembersFromCollectionIfNotInView(Collection<ID> members, GMSMembershipView<ID> currentView) {
        Iterator<ID> iterator = members.iterator();
        while (iterator.hasNext()) {
            if (currentView.contains((MemberIdentifier)iterator.next())) continue;
            iterator.remove();
        }
    }

    void sendNetworkPartitionMessage(GMSMembershipView<ID> view) {
        ArrayList<ID> recipients = new ArrayList<ID>(view.getMembers());
        recipients.remove(this.localAddress);
        NetworkPartitionMessage<ID> msg = new NetworkPartitionMessage<ID>(recipients);
        try {
            this.services.getMessenger().send(msg);
        }
        catch (RuntimeException e) {
            logger.debug("unable to send network partition message - continuing", (Throwable)e);
        }
    }

    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public GMSMembershipView<ID> getPreparedView() {
        return this.preparedView;
    }

    private boolean isNetworkPartition(GMSMembershipView<ID> newView, boolean logWeights) {
        if (this.currentView == null) {
            return false;
        }
        int oldWeight = this.currentView.memberWeight();
        int failedWeight = newView.getCrashedMemberWeight(this.currentView);
        if (failedWeight > 0 && logWeights) {
            int failurePoint;
            if (logger.isInfoEnabled() && newView.getCreator().equals(this.localAddress)) {
                newView.logCrashedMemberWeights(this.currentView, logger);
            }
            if (failedWeight > (failurePoint = (int)((double)Math.round(51.0 * (double)oldWeight) / 100.0)) && this.quorumLostView != newView) {
                this.quorumLostView = newView;
                logger.warn("total weight lost in this view change is {} of {}.  Quorum has been lost!", (Object)failedWeight, (Object)oldWeight);
                this.services.getManager().quorumLost(newView.getActualCrashedMembers(this.currentView), this.currentView);
                return true;
            }
        }
        return false;
    }

    private void stopCoordinatorServices() {
        if (this.viewCreator != null && !this.viewCreator.isShutdown()) {
            logger.debug("Shutting down ViewCreator");
            this.viewCreator.shutdown();
            try {
                this.viewCreator.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void startViewBroadcaster() {
        this.services.getTimer().schedule((TimerTask)new ViewBroadcaster(), VIEW_BROADCAST_INTERVAL, VIEW_BROADCAST_INTERVAL);
    }

    @Override
    public void emergencyClose() {
        this.isStopping = true;
        this.isJoined = false;
        this.stopCoordinatorServices();
        this.isCoordinator = false;
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
        this.playingDead = true;
    }

    @Override
    public void beHealthy() {
        this.playingDead = false;
    }

    @Override
    public void start() throws MemberStartupException {
    }

    @Override
    public void started() throws MemberStartupException {
    }

    @Override
    public void setLocalAddress(ID address) {
        ID mbr = this.localAddress = address;
        if (this.services.getConfig().areLocatorsPreferredAsCoordinators()) {
            boolean preferred = false;
            if (this.services.getLocator() != null || this.services.getConfig().getHasLocator() || !this.services.getConfig().getStartLocator().isEmpty() || this.localAddress.getVmKind() == 11) {
                logger.info("This member is hosting a locator will be preferred as a membership coordinator");
                preferred = true;
            }
            mbr.setPreferredForCoordinator(preferred);
        } else {
            mbr.setPreferredForCoordinator(true);
        }
    }

    @Override
    public void stop() {
        logger.debug("JoinLeave stopping");
        this.leave();
    }

    @Override
    public void stopped() {
    }

    @Override
    public void memberSuspected(ID initiator, ID suspect, String reason) {
        this.prepareProcessor.memberSuspected(suspect);
        this.viewProcessor.memberSuspected(suspect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave() {
        Object object = this.viewInstallationLock;
        synchronized (object) {
            GMSMembershipView view = this.currentView;
            this.isStopping = true;
            this.stopCoordinatorServices();
            if (view != null && view.size() > 1) {
                List<ID> coords = view.getPreferredCoordinators(Collections.emptySet(), this.localAddress, 5);
                logger.debug("Sending my leave request to {}", coords);
                LeaveRequestMessage<List<ID>> m = new LeaveRequestMessage<List<ID>>(coords, this.localAddress, "this member is shutting down");
                this.services.getMessenger().send(m);
            }
        }
    }

    @Override
    public void remove(ID m, String reason) {
        GMSMembershipView<Object> v = this.currentView;
        this.services.getCancelCriterion().checkCancelInProgress(null);
        if (v != null && v.contains(m)) {
            HashSet<ID> filter = new HashSet<ID>();
            filter.add(m);
            RemoveMemberMessage<ID> msg = new RemoveMemberMessage<ID>(v.getPreferredCoordinators(filter, this.getMemberID(), 5), m, reason);
            msg.setSender(this.localAddress);
            this.processMessage(msg);
            if (!this.isCoordinator) {
                msg.setRecipients(v.getPreferredCoordinators(Collections.emptySet(), this.localAddress, 10));
                this.services.getMessenger().send(msg);
            }
        } else {
            RemoveMemberMessage<ID> msg = new RemoveMemberMessage<ID>(m, m, reason);
            this.services.getMessenger().send(msg);
        }
    }

    @Override
    public void memberShutdown(ID mbr, String reason) {
        LeaveRequestMessage<List<ID>> msg = new LeaveRequestMessage<List<ID>>(Collections.singletonList(this.localAddress), mbr, reason);
        msg.setSender((List<ID>)mbr);
        this.processMessage(msg);
    }

    boolean checkIfAvailable(ID fmbr) {
        logger.info("checking state of member " + fmbr);
        if (this.services.getHealthMonitor().checkIfAvailable(fmbr, "Member failed to acknowledge a membership view", false)) {
            logger.info("member " + fmbr + " passed availability check");
            return true;
        }
        logger.info("member " + fmbr + " failed availability check");
        return false;
    }

    private ID getMemId(ID jgId, List<ID> members) {
        for (MemberIdentifier m : members) {
            if (!m.equals(jgId)) continue;
            return (ID)m;
        }
        return null;
    }

    @Override
    public ID getMemberID(ID member) {
        GMSMembershipView<ID> v = this.currentView;
        ID ret = null;
        if (v != null) {
            ret = this.getMemId(member, v.getMembers());
        }
        if (ret == null && (v = this.preparedView) != null) {
            ret = this.getMemId(member, v.getMembers());
        }
        if (ret == null) {
            return member;
        }
        return ret;
    }

    @Override
    public void disableDisconnectOnQuorumLossForTesting() {
        this.quorumRequired = false;
    }

    @Override
    public void init(Services<ID> s) throws MembershipConfigurationException {
        this.services = s;
        MembershipConfig config = this.services.getConfig();
        if (config.getMcastPort() != 0 && StringUtils.isBlank((CharSequence)config.getLocators()) && StringUtils.isBlank((CharSequence)config.getStartLocator())) {
            throw new MembershipConfigurationException("Multicast cannot be configured for a non-distributed cache.  Please configure the locator services for this cache using locators or start-locator.");
        }
        this.services.getMessenger().addHandler(JoinRequestMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(JoinResponseMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(InstallViewMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(ViewAckMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(LeaveRequestMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(RemoveMemberMessage.class, this::processMessage);
        this.services.getMessenger().addHandler(FindCoordinatorRequest.class, this::processMessage);
        this.services.getMessenger().addHandler(FindCoordinatorResponse.class, this::processMessage);
        this.services.getMessenger().addHandler(NetworkPartitionMessage.class, this::processMessage);
        long ackCollectionTimeout = config.getMemberTimeout() * 2L * 12437L / 10000L;
        if (ackCollectionTimeout < 1500L) {
            ackCollectionTimeout = 1500L;
        } else if (ackCollectionTimeout > 12437L) {
            ackCollectionTimeout = 12437L;
        }
        this.viewAckTimeout = ackCollectionTimeout = Long.getLong("gemfire.VIEW_ACK_TIMEOUT", ackCollectionTimeout).longValue();
        this.quorumRequired = config.isNetworkPartitionDetectionEnabled();
        String bindAddr = config.getBindAddress();
        this.locators = GMSUtil.parseLocators(config.getLocators(), bindAddr);
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed locators are {}", this.locators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ID> getPendingRequestIDs(int theDSFID) {
        HashSet result = new HashSet();
        List<AbstractGMSMessage<ID>> list = this.viewRequests;
        synchronized (list) {
            for (AbstractGMSMessage<ID> msg : this.viewRequests) {
                if (msg.getDSFID() != theDSFID) continue;
                result.add(((HasMemberID)((Object)msg)).getMemberID());
            }
        }
        return result;
    }

    protected ViewReplyProcessor getPrepareViewReplyProcessor() {
        return this.prepareProcessor;
    }

    protected boolean testPrepareProcessorWaiting() {
        return this.prepareProcessor.isWaiting();
    }

    static class ViewAbandonedException
    extends Exception {
        ViewAbandonedException() {
        }
    }

    class ViewCreator
    extends LoggingThread {
        volatile boolean shutdown;
        volatile boolean waiting;
        volatile boolean testFlagForRemovalRequest;
        volatile int abandonedViews;
        private boolean markViewCreatorForShutdown;
        GMSMembershipView<ID> initialView;
        List<ID> initialJoins;
        Set<ID> initialLeaving;
        Set<ID> initialRemovals;

        ViewCreator(String name) {
            super(name);
            this.shutdown = false;
            this.waiting = false;
            this.testFlagForRemovalRequest = false;
            this.abandonedViews = 0;
            this.markViewCreatorForShutdown = false;
            this.initialJoins = Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            this.setShutdownFlag();
            List list = GMSJoinLeave.this.viewRequests;
            synchronized (list) {
                GMSJoinLeave.this.viewRequests.notifyAll();
                this.interrupt();
            }
        }

        boolean isShutdown() {
            return this.shutdown;
        }

        boolean isWaiting() {
            return this.waiting;
        }

        int getAbandonedViewCount() {
            return this.abandonedViews;
        }

        synchronized void setInitialView(GMSMembershipView<ID> newView, List<ID> newMembers, Set<ID> leaving, Set<ID> removals) {
            this.initialView = newView;
            this.initialJoins = newMembers;
            this.initialLeaving = leaving;
            this.initialRemovals = removals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInitialView() {
            boolean retry;
            do {
                retry = false;
                try {
                    if (this.initialView == null) {
                        return;
                    }
                    GMSMembershipView v = GMSJoinLeave.this.preparedView;
                    if (v != null) {
                        this.processPreparedView(v);
                    }
                    try {
                        Set iRemoves;
                        Set iLeaves;
                        List iJoins;
                        GMSMembershipView iView;
                        ViewCreator viewCreator = this;
                        synchronized (viewCreator) {
                            iView = this.initialView;
                            iJoins = this.initialJoins;
                            iLeaves = this.initialLeaving;
                            iRemoves = this.initialRemovals;
                        }
                        if (iView != null) {
                            this.prepareAndSendView(iView, iJoins, iLeaves, iRemoves);
                        }
                    }
                    finally {
                        this.setInitialView(null, null, null, null);
                    }
                }
                catch (ViewAbandonedException e) {
                    retry = true;
                    try {
                        ViewCreator.sleep((long)GMSJoinLeave.this.services.getConfig().getMemberTimeout());
                    }
                    catch (InterruptedException e2) {
                        this.setShutdownFlag();
                        retry = false;
                    }
                }
                catch (InterruptedException e) {
                    this.setShutdownFlag();
                }
                catch (MembershipClosedException e) {
                    this.setShutdownFlag();
                }
            } while (retry);
        }

        private void setShutdownFlag() {
            this.shutdown = true;
        }

        private void markViewCreatorForShutdown(ID viewCreator) {
            logger.info("Marking view creator for shutdown because {} is now the coordinator.  My address is {}.  Net member IDs are {} and {} respectively", viewCreator, (Object)GMSJoinLeave.this.localAddress, viewCreator, (Object)GMSJoinLeave.this.localAddress);
            this.markViewCreatorForShutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPreparedView(GMSMembershipView<ID> v) {
            assert (this.initialView != null);
            if (GMSJoinLeave.this.currentView == null || GMSJoinLeave.this.currentView.getViewId() < v.getViewId()) {
                int viewId = Math.max(this.initialView.getViewId(), v.getViewId());
                GMSMembershipView<MemberIdentifier> newView = new GMSMembershipView<MemberIdentifier>(this.initialView, ++viewId);
                List newMembers = GMSJoinLeave.this.currentView != null ? v.getNewMembers(GMSJoinLeave.this.currentView) : v.getMembers();
                for (MemberIdentifier newMember : newMembers) {
                    newView.add(newMember);
                    newView.setFailureDetectionPort(newMember, v.getFailureDetectionPort(newMember));
                    newView.setPublicKey(newMember, v.getPublicKey(newMember));
                }
                Object object = this;
                synchronized (object) {
                    this.setInitialView(newView, newMembers, this.initialLeaving, this.initialRemovals);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            requests = null;
            GMSJoinLeave.access$100().info("View Creator thread is starting");
            this.sendInitialView();
            okayToCreateView = System.currentTimeMillis() + GMSJoinLeave.this.requestCollectionInterval;
            while (true) {
                var4_3 = GMSJoinLeave.access$600(GMSJoinLeave.this);
                // MONITORENTER : var4_3
                if (!this.shutdown) break block29;
                // MONITOREXIT : var4_3
                break;
            }
            catch (Throwable var11_17) {
                GMSJoinLeave.access$100().info("View Creator thread is exiting");
                this.setShutdownFlag();
                this.informToPendingJoinRequests();
                locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                if (locator == null) throw var11_17;
                locator.setIsCoordinator(false);
                throw var11_17;
            }
            {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                GMSJoinLeave.access$100().info("View Creator thread is exiting");
                                this.setShutdownFlag();
                                this.informToPendingJoinRequests();
                                locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                if (locator == null) return;
                                locator.setIsCoordinator(false);
                                return;
                            }
                            if (!GMSJoinLeave.access$600(GMSJoinLeave.this).isEmpty()) ** GOTO lbl66
                            try {
                                GMSJoinLeave.access$100().debug("View Creator is waiting for requests");
                                this.waiting = true;
                                GMSJoinLeave.access$600(GMSJoinLeave.this).wait();
                                this.waiting = false;
                            }
                            catch (InterruptedException e) {
                                this.waiting = false;
                                // MONITOREXIT : var4_3
                                GMSJoinLeave.access$100().info("View Creator thread is exiting");
                                this.setShutdownFlag();
                                this.informToPendingJoinRequests();
                                locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                if (locator == null) return;
                                locator.setIsCoordinator(false);
                                return;
                                catch (Throwable var7_14) {
                                    this.waiting = false;
                                    throw var7_14;
                                }
                            }
                            if (this.shutdown || Thread.currentThread().isInterrupted()) {
                                // MONITOREXIT : var4_3
                                GMSJoinLeave.access$100().info("View Creator thread is exiting");
                                this.setShutdownFlag();
                                this.informToPendingJoinRequests();
                                locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                if (locator == null) return;
                                locator.setIsCoordinator(false);
                                return;
                            }
                            if (GMSJoinLeave.access$600(GMSJoinLeave.this).size() == 1) {
                                okayToCreateView = System.currentTimeMillis() + GMSJoinLeave.this.requestCollectionInterval;
                                // MONITOREXIT : var4_3
                                continue;
                            }
                            ** GOTO lbl91
lbl66:
                            // 1 sources

                            timeRemaining = okayToCreateView - System.currentTimeMillis();
                            if (timeRemaining <= 0L) break block30;
                            try {
                                GMSJoinLeave.access$600(GMSJoinLeave.this).wait(Math.min(100L, timeRemaining));
                                // MONITOREXIT : var4_3
                                continue;
                            }
                            catch (InterruptedException e) {
                                // MONITOREXIT : var4_3
                                GMSJoinLeave.access$100().info("View Creator thread is exiting");
                                this.setShutdownFlag();
                                this.informToPendingJoinRequests();
                                locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                if (locator == null) return;
                                locator.setIsCoordinator(false);
                                return;
                            }
                        }
                        if (requests == null) {
                            requests = new ArrayList<AbstractGMSMessage<ID>>(GMSJoinLeave.access$600(GMSJoinLeave.this));
                        } else {
                            requests.addAll(GMSJoinLeave.access$600(GMSJoinLeave.this));
                        }
                        GMSJoinLeave.access$600(GMSJoinLeave.this).clear();
                        okayToCreateView = System.currentTimeMillis() + GMSJoinLeave.this.requestCollectionInterval;
lbl91:
                        // 2 sources

                        // MONITOREXIT : var4_3
                        if (requests == null || requests.isEmpty()) continue;
                        GMSJoinLeave.access$100().info("View Creator is processing {} requests for the next membership view ({})", (Object)requests.size(), requests);
                        this.createAndSendView(requests);
                        if (!this.shutdown) break block31;
                        GMSJoinLeave.access$100().info("View Creator thread is exiting");
                        this.setShutdownFlag();
                        this.informToPendingJoinRequests();
                        locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                        if (locator == null) return;
                        locator.setIsCoordinator(false);
                        return;
                    }
                    break block32;
                    catch (ViewAbandonedException e) {
                        timeRemaining = GMSJoinLeave.access$600(GMSJoinLeave.this);
                        // MONITORENTER : timeRemaining
                        GMSJoinLeave.access$600(GMSJoinLeave.this).addAll(requests);
                        // MONITOREXIT : timeRemaining
                        try {
                            ViewCreator.sleep((long)GMSJoinLeave.access$300(GMSJoinLeave.this).getConfig().getMemberTimeout());
                        }
                        catch (InterruptedException e2) {
                            this.setShutdownFlag();
                        }
                    }
                    catch (MembershipClosedException e) {
                        this.setShutdownFlag();
                    }
                    catch (InterruptedException e) {
                        GMSJoinLeave.access$100().info("View Creator thread interrupted");
                        this.setShutdownFlag();
                    }
                }
                requests = null;
                continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean informToPendingJoinRequests() {
            if (!this.shutdown) {
                return false;
            }
            GMSMembershipView v = GMSJoinLeave.this.currentView;
            if (v.getCoordinator().equals(GMSJoinLeave.this.localAddress)) {
                return false;
            }
            ArrayList<JoinRequestMessage> requests = new ArrayList<JoinRequestMessage>();
            List list = GMSJoinLeave.this.viewRequests;
            synchronized (list) {
                if (GMSJoinLeave.this.viewRequests.isEmpty()) {
                    return false;
                }
                for (AbstractGMSMessage msg : GMSJoinLeave.this.viewRequests) {
                    switch (msg.getDSFID()) {
                        case -142: {
                            requests.add((JoinRequestMessage)msg);
                            break;
                        }
                    }
                }
            }
            if (requests.isEmpty()) {
                return false;
            }
            for (JoinRequestMessage msg : requests) {
                logger.debug("Sending coordinator to pending join request from {} myid {} coord {}", msg.getSender(), (Object)GMSJoinLeave.this.localAddress, v.getCoordinator());
                JoinResponseMessage jrm = new JoinResponseMessage(msg.getMemberID(), v, msg.getRequestId());
                GMSJoinLeave.this.services.getMessenger().send(jrm);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void createAndSendView(List<AbstractGMSMessage<ID>> requests) throws InterruptedException, ViewAbandonedException {
            GMSMembershipView<Object> newView;
            Object mbr;
            ArrayList joinReqs = new ArrayList(10);
            HashMap joinPorts = new HashMap(10);
            HashSet leaveReqs = new HashSet(10);
            ArrayList<Object> removalReqs = new ArrayList<Object>(10);
            ArrayList<String> removalReasons = new ArrayList<String>(10);
            GMSMembershipView oldView = GMSJoinLeave.this.currentView;
            List<Object> oldMembers = oldView != null ? new ArrayList(oldView.getMembers()) : Collections.emptyList();
            HashSet oldIDs = new HashSet();
            block11: for (AbstractGMSMessage msg : requests) {
                logger.debug("processing request {}", msg);
                switch (msg.getDSFID()) {
                    case -142: {
                        JoinRequestMessage jmsg = (JoinRequestMessage)msg;
                        mbr = jmsg.getMemberID();
                        int port = jmsg.getFailureDetectionPort();
                        if (joinReqs.contains(mbr)) continue block11;
                        if (mbr.getVmViewId() >= 0 && oldMembers.contains(mbr)) {
                            logger.info("Ignoring join request from member {} who has already joined", mbr);
                            continue block11;
                        }
                        joinReqs.add(mbr);
                        joinPorts.put(mbr, port);
                        if (!GMSJoinLeave.this.services.getConfig().isUDPSecurityEnabled() && !GMSJoinLeave.this.services.getConfig().isMulticastEnabled()) continue block11;
                        JoinResponseMessage response = new JoinResponseMessage(jmsg.getSender(), GMSJoinLeave.this.services.getMessenger().getClusterSecretKey(), jmsg.getRequestId());
                        GMSJoinLeave.this.services.getMessenger().send(response);
                        continue block11;
                    }
                    case -152: {
                        mbr = ((LeaveRequestMessage)msg).getMemberID();
                        if (!oldMembers.contains(mbr) || leaveReqs.contains(mbr)) continue block11;
                        leaveReqs.add(mbr);
                        continue block11;
                    }
                    case -153: {
                        continue block11;
                    }
                }
                logger.warn("Unknown membership request encountered: {}", msg);
            }
            for (AbstractGMSMessage msg : requests) {
                switch (msg.getDSFID()) {
                    case -153: {
                        mbr = ((RemoveMemberMessage)msg).getMemberID();
                        if (leaveReqs.contains(mbr)) break;
                        if (oldMembers.contains(mbr) && !removalReqs.contains(mbr)) {
                            removalReqs.add(mbr);
                            removalReasons.add(((RemoveMemberMessage)msg).getReason());
                            break;
                        }
                        GMSJoinLeave.this.sendRemoveMessages(Collections.singletonList(mbr), Collections.singletonList(((RemoveMemberMessage)msg).getReason()), new HashSet());
                        break;
                    }
                }
            }
            for (MemberIdentifier mbr2 : oldIDs) {
                if (leaveReqs.contains(mbr2) || removalReqs.contains(mbr2)) continue;
                removalReqs.add(mbr2);
                removalReasons.add("Removal of old ID that has been reused");
            }
            if (removalReqs.isEmpty() && leaveReqs.isEmpty() && joinReqs.isEmpty()) {
                return;
            }
            Iterator iterator = GMSJoinLeave.this.viewInstallationLock;
            synchronized (iterator) {
                ArrayList<Object> mbrs;
                int viewNumber = 0;
                if (GMSJoinLeave.this.currentView == null) {
                    mbrs = new ArrayList();
                } else {
                    viewNumber = GMSJoinLeave.this.currentView.getViewId() + 1;
                    mbrs = new ArrayList(oldMembers);
                }
                mbrs.removeAll(leaveReqs);
                mbrs.removeAll(removalReqs);
                mbrs.addAll(joinReqs);
                newView = new GMSMembershipView<Object>(GMSJoinLeave.this.localAddress, viewNumber, mbrs, leaveReqs, new HashSet(removalReqs));
                for (MemberIdentifier mbr3 : joinReqs) {
                    if (!mbrs.contains(mbr3)) continue;
                    newView.setFailureDetectionPort(mbr3, (Integer)joinPorts.get(mbr3));
                }
                if (GMSJoinLeave.this.currentView != null) {
                    newView.setFailureDetectionPorts(GMSJoinLeave.this.currentView);
                    newView.setPublicKeys(GMSJoinLeave.this.currentView);
                }
            }
            if (joinReqs.isEmpty() && newView.getMembers().equals(GMSJoinLeave.this.currentView.getMembers())) {
                logger.info("membership hasn't changed - aborting new view {}", newView);
                return;
            }
            for (MemberIdentifier mbr4 : joinReqs) {
                if (mbr4.getVmViewId() >= 0) continue;
                mbr4.setVmViewId(newView.getViewId());
            }
            if (this.isShutdown()) {
                return;
            }
            GMSJoinLeave.this.sendRemoveMessages(removalReqs, removalReasons, oldIDs);
            this.prepareAndSendView(newView, joinReqs, leaveReqs, newView.getCrashedMembers());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prepareAndSendView(GMSMembershipView<ID> newView, List<ID> joinReqs, Set<ID> leaveReqs, Set<ID> removalReqs) throws InterruptedException, ViewAbandonedException {
            boolean prepared;
            do {
                boolean conflictingViewNotFromMe;
                if (this.shutdown || Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (GMSJoinLeave.this.quorumRequired && GMSJoinLeave.this.isNetworkPartition(newView, true)) {
                    GMSJoinLeave.this.sendNetworkPartitionMessage(newView);
                    Thread.sleep(BROADCAST_MESSAGE_SLEEP_TIME);
                    Set crashes = newView.getActualCrashedMembers(GMSJoinLeave.this.currentView);
                    GMSJoinLeave.this.forceDisconnect(String.format("Exiting due to possible network partition event due to loss of %s cache processes: %s", crashes.size(), crashes));
                    this.setShutdownFlag();
                    return;
                }
                prepared = GMSJoinLeave.this.prepareView(newView, joinReqs);
                logger.debug("view preparation phase completed.  prepared={}", (Object)prepared);
                GMSMembershipView conflictingView = GMSJoinLeave.this.prepareProcessor.getConflictingView();
                if (conflictingView == null) {
                    conflictingView = GMSJoinLeave.this.preparedView;
                }
                if (prepared) break;
                Set unresponsive = GMSJoinLeave.this.prepareProcessor.getUnresponsiveMembers();
                unresponsive.removeAll(removalReqs);
                unresponsive.removeAll(leaveReqs);
                if (!unresponsive.isEmpty()) {
                    this.removeHealthyMembers(unresponsive);
                    List list = GMSJoinLeave.this.viewRequests;
                    synchronized (list) {
                        unresponsive = new HashSet(unresponsive);
                    }
                }
                logger.debug("unresponsive members that could not be reached: {}", unresponsive);
                ArrayList failures = new ArrayList(GMSJoinLeave.this.currentView.getCrashedMembers().size() + unresponsive.size());
                boolean bl = conflictingViewNotFromMe = conflictingView != null && !conflictingView.getCreator().equals(GMSJoinLeave.this.localAddress) && conflictingView.getViewId() > newView.getViewId();
                if (conflictingViewNotFromMe) {
                    boolean conflictingViewIsMostRecent;
                    boolean bl2 = conflictingViewIsMostRecent = GMSJoinLeave.this.lastConflictingView == null || conflictingView.getViewId() > GMSJoinLeave.this.lastConflictingView.getViewId();
                    if (conflictingViewIsMostRecent) {
                        GMSJoinLeave.this.lastConflictingView = conflictingView;
                        if (GMSJoinLeave.this.localAddress.getVmKind() != 11 && conflictingView.getCreator().getVmKind() == 11) {
                            logger.info("View preparation interrupted - a locator is taking over as membership coordinator in this view: {}", (Object)conflictingView);
                            ++this.abandonedViews;
                            throw new ViewAbandonedException();
                        }
                        logger.info("adding these crashed members from a conflicting view to the crash-set for the next view: {}\nconflicting view: {}", unresponsive, (Object)conflictingView);
                        failures.addAll(conflictingView.getCrashedMembers());
                        if (failures.contains(GMSJoinLeave.this.localAddress)) {
                            GMSJoinLeave.this.forceDisconnect("I am no longer a member of the distributed system");
                            this.setShutdownFlag();
                            return;
                        }
                        List newMembers = conflictingView.getNewMembers();
                        if (!newMembers.isEmpty()) {
                            logger.info("adding these new members from a conflicting view to the new view: {}", newMembers);
                            for (Object mbr : newMembers) {
                                int port = conflictingView.getFailureDetectionPort(mbr);
                                newView.add(mbr);
                                newView.setFailureDetectionPort(mbr, port);
                                joinReqs.add(mbr);
                            }
                        }
                        if (conflictingView.getViewId() >= newView.getViewId()) {
                            newView = new GMSMembershipView(newView, conflictingView.getViewId() + 1);
                        }
                    }
                }
                if (!unresponsive.isEmpty()) {
                    logger.info("adding these unresponsive members to the crash-set for the next view: {}", unresponsive);
                    failures.addAll(unresponsive);
                }
                failures.removeAll(removalReqs);
                failures.removeAll(leaveReqs);
                prepared = failures.isEmpty();
                if (!prepared) {
                    Object mbr;
                    removalReqs.addAll(failures);
                    ArrayList newMembers = new ArrayList(newView.getMembers());
                    newMembers.removeAll(removalReqs);
                    GMSMembershipView<MemberIdentifier> tempView = new GMSMembershipView<MemberIdentifier>(GMSJoinLeave.this.localAddress, newView.getViewId() + 1, newMembers, leaveReqs, removalReqs);
                    List members = newView.getMembers();
                    mbr = members.iterator();
                    while (mbr.hasNext()) {
                        MemberIdentifier mbr2 = (MemberIdentifier)mbr.next();
                        if (!tempView.contains(mbr2)) continue;
                        tempView.setFailureDetectionPort(mbr2, newView.getFailureDetectionPort(mbr2));
                    }
                    newView = tempView;
                    int size = failures.size();
                    ArrayList<String> reasons = new ArrayList<String>(size);
                    for (int i = 0; i < size; ++i) {
                        reasons.add("Failed to acknowledge a new membership view and then failed tcp/ip connection attempt");
                    }
                    GMSJoinLeave.this.sendRemoveMessages(failures, reasons, new HashSet());
                }
                if (conflictingView != null) continue;
                prepared = true;
            } while (!prepared);
            GMSJoinLeave.this.lastConflictingView = null;
            GMSJoinLeave.this.sendView(newView, joinReqs);
            if (this.markViewCreatorForShutdown && GMSJoinLeave.this.getViewCreator() != null) {
                this.markViewCreatorForShutdown = false;
                this.setShutdownFlag();
            }
            if (GMSJoinLeave.this.isStopping()) {
                this.setShutdownFlag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHealthyMembers(final Set<ID> suspects) throws InterruptedException {
            ArrayList<1> checkers = new ArrayList<1>(suspects.size());
            HashSet newRemovals = new HashSet();
            HashSet newLeaves = new HashSet();
            this.filterMembers(suspects, newRemovals, (short)-153);
            this.filterMembers(suspects, newLeaves, (short)-152);
            newRemovals.removeAll(newLeaves);
            suspects.removeAll(newLeaves);
            for (final MemberIdentifier mbr : suspects) {
                if (newRemovals.contains(mbr) || newLeaves.contains(mbr)) continue;
                checkers.add(new Callable<ID>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ID call() throws Exception {
                        boolean available = GMSJoinLeave.this.checkIfAvailable(mbr);
                        List list = GMSJoinLeave.this.viewRequests;
                        synchronized (list) {
                            if (available) {
                                suspects.remove(mbr);
                            }
                            GMSJoinLeave.this.viewRequests.notifyAll();
                        }
                        return mbr;
                    }

                    public String toString() {
                        return mbr.toString();
                    }
                });
            }
            if (checkers.isEmpty()) {
                logger.debug("all unresponsive members are already scheduled to be removed");
                return;
            }
            logger.debug("checking availability of these members: {}", checkers);
            ExecutorService svc = LoggingExecutors.newFixedThreadPool((String)"Geode View Creator verification thread ", (boolean)true, (int)suspects.size());
            try {
                long giveUpTime = System.currentTimeMillis() + GMSJoinLeave.this.viewAckTimeout;
                this.submitAll(svc, checkers);
                long waitTime = giveUpTime - System.currentTimeMillis();
                List list = GMSJoinLeave.this.viewRequests;
                synchronized (list) {
                    while (waitTime > 0L) {
                        logger.debug("removeHealthyMembers: mbrs" + suspects.size());
                        this.filterMembers(suspects, newRemovals, (short)-153);
                        this.filterMembers(suspects, newLeaves, (short)-152);
                        newRemovals.removeAll(newLeaves);
                        suspects.removeAll(newLeaves);
                        if (suspects.isEmpty() || newRemovals.containsAll(suspects)) break;
                        GMSJoinLeave.this.viewRequests.wait(waitTime);
                        waitTime = giveUpTime - System.currentTimeMillis();
                    }
                }
            }
            finally {
                svc.shutdownNow();
            }
        }

        protected void filterMembers(Collection<ID> mbrs, Set<ID> matchingMembers, short requestType) {
            Set requests = GMSJoinLeave.this.getPendingRequestIDs(requestType);
            if (!requests.isEmpty()) {
                logger.debug("filterMembers: processing " + requests.size() + " requests for type " + requestType);
                for (MemberIdentifier memberID : requests) {
                    if (!mbrs.contains(memberID)) continue;
                    this.testFlagForRemovalRequest = true;
                    matchingMembers.add(memberID);
                }
            }
        }

        private <T> List<Future<T>> submitAll(ExecutorService executor, Collection<? extends Callable<T>> tasks) {
            ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> task : tasks) {
                result.add(executor.submit(task));
            }
            return result;
        }

        boolean getTestFlagForRemovalRequest() {
            return this.testFlagForRemovalRequest;
        }
    }

    class ViewBroadcaster
    extends TimerTask {
        ViewBroadcaster() {
        }

        @Override
        public void run() {
            if (!GMSJoinLeave.this.isCoordinator || GMSJoinLeave.this.isStopping) {
                this.cancel();
            } else {
                this.sendCurrentView();
            }
        }

        void sendCurrentView() {
            GMSMembershipView v = GMSJoinLeave.this.currentView;
            if (v != null) {
                InstallViewMessage msg = new InstallViewMessage(v, GMSJoinLeave.this.services.getAuthenticator().getCredentials(GMSJoinLeave.this.localAddress), false);
                ArrayList recips = new ArrayList(v.size() + v.getCrashedMembers().size());
                recips.addAll(v.getMembers());
                recips.remove(GMSJoinLeave.this.localAddress);
                recips.addAll(v.getCrashedMembers());
                msg.setRecipients(recips);
                GMSJoinLeave.this.services.getMessenger().sendUnreliably(msg);
            }
        }
    }

    class ViewReplyProcessor {
        volatile int viewId = -1;
        final Set<ID> notRepliedYet = new HashSet();
        GMSMembershipView<ID> conflictingView;
        ID conflictingViewSender;
        volatile boolean waiting;
        final boolean isPrepareViewProcessor;
        final Set<ID> pendingRemovals = new HashSet();

        ViewReplyProcessor(boolean forPreparation) {
            this.isPrepareViewProcessor = forPreparation;
        }

        synchronized void initialize(int viewId, Set<ID> recips) {
            this.waiting = true;
            this.viewId = viewId;
            this.notRepliedYet.clear();
            this.notRepliedYet.addAll(recips);
            this.conflictingView = null;
            this.pendingRemovals.clear();
        }

        boolean isWaiting() {
            return this.waiting;
        }

        synchronized void processPendingRequests(Set<ID> pendingLeaves, Set<ID> pendingRemovals) {
            for (MemberIdentifier mbr : pendingLeaves) {
                this.notRepliedYet.remove(mbr);
            }
            for (MemberIdentifier mbr : pendingRemovals) {
                if (!this.notRepliedYet.contains(mbr)) continue;
                this.pendingRemovals.add(mbr);
            }
        }

        synchronized void memberSuspected(ID suspect) {
            if (this.waiting) {
                logger.debug("view response processor recording suspect status for {}", suspect);
                if (this.notRepliedYet.contains(suspect) && !this.pendingRemovals.contains(suspect)) {
                    this.pendingRemovals.add(suspect);
                    this.checkIfDone();
                }
            }
        }

        synchronized void processLeaveRequest(ID mbr) {
            if (this.waiting) {
                logger.debug("view response processor recording leave request for {}", mbr);
                this.stopWaitingFor(mbr);
            }
        }

        synchronized void processRemoveRequest(ID mbr) {
            if (this.waiting) {
                logger.debug("view response processor recording remove request for {}", mbr);
                this.pendingRemovals.add(mbr);
                this.checkIfDone();
            }
        }

        synchronized void processViewResponse(int viewId, ID sender, GMSMembershipView<ID> conflictingView) {
            if (!this.waiting) {
                return;
            }
            if (viewId == this.viewId) {
                if (conflictingView != null) {
                    this.conflictingViewSender = sender;
                    this.conflictingView = conflictingView;
                }
                logger.debug("view response processor recording response for {}", sender);
                this.stopWaitingFor(sender);
            }
        }

        private void stopWaitingFor(ID mbr) {
            this.notRepliedYet.remove(mbr);
            this.checkIfDone();
        }

        private void checkIfDone() {
            if (this.notRepliedYet.isEmpty() || this.pendingRemovals.containsAll(this.notRepliedYet)) {
                logger.debug("All anticipated view responses received - notifying waiting thread");
                this.waiting = false;
                this.notifyAll();
            } else {
                logger.debug("Still waiting for these view replies: {}", this.notRepliedYet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Set<ID> waitForResponses() throws InterruptedException {
            HashSet result;
            ViewReplyProcessor viewReplyProcessor;
            long endOfWait = System.currentTimeMillis() + GMSJoinLeave.this.viewAckTimeout;
            try {
                while (System.currentTimeMillis() < endOfWait && !GMSJoinLeave.this.services.getCancelCriterion().isCancelInProgress()) {
                    try {
                        viewReplyProcessor = this;
                        synchronized (viewReplyProcessor) {
                            if (!this.waiting || this.notRepliedYet.isEmpty() || this.conflictingView != null) {
                                return result;
                            }
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.debug("Interrupted while waiting for view responses");
                        throw e;
                        return result;
                    }
                }
            }
            finally {
                viewReplyProcessor = this;
                synchronized (viewReplyProcessor) {
                    if (!this.waiting) {
                        result = new HashSet(this.pendingRemovals);
                    } else {
                        result = new HashSet(this.notRepliedYet);
                        result.addAll(this.pendingRemovals);
                        this.waiting = false;
                    }
                }
            }
        }

        GMSMembershipView<ID> getConflictingView() {
            return this.conflictingView;
        }

        ID getConflictingViewSender() {
            return this.conflictingViewSender;
        }

        synchronized Set<ID> getUnresponsiveMembers() {
            return new HashSet(this.notRepliedYet);
        }
    }

    static class SearchState<ID extends MemberIdentifier> {
        public int joinedMembersContacted;
        Set<ID> alreadyTried = new HashSet<ID>();
        Set<ID> registrants = new HashSet<ID>();
        ID possibleCoordinator;
        int viewId = -100;
        int locatorsContacted = 0;
        boolean hasContactedAJoinedLocator;
        GMSMembershipView<ID> view;
        int lastFindCoordinatorInViewId = -1000;
        final Set<FindCoordinatorResponse<ID>> responses = new HashSet<FindCoordinatorResponse<ID>>();
        public int responsesExpected;

        SearchState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            this.alreadyTried.clear();
            this.possibleCoordinator = null;
            this.view = null;
            Set<FindCoordinatorResponse<ID>> set = this.responses;
            synchronized (set) {
                this.responses.clear();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(200);
            sb.append("locatorsContacted=").append(this.locatorsContacted).append("; findInViewResponses=").append(this.joinedMembersContacted).append("; alreadyTried=").append(this.alreadyTried).append("; registrants=").append(this.registrants).append("; possibleCoordinator=").append(this.possibleCoordinator).append("; viewId=").append(this.viewId).append("; hasContactedAJoinedLocator=").append(this.hasContactedAJoinedLocator).append("; view=").append(this.view).append("; responses=").append(this.responses);
            return sb.toString();
        }
    }
}

