/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.UUID;

public class JGAddress
extends UUID {
    private static final long serialVersionUID = -1818672332115113291L;
    private static final boolean SHOW_UUIDS = Boolean.getBoolean("gemfire.show_UUIDs");
    private InetAddress ip_addr;
    private int port;
    private int vmViewId;

    public JGAddress() {
    }

    public JGAddress(MemberIdentifier mbr) {
        this.ip_addr = mbr.getInetAddress();
        this.port = mbr.getMembershipPort();
        this.mostSigBits = mbr.getUuidMostSignificantBits();
        this.leastSigBits = mbr.getUuidLeastSignificantBits();
        this.vmViewId = mbr.getVmViewId();
    }

    public JGAddress(UUID uuid, IpAddress ipaddr) {
        super(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.ip_addr = ipaddr.getIpAddress();
        this.port = ipaddr.getPort();
        this.vmViewId = -1;
    }

    public InetAddress getInetAddress() {
        return this.ip_addr;
    }

    public int getPort() {
        return this.port;
    }

    public int getVmViewId() {
        return this.vmViewId;
    }

    protected void setVmViewId(int id) {
        this.vmViewId = id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else {
            sb.append(this.ip_addr.getHostName());
        }
        if (this.vmViewId >= 0) {
            sb.append("<v").append(this.vmViewId).append('>');
        }
        if (SHOW_UUIDS) {
            sb.append("(").append(this.toStringLong()).append(")");
        } else if (this.mostSigBits == 0L && this.leastSigBits == 0L) {
            sb.append("(no uuid set)");
        }
        sb.append(":").append(this.port);
        return sb.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.readFrom(in);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void writeTo(DataOutput out) throws Exception {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
            if (this.ip_addr instanceof Inet6Address) {
                out.writeInt(((Inet6Address)this.ip_addr).getScopeId());
            }
        } else {
            out.writeByte(0);
        }
        out.writeShort(this.port);
        out.writeInt(this.vmViewId);
        out.writeLong(this.mostSigBits);
        out.writeLong(this.leastSigBits);
    }

    public long getUUIDMsbs() {
        return this.mostSigBits;
    }

    public long getUUIDLsbs() {
        return this.leastSigBits;
    }

    public void readFrom(DataInput in) throws Exception {
        byte len = in.readByte();
        if (len > 0 && len != 4 && len != 16) {
            throw new IOException("length has to be 4 or 16 bytes (was " + len + " bytes)");
        }
        byte[] a = new byte[len];
        in.readFully(a);
        if (len == 16) {
            int scope_id = in.readInt();
            this.ip_addr = Inet6Address.getByAddress(null, a, scope_id);
        } else {
            this.ip_addr = InetAddress.getByAddress(a);
        }
        this.port = in.readUnsignedShort();
        this.vmViewId = in.readInt();
        this.mostSigBits = in.readLong();
        this.leastSigBits = in.readLong();
    }

    public int size() {
        int tmp_size = 21;
        if (this.ip_addr != null) {
            tmp_size += this.ip_addr instanceof Inet4Address ? 4 : 20;
        }
        return tmp_size;
    }

    public JGAddress copy() {
        JGAddress result = new JGAddress();
        result.mostSigBits = this.mostSigBits;
        result.leastSigBits = this.leastSigBits;
        result.ip_addr = this.ip_addr;
        result.port = this.port;
        result.vmViewId = this.vmViewId;
        return result;
    }

    public IpAddress asIpAddress() {
        return new IpAddress(this.ip_addr, this.port);
    }
}

