/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.membership.api.LifecycleListener;
import org.apache.geode.distributed.internal.membership.api.MemberDisconnectedException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberShunnedException;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipListener;
import org.apache.geode.distributed.internal.membership.api.MembershipView;
import org.apache.geode.distributed.internal.membership.api.Message;
import org.apache.geode.distributed.internal.membership.api.MessageListener;
import org.apache.geode.distributed.internal.membership.api.QuorumChecker;
import org.apache.geode.distributed.internal.membership.api.StopShunningMarker;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.SuspectMember;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Manager;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.logging.log4j.Logger;

public class GMSMembership<ID extends MemberIdentifier>
implements Membership<ID> {
    private static final Logger logger = Services.getLogger();
    private volatile boolean disableMulticastForRollingUpgrade;
    private boolean wasReconnectingSystem;
    private boolean reconnectCompleted;
    private volatile QuorumChecker quorumChecker;
    private final ManagerImpl gmsManager;
    private final LifecycleListener<ID> lifecycleListener;
    private volatile boolean isCloseInProgress;
    private ExecutorService viewExecutor;
    private int membershipCheckTimeout = 1000;
    private final EventProcessingLock startupLock = new EventProcessingLock();
    private volatile MembershipView<ID> latestView = new MembershipView();
    private final ReadWriteLock latestViewLock = new ReentrantReadWriteLock();
    private final Lock latestViewReadLock = this.latestViewLock.readLock();
    private final Lock latestViewWriteLock = this.latestViewLock.writeLock();
    private final MembershipListener<ID> listener;
    private final MessageListener<ID> messageListener;
    private ID address = null;
    volatile boolean isJoining;
    private volatile boolean hasJoined;
    private final Map<ID, Long> shunnedMembers = new ConcurrentHashMap<ID, Long>();
    private final Map<ID, Object> shutdownMembers = new BoundedLinkedHashMap<ID, Object>();
    private final HashSet<ID> shunnedAndWarnedMembers = new HashSet();
    private final Map<ID, Long> surpriseMembers = new ConcurrentHashMap<ID, Long>();
    private long surpriseMemberTimeout;
    private final Map<ID, Long> suspectedMembers = new ConcurrentHashMap<ID, Long>();
    private static final int SHUNNED_SUNSET = Integer.getInteger("gemfire.shunned-member-timeout", 300);
    private volatile boolean shutdownInProgress = false;
    private volatile boolean processingEvents = false;
    private boolean startupMessagesDrained = false;
    private long latestViewId = -1L;
    private final LinkedList<StartupEvent<ID>> startupMessages = new LinkedList();
    private final HashMap<ID, CountDownLatch> memberLatch = new HashMap();
    private ScheduledExecutorService cleanupTimer;
    private Services<ID> services;
    private final Object startupMutex = new Object();
    @MakeNotStatic
    private static volatile boolean inhibitForceDisconnectLogging;
    private volatile boolean beingSick;
    private volatile boolean playingDead;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processView(long newViewId, MembershipView<ID> newView) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder(200);
            msg.append("Membership: Processing view ");
            msg.append(newView);
            msg.append("} on ").append(this.address.toString());
            logger.debug((CharSequence)msg);
            if (!newView.contains((MemberIdentifier)this.address)) {
                logger.info("The Member with id {}, is no longer in my own view, {}", this.address, newView);
            }
        }
        this.latestViewWriteLock.lock();
        try {
            MemberIdentifier m;
            int i;
            Version version = Version.CURRENT;
            for (Map.Entry<ID, Long> internalIDLongEntry : this.surpriseMembers.entrySet()) {
                MemberIdentifier mbr = (MemberIdentifier)internalIDLongEntry.getKey();
                Version itsVersion = mbr.getVersionObject();
                if (itsVersion == null || version.compareTo(itsVersion) >= 0) continue;
                version = itsVersion;
            }
            for (MemberIdentifier mbr : newView.getMembers()) {
                Version itsVersion = mbr.getVersionObject();
                if (itsVersion == null || itsVersion.compareTo(version) >= 0) continue;
                version = mbr.getVersionObject();
            }
            this.disableMulticastForRollingUpgrade = !version.equals(Version.CURRENT);
            MembershipView<ID> priorView = this.latestView;
            if (newViewId < (long)priorView.getViewId()) {
                return;
            }
            long newlatestViewId = newViewId;
            MembershipView<MemberIdentifier> newlatestView = new MembershipView<MemberIdentifier>(newView, newView.getViewId());
            for (i = 0; i < newView.getMembers().size(); ++i) {
                CountDownLatch currentLatch;
                boolean isSecure;
                m = (MemberIdentifier)newView.getMembers().get(i);
                boolean wasSurprise = this.surpriseMembers.containsKey(m);
                if (wasSurprise) {
                    Iterator<Map.Entry<ID, Long>> iterator = this.surpriseMembers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<ID, Long> entry = iterator.next();
                        if (!((MemberIdentifier)entry.getKey()).equals(m)) continue;
                        ((MemberIdentifier)entry.getKey()).setMemberData(m.getMemberData());
                        iterator.remove();
                        break;
                    }
                }
                this.suspectedMembers.remove(m);
                if (priorView.contains(m) || wasSurprise) continue;
                String authInit = this.services.getConfig().getSecurityPeerAuthInit();
                boolean bl = isSecure = authInit != null && authInit.length() != 0;
                if (isSecure && (currentLatch = this.memberLatch.get(m)) != null) {
                    currentLatch.countDown();
                }
                if (this.shutdownInProgress()) {
                    this.addShunnedMember(m);
                    continue;
                }
                boolean wasShunned = this.endShun(m);
                if (wasShunned && logger.isDebugEnabled()) {
                    logger.debug("No longer shunning {} as it is in the current membership view", (Object)m);
                }
                logger.info("Membership: Processing addition <{}>", (Object)m);
                this.listener.newMemberConnected(m);
            }
            for (i = 0; i < priorView.getMembers().size(); ++i) {
                m = (MemberIdentifier)priorView.getMembers().get(i);
                if (newView.contains(m) || this.surpriseMembers.containsKey(m)) continue;
                try {
                    this.removeWithViewLock(m, newView.getCrashedMembers().contains(m) || this.suspectedMembers.containsKey(m), "departed membership view");
                    continue;
                }
                catch (VirtualMachineError err) {
                    throw err;
                }
                catch (Throwable t) {
                    logger.info(String.format("Membership: Fault while processing view removal of %s", m), t);
                }
            }
            long oldestAllowed = System.currentTimeMillis() - this.surpriseMemberTimeout;
            Iterator<Map.Entry<ID, Long>> it = this.surpriseMembers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ID, Long> entry = it.next();
                Long birthtime = entry.getValue();
                if (birthtime < oldestAllowed) {
                    it.remove();
                    MemberIdentifier m2 = (MemberIdentifier)entry.getKey();
                    logger.info("Membership: expiring membership of surprise member <{}>", (Object)m2);
                    this.removeWithViewLock(m2, true, "not seen in membership view in " + this.surpriseMemberTimeout + "ms");
                    continue;
                }
                if (newlatestView.contains((MemberIdentifier)entry.getKey())) continue;
                newlatestView.add((MemberIdentifier)entry.getKey());
            }
            long suspectMemberTimeout = 180000L;
            oldestAllowed = System.currentTimeMillis() - 180000L;
            Iterator<Map.Entry<ID, Long>> it2 = this.suspectedMembers.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<ID, Long> entry = it2.next();
                Long birthtime = entry.getValue();
                if (birthtime >= oldestAllowed) continue;
                it2.remove();
            }
            newlatestView.makeUnmodifiable();
            this.latestView = newlatestView;
            this.listener.viewInstalled(this.latestView);
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    @Override
    public <V> V doWithViewLocked(Supplier<V> function) {
        this.latestViewReadLock.lock();
        try {
            V v = function.get();
            return v;
        }
        finally {
            this.latestViewReadLock.unlock();
        }
    }

    public boolean isCleanupTimerStarted() {
        return this.cleanupTimer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() throws MemberStartupException {
        this.services.setShutdownCause(null);
        this.services.getCancelCriterion().cancel(null);
        this.latestViewWriteLock.lock();
        try {
            try {
                this.isJoining = true;
                boolean ok = this.services.getJoinLeave().join();
                if (!ok) {
                    throw new MembershipConfigurationException("Unable to join the distributed system.  Operation either timed out, was stopped or Locator does not exist.");
                }
                MembershipView<ID> initialView = this.createGeodeView(this.services.getJoinLeave().getView());
                this.latestView = new MembershipView<ID>(initialView, initialView.getViewId());
                this.latestView.makeUnmodifiable();
                this.listener.viewInstalled(this.latestView);
            }
            finally {
                this.isJoining = false;
            }
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    private MembershipView<ID> createGeodeView(GMSMembershipView<ID> view) {
        MembershipView<ID> result = this.createGeodeView(view.getCreator(), view.getViewId(), view.getMembers(), view.getShutdownMembers(), view.getCrashedMembers());
        result.makeUnmodifiable();
        return result;
    }

    private MembershipView<ID> createGeodeView(ID gmsCreator, int viewId, List<ID> gmsMembers, Set<ID> gmsShutdowns, Set<ID> gmsCrashes) {
        ID geodeCreator = gmsCreator;
        ArrayList<MemberIdentifier> geodeMembers = new ArrayList<MemberIdentifier>(gmsMembers.size());
        for (MemberIdentifier member : gmsMembers) {
            geodeMembers.add(member);
        }
        Set<ID> geodeShutdownMembers = this.gmsMemberCollectionToIDSet(gmsShutdowns);
        Set<ID> geodeCrashedMembers = this.gmsMemberCollectionToIDSet(gmsCrashes);
        return new MembershipView<ID>(geodeCreator, viewId, geodeMembers, geodeShutdownMembers, geodeCrashedMembers);
    }

    private Set<ID> gmsMemberCollectionToIDSet(Collection<ID> gmsMembers) {
        if (gmsMembers.size() == 0) {
            return Collections.emptySet();
        }
        if (gmsMembers.size() == 1) {
            return Collections.singleton(gmsMembers.iterator().next());
        }
        HashSet<MemberIdentifier> idmMembers = new HashSet<MemberIdentifier>(gmsMembers.size());
        for (MemberIdentifier member : gmsMembers) {
            idmMembers.add(member);
        }
        return idmMembers;
    }

    private List<ID> gmsMemberListToIDList(List<ID> gmsMembers) {
        if (gmsMembers.size() == 0) {
            return Collections.emptyList();
        }
        if (gmsMembers.size() == 1) {
            return Collections.singletonList(gmsMembers.get(0));
        }
        ArrayList<MemberIdentifier> idmMembers = new ArrayList<MemberIdentifier>(gmsMembers.size());
        for (MemberIdentifier member : gmsMembers) {
            idmMembers.add(member);
        }
        return idmMembers;
    }

    public GMSMembership(MembershipListener<ID> listener, MessageListener<ID> messageListener, LifecycleListener<ID> lifecycleListener) {
        this.lifecycleListener = lifecycleListener;
        this.listener = listener;
        this.messageListener = messageListener;
        this.gmsManager = new ManagerImpl();
        this.viewExecutor = LoggingExecutors.newSingleThreadExecutor((String)"Geode View Processor", (boolean)true);
    }

    public Manager<ID> getGMSManager() {
        return this.gmsManager;
    }

    @Override
    public boolean testMulticast() {
        try {
            return this.services.getMessenger().testMulticast(this.services.getConfig().getMemberTimeout());
        }
        catch (InterruptedException e) {
            this.services.getCancelCriterion().checkCancelInProgress(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void removeWithViewLock(ID dm, boolean crashed, String reason) {
        boolean wasShunned = this.isShunned(dm);
        this.destroyMember(dm, reason);
        if (wasShunned) {
            return;
        }
        this.listener.memberDeparted(dm, crashed, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferSurpriseConnect(ID member) {
        if (!this.processingEvents) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (!this.startupMessagesDrained) {
                    this.startupMessages.add(new StartupEvent<ID>(member));
                    return;
                }
            }
        }
        this.processSurpriseConnect(member);
    }

    @Override
    public void startupMessageFailed(ID mbr, String failureMessage) {
        this.addShunnedMember(mbr);
        this.listener.memberDeparted(mbr, true, "failed to pass startup checks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSurpriseMember(ID dm) {
        ID member = dm;
        boolean warn = false;
        this.latestViewWriteLock.lock();
        try {
            if (this.latestView.contains((MemberIdentifier)member)) {
                boolean bl = true;
                return bl;
            }
            if (this.surpriseMembers.containsKey(member)) {
                boolean bl = true;
                return bl;
            }
            if (member.getVmViewId() < 0) {
                logger.warn("adding a surprise member that has not yet joined the distributed system: " + member, (Throwable)new Exception("stack trace"));
            }
            if (this.latestView.getViewId() > member.getVmViewId()) {
                new LoggingThread("Removing shunned GemFire node " + member, false, () -> {
                    logger.warn("attempt to add old member: {} as surprise member to {}", (Object)member, this.latestView);
                    try {
                        this.requestMemberRemoval(member, "this member is no longer in the view but is initiating connections");
                    }
                    catch (MemberDisconnectedException | MembershipClosedException exception) {
                        // empty catch block
                    }
                }).start();
                this.addShunnedMember(member);
                boolean bl = false;
                return bl;
            }
            this.surpriseMembers.put(member, System.currentTimeMillis());
            if (this.shutdownInProgress()) {
                String msg = "This distributed system is shutting down.";
                this.destroyMember(member, msg);
                boolean bl = true;
                return bl;
            }
            if (this.isShunned(member)) {
                warn = true;
                this.surpriseMembers.remove(member);
            } else {
                MembershipView<ID> newMembers = new MembershipView<ID>(this.latestView, this.latestView.getViewId());
                newMembers.add(member);
                newMembers.makeUnmodifiable();
                this.latestView = newMembers;
            }
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
        if (warn) {
            logger.warn("Membership: Ignoring surprise connect from shunned member <{}>", member);
        } else {
            this.listener.newMemberConnected(member);
        }
        return !warn;
    }

    private void startCleanupTimer() {
        this.cleanupTimer = LoggingExecutors.newScheduledThreadPool((String)"GMSMembership.cleanupTimer", (int)1, (boolean)false);
        this.cleanupTimer.scheduleAtFixedRate(this::cleanUpSurpriseMembers, this.surpriseMemberTimeout, this.surpriseMemberTimeout / 3L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpSurpriseMembers() {
        this.latestViewWriteLock.lock();
        try {
            long oldestAllowed = System.currentTimeMillis() - this.surpriseMemberTimeout;
            Iterator<Map.Entry<ID, Long>> it = this.surpriseMembers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ID, Long> entry = it.next();
                Long birthtime = entry.getValue();
                if (birthtime >= oldestAllowed) continue;
                it.remove();
                MemberIdentifier m = (MemberIdentifier)entry.getKey();
                logger.info("Membership: expiring membership of surprise member <{}>", (Object)m);
                this.removeWithViewLock(m, true, "not seen in membership view in " + this.surpriseMemberTimeout + "ms");
            }
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferMessage(Message<ID> msg) throws MemberShunnedException {
        if (msg.dropMessageWhenMembershipIsPlayingDead() && (this.beingSick || this.playingDead)) {
            return;
        }
        if (!this.processingEvents) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (!this.startupMessagesDrained) {
                    this.startupMessages.add(new StartupEvent<ID>(msg));
                    return;
                }
            }
        }
        this.dispatchMessage(msg);
    }

    @Override
    public void warnShun(ID m) {
        this.latestViewWriteLock.lock();
        try {
            if (!this.shunnedMembers.containsKey(m)) {
                return;
            }
            if (this.shunnedAndWarnedMembers.contains(m)) {
                return;
            }
            this.shunnedAndWarnedMembers.add(m);
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
        logger.warn("Membership: disregarding shunned member <{}>", m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchMessage(Message<ID> msg) throws MemberShunnedException {
        ID m = msg.getSender();
        boolean shunned = false;
        if (this.isShunnedOrNew(m)) {
            this.latestViewWriteLock.lock();
            try {
                if (this.isShunned(m)) {
                    if (msg instanceof StopShunningMarker) {
                        this.endShun(m);
                    } else {
                        shunned = true;
                    }
                }
                if (!shunned && this.isNew(m)) {
                    shunned = !this.addSurpriseMember(m);
                }
            }
            finally {
                this.latestViewWriteLock.unlock();
            }
        }
        if (shunned) {
            this.warnShun(m);
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Ignoring message from shunned member <{}>:{}", m, msg);
            }
            throw new MemberShunnedException();
        }
        this.messageListener.messageReceived(msg);
    }

    public void replacePartialIdentifierInMessage(Message<ID> msg) {
        ID sender;
        ID oldID = sender = msg.getSender();
        ID newID = this.services.getJoinLeave().getMemberID(oldID);
        if (newID != null && newID != oldID) {
            sender.setMemberData(newID.getMemberData());
            sender.setIsPartial(false);
        } else {
            MembershipView<ID> currentView = this.latestView;
            if (currentView != null) {
                sender = currentView.getCanonicalID(sender);
            }
        }
        if (!sender.isPartial()) {
            msg.setSender(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleOrDeferViewEvent(MembershipView<ID> viewArg) {
        if (this.isJoining) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                this.startupMessages.add(new StartupEvent<ID>(viewArg));
                return;
            }
        }
        this.latestViewWriteLock.lock();
        try {
            if (!this.processingEvents) {
                EventProcessingLock eventProcessingLock = this.startupLock;
                synchronized (eventProcessingLock) {
                    if (!this.startupMessagesDrained) {
                        this.startupMessages.add(new StartupEvent<ID>(viewArg));
                        return;
                    }
                }
            }
            this.viewExecutor.submit(() -> this.processView(viewArg.getViewId(), viewArg));
            return;
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    private ID gmsMemberToDMember(ID gmsMember) {
        return gmsMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferSuspect(SuspectMember<ID> suspectInfo) {
        this.latestViewWriteLock.lock();
        try {
            if (!this.processingEvents) {
                return;
            }
            Object suspect = this.gmsMemberToDMember(suspectInfo.suspectedMember);
            Object who = this.gmsMemberToDMember(suspectInfo.whoSuspected);
            this.suspectedMembers.put(suspect, System.currentTimeMillis());
            this.listener.memberSuspect(suspect, who, suspectInfo.reason);
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    private void processSurpriseConnect(ID member) {
        this.addSurpriseMember(member);
    }

    private void processStartupEvent(StartupEvent<ID> o) {
        if (o.isDistributionMessage()) {
            try {
                o.dmsg.setSender(this.latestView.getCanonicalID(o.dmsg.getSender()));
                this.dispatchMessage(o.dmsg);
            }
            catch (MemberShunnedException memberShunnedException) {}
        } else if (o.isGmsView()) {
            this.processView(o.gmsView.getViewId(), o.gmsView);
        } else if (o.isSurpriseConnect()) {
            this.processSurpriseConnect(o.member);
        } else {
            throw new IllegalArgumentException("unknown startup event: " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startEventProcessing() {
        Object object = this.startupMutex;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: draining startup events.");
            }
            while (true) {
                StartupEvent<ID> ev;
                EventProcessingLock eventProcessingLock = this.startupLock;
                synchronized (eventProcessingLock) {
                    int remaining = this.startupMessages.size();
                    if (remaining == 0) {
                        this.startupMessagesDrained = true;
                        this.processingEvents = true;
                        this.startupLock.notifyAll();
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 7, 9] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("Membership: finished processing startup events.");
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Membership: {} remaining startup message(s)", (Object)remaining);
                    }
                    ev = this.startupMessages.removeFirst();
                }
                try {
                    this.processStartupEvent(ev);
                    continue;
                }
                catch (VirtualMachineError err) {
                    throw err;
                }
                catch (Throwable t) {
                    logger.warn("Membership: Error handling startup event", t);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEventProcessing() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.processingEvents) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: waiting until the system is ready for events");
        }
        while (true) {
            this.services.getCancelCriterion().checkCancelInProgress(null);
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (this.processingEvents && this.startupMessagesDrained) {
                    break;
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.startupLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.services.getCancelCriterion().checkCancelInProgress(e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: continuing");
        }
    }

    public List<StartupEvent<ID>> getStartupEvents() {
        return this.startupMessages;
    }

    @Override
    public MembershipView<ID> getView() {
        MembershipView<ID> v = this.latestView;
        MembershipView<ID> result = new MembershipView<ID>(v, v.getViewId());
        return result;
    }

    @Override
    public boolean isJoining() {
        return this.isJoining;
    }

    @Override
    public ID getCoordinator() {
        this.latestViewReadLock.lock();
        try {
            ID ID = this.latestView == null ? null : (ID)this.latestView.getCoordinator();
            return ID;
        }
        finally {
            this.latestViewReadLock.unlock();
        }
    }

    @Override
    public boolean memberExists(ID m) {
        this.latestViewReadLock.lock();
        MembershipView<ID> v = this.latestView;
        this.latestViewReadLock.unlock();
        return v.contains((MemberIdentifier)m);
    }

    @Override
    public ID getLocalMember() {
        return this.address;
    }

    public Services<ID> getServices() {
        return this.services;
    }

    @Override
    public void processMessage(Message<ID> msg) throws MemberShunnedException {
        this.services.getHealthMonitor().contactedBy(msg.getSender());
        this.handleOrDeferMessage(msg);
    }

    @Override
    public void emergencyClose() {
        this.setShutdown();
        this.services.emergencyClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownMessageReceived(ID id, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: recording shutdown status of {}", id);
        }
        Map<ID, Object> map = this.shutdownMembers;
        synchronized (map) {
            this.shutdownMembers.put(id, id);
            this.services.getHealthMonitor().memberShutdown(id, reason);
            this.services.getJoinLeave().memberShutdown(id, reason);
        }
    }

    @Override
    public Set<ID> getMembersNotShuttingDown() {
        this.latestViewReadLock.lock();
        try {
            Set set = this.latestView.getMembers().stream().filter(id -> !this.shutdownMembers.containsKey(id)).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.latestViewReadLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.setShutdown();
        this.services.stop();
        this.viewExecutor.shutdownNow();
    }

    @Override
    public void uncleanShutdown(String reason, Exception e) {
        GMSMembership.inhibitForcedDisconnectLogging(false);
        if (this.services.getShutdownCause() == null) {
            this.services.setShutdownCause(e);
        }
        if (this.cleanupTimer != null && !this.cleanupTimer.isShutdown()) {
            this.cleanupTimer.shutdownNow();
        }
        this.lifecycleListener.disconnect(e);
        this.services.emergencyClose();
        if (e != null) {
            try {
                this.listener.membershipFailure(reason, e);
            }
            catch (RuntimeException re) {
                logger.warn("Exception caught while shutting down", (Throwable)re);
            }
        }
    }

    @Override
    public boolean requestMemberRemoval(ID mbr, String reason) throws MemberDisconnectedException {
        if (mbr.equals(this.address)) {
            return false;
        }
        logger.warn("Membership: requesting removal of {}. Reason={}", new Object[]{mbr, reason});
        try {
            this.services.getJoinLeave().remove(mbr, reason);
        }
        catch (RuntimeException e) {
            RuntimeException problem = e;
            if (this.services.getShutdownCause() != null) {
                Exception cause = this.services.getShutdownCause();
                if (cause instanceof MemberDisconnectedException) {
                    throw (MemberDisconnectedException)cause;
                }
                Throwable ne = problem;
                while (ne.getCause() != null) {
                    ne = ne.getCause();
                }
                try {
                    ne.initCause(this.services.getShutdownCause());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.listener.saveConfig();
            this.listener.membershipFailure("Channel closed", problem);
            throw new MembershipClosedException("Channel closed", problem);
        }
        return true;
    }

    @Override
    public void suspectMembers(Set<ID> members, String reason) {
        for (MemberIdentifier member : members) {
            this.verifyMember(member, reason);
        }
    }

    @Override
    public void suspectMember(ID mbr, String reason) {
        if (!this.shutdownInProgress && !this.shutdownMembers.containsKey(mbr)) {
            this.verifyMember(mbr, reason);
        }
    }

    @Override
    public boolean verifyMember(ID mbr, String reason) {
        return mbr != null && this.memberExists(mbr) && this.services.getHealthMonitor().checkIfAvailable(mbr, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ID[] getAllMembers(ID[] arrayType) {
        this.latestViewReadLock.lock();
        try {
            List<ID> keySet = this.latestView.getMembers();
            MemberIdentifier[] memberIdentifierArray = (MemberIdentifier[])keySet.toArray(arrayType);
            return memberIdentifierArray;
        }
        finally {
            this.latestViewReadLock.unlock();
        }
    }

    @Override
    public boolean hasMember(ID member) {
        return this.services.getJoinLeave().getView().contains(member);
    }

    @Override
    public boolean isConnected() {
        return this.hasJoined && !this.shutdownInProgress;
    }

    @Override
    public QuorumChecker getQuorumChecker() {
        if (!this.services.isShutdownDueToForcedDisconnect()) {
            return null;
        }
        if (this.quorumChecker != null) {
            return this.quorumChecker;
        }
        this.quorumChecker = this.services.getMessenger().getQuorumChecker();
        return this.quorumChecker;
    }

    @Override
    public void checkCancelled() throws MembershipClosedException {
        if (this.services.getCancelCriterion().isCancelInProgress()) {
            throw new MembershipClosedException("Distributed System is shutting down", this.services.getCancelCriterion().generateCancelledException(this.services.getShutdownCause()));
        }
    }

    @Override
    public void waitIfPlayingDead() {
        if (this.playingDead) {
            while (this.playingDead && !this.shutdownInProgress) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public Set<ID> send(ID[] destinations, Message<ID> content) throws NotSerializableException {
        this.checkAddressesForUUIDs((MemberIdentifier[])destinations);
        Set<ID> failures = this.services.getMessenger().send(content);
        if (failures == null || failures.size() == 0) {
            return Collections.emptySet();
        }
        return failures;
    }

    void checkAddressesForUUIDs(ID[] addresses) {
        GMSMembershipView<ID> view = this.services.getJoinLeave().getView();
        for (int i = 0; i < addresses.length; ++i) {
            ID id = addresses[i];
            if (id == null || id.hasUUID()) continue;
            id.setMemberData(view.getCanonicalID(id).getMemberData());
        }
    }

    @Override
    public void setShutdown() {
        this.latestViewWriteLock.lock();
        this.shutdownInProgress = true;
        this.latestViewWriteLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyMember(ID member, String reason) {
        this.latestViewWriteLock.lock();
        try {
            if (this.latestView.contains((MemberIdentifier)member)) {
                MembershipView<ID> newView = new MembershipView<ID>(this.latestView, this.latestView.getViewId());
                newView.remove(member);
                newView.makeUnmodifiable();
                this.latestView = newView;
            }
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
        this.surpriseMembers.remove(member);
        if (!this.isShunned(member)) {
            this.addShunnedMember(member);
        }
        this.lifecycleListener.destroyMember(member, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShunned(ID m) {
        if (!this.shunnedMembers.containsKey(m)) {
            return false;
        }
        this.latestViewWriteLock.lock();
        try {
            long shunTime = this.shunnedMembers.get(m);
            long now = System.currentTimeMillis();
            if (shunTime + (long)SHUNNED_SUNSET * 1000L > now) {
                boolean bl = true;
                return bl;
            }
            this.endShun(m);
            boolean bl = false;
            return bl;
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    private boolean isShunnedOrNew(ID m) {
        this.latestViewReadLock.lock();
        try {
            boolean bl = this.shunnedMembers.containsKey(m) || this.isNew(m);
            return bl;
        }
        finally {
            this.latestViewReadLock.unlock();
        }
    }

    private boolean isNew(ID m) {
        return !this.latestView.contains((MemberIdentifier)m) && !this.surpriseMembers.containsKey(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSurpriseMember(ID m) {
        this.latestViewReadLock.lock();
        try {
            if (this.surpriseMembers.containsKey(m)) {
                long now;
                long birthTime = this.surpriseMembers.get(m);
                boolean bl = birthTime >= (now = System.currentTimeMillis()) - this.surpriseMemberTimeout;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.latestViewReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSurpriseMemberForTesting(ID m, long birthTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("test hook is adding surprise member {} birthTime={}", m, (Object)birthTime);
        }
        this.latestViewWriteLock.lock();
        try {
            this.surpriseMembers.put(m, birthTime);
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
    }

    public long getSurpriseMemberTimeout() {
        return this.surpriseMemberTimeout;
    }

    private boolean endShun(ID m) {
        boolean wasShunned = this.shunnedMembers.remove(m) != null;
        this.shunnedAndWarnedMembers.remove(m);
        return wasShunned;
    }

    private void addShunnedMember(ID m) {
        long deathTime = System.currentTimeMillis() - (long)SHUNNED_SUNSET * 1000L;
        this.surpriseMembers.remove(m);
        if (!this.isShunned(m)) {
            this.shunnedMembers.put(m, System.currentTimeMillis());
        }
        HashSet<Map.Entry<ID, Long>> oldMembers = new HashSet<Map.Entry<ID, Long>>(this.shunnedMembers.entrySet());
        HashSet<MemberIdentifier> removedMembers = new HashSet<MemberIdentifier>();
        for (Map.Entry entry : oldMembers) {
            Map.Entry e = entry;
            long ll = (Long)e.getValue();
            if (ll >= deathTime) continue;
            MemberIdentifier mm = (MemberIdentifier)e.getKey();
            if (this.latestView.contains(mm)) {
                this.destroyMember(mm, "shunned but never disconnected");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: finally removed shunned member entry <{}>", (Object)mm);
            }
            removedMembers.add(mm);
        }
        if (removedMembers.size() > 0) {
            Iterator iterator = removedMembers.iterator();
            while (iterator.hasNext()) {
                MemberIdentifier memberIdentifier;
                MemberIdentifier idm = memberIdentifier = (MemberIdentifier)iterator.next();
                this.endShun(idm);
            }
        }
    }

    @Override
    public void setReconnectCompleted(boolean reconnectCompleted) {
        this.reconnectCompleted = reconnectCompleted;
    }

    @Override
    public Map<String, Long> getMessageState(ID member, boolean includeMulticast, Map<String, Long> result) {
        this.services.getMessenger().getMessageState(member, result, includeMulticast);
        return result;
    }

    @Override
    public void waitForMessageState(ID otherMember, Map<String, Long> state) throws InterruptedException, TimeoutException {
        this.services.getMessenger().waitForMessageState(otherMember, state);
    }

    @Override
    public boolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForNewMember(ID remoteId) {
        boolean foundRemoteId = false;
        CountDownLatch currentLatch = null;
        this.latestViewWriteLock.lock();
        try {
            if (this.latestView == null) {
            } else if (this.latestView.contains((MemberIdentifier)remoteId)) {
                foundRemoteId = true;
            } else {
                currentLatch = this.memberLatch.get(remoteId);
                if (currentLatch == null) {
                    currentLatch = new CountDownLatch(1);
                    this.memberLatch.put(remoteId, currentLatch);
                }
            }
        }
        finally {
            this.latestViewWriteLock.unlock();
        }
        if (!foundRemoteId) {
            try {
                if (currentLatch.await(this.membershipCheckTimeout, TimeUnit.MILLISECONDS)) {
                    foundRemoteId = true;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn("The membership check was terminated with an exception.");
            }
        }
        return foundRemoteId;
    }

    @Override
    public Throwable getShutdownCause() {
        return this.services.getShutdownCause();
    }

    @Override
    public synchronized void beSick() {
        if (!this.beingSick) {
            this.beingSick = true;
            logger.info("GroupMembershipService.beSick invoked for {} - simulating sickness", this.address);
            this.services.getJoinLeave().beSick();
            this.services.getHealthMonitor().beSick();
        }
    }

    @Override
    public synchronized void playDead() {
        if (!this.playingDead) {
            this.playingDead = true;
            logger.info("GroupMembershipService.playDead invoked for {}", this.address);
            this.services.getJoinLeave().playDead();
            this.services.getHealthMonitor().playDead();
            this.services.getMessenger().playDead();
        }
    }

    @VisibleForTesting
    public void forceDisconnect(String reason) {
        this.gmsManager.forceDisconnect(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void beHealthy() {
        if (this.beingSick || this.playingDead) {
            Object object = this.startupMutex;
            synchronized (object) {
                this.beingSick = false;
                this.playingDead = false;
                this.startEventProcessing();
            }
            logger.info("GroupMembershipService.beHealthy invoked for {} - recovering health now", this.address);
            this.services.getJoinLeave().beHealthy();
            this.services.getHealthMonitor().beHealthy();
            this.services.getMessenger().beHealthy();
        }
    }

    @Override
    public boolean isBeingSick() {
        return this.beingSick;
    }

    public static void inhibitForcedDisconnectLogging(boolean b) {
        inhibitForceDisconnectLogging = b;
    }

    public void disableDisconnectOnQuorumLossForTesting() {
        this.services.getJoinLeave().disableDisconnectOnQuorumLossForTesting();
    }

    @Override
    public void disconnect(boolean beforeJoined) {
        if (beforeJoined) {
            this.uncleanShutdown("Failed to start distribution", null);
        } else {
            this.shutdown();
        }
    }

    @Override
    public void start() throws MemberStartupException {
        this.services.start();
    }

    @Override
    public void setCloseInProgress() {
        this.isCloseInProgress = true;
    }

    class ManagerImpl
    implements Manager<ID> {
        ManagerImpl() {
        }

        @Override
        public Services<ID> getServices() {
            return GMSMembership.this.services;
        }

        @Override
        public void init(Services<ID> services) throws MembershipConfigurationException {
            GMSMembership.this.services = services;
            MembershipConfig config = services.getConfig();
            GMSMembership.this.membershipCheckTimeout = config.getSecurityPeerMembershipTimeout();
            GMSMembership.this.wasReconnectingSystem = config.getIsReconnectingDS();
            GMSMembership.this.surpriseMemberTimeout = Math.max(100000L, 20L * config.getMemberTimeout());
            GMSMembership.this.surpriseMemberTimeout = Long.getLong("gemfire.surprise-member-timeout", GMSMembership.this.surpriseMemberTimeout);
        }

        @Override
        public void start() throws MemberStartupException {
            GMSMembership.this.lifecycleListener.start(GMSMembership.this.services.getMessenger().getMemberID());
        }

        @Override
        public void started() throws MemberStartupException {
            GMSMembership.this.startCleanupTimer();
        }

        @Override
        public void stop() {
            logger.debug("Membership closing");
            if (GMSMembership.this.lifecycleListener.disconnect(null) && GMSMembership.this.address != null) {
                GMSMembership.this.latestViewWriteLock.lock();
                try {
                    GMSMembership.this.destroyMember(GMSMembership.this.address, "orderly shutdown");
                }
                finally {
                    GMSMembership.this.latestViewWriteLock.unlock();
                }
            }
            if (GMSMembership.this.cleanupTimer != null && !GMSMembership.this.cleanupTimer.isShutdown()) {
                GMSMembership.this.cleanupTimer.shutdown();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: channel closed");
            }
        }

        @Override
        public void stopped() {
        }

        @Override
        public void installView(GMSMembershipView<ID> v) {
            MembershipView currentView = GMSMembership.this.latestView;
            if (currentView.getViewId() < 0 && !GMSMembership.this.isConnected()) {
                GMSMembership.this.latestView = GMSMembership.this.createGeodeView(v);
                logger.debug("Membership: initial view is {}", (Object)GMSMembership.this.latestView);
            } else {
                GMSMembership.this.handleOrDeferViewEvent(GMSMembership.this.createGeodeView(v));
            }
        }

        @Override
        public void beSick() {
        }

        @Override
        public void playDead() {
        }

        @Override
        public void beHealthy() {
        }

        @Override
        public void emergencyClose() {
        }

        @Override
        public void joinDistributedSystem() throws MemberStartupException {
            long startTime = System.currentTimeMillis();
            try {
                GMSMembership.this.join();
            }
            catch (RuntimeException | MemberStartupException e) {
                GMSMembership.this.lifecycleListener.disconnect(e);
                throw e;
            }
            GMSMembership.this.address = GMSMembership.this.services.getMessenger().getMemberID();
            GMSMembership.this.lifecycleListener.joinCompleted(GMSMembership.this.address);
            GMSMembership.this.hasJoined = true;
            logger.info("Finished joining (took {}ms).", (Object)("" + (System.currentTimeMillis() - startTime)));
        }

        @Override
        public void memberSuspected(ID initiator, ID suspect, String reason) {
            SuspectMember s = new SuspectMember(initiator, suspect, reason);
            GMSMembership.this.handleOrDeferSuspect(s);
        }

        @Override
        public void forceDisconnect(String reason) {
            if (GMSMembership.this.shutdownInProgress || GMSMembership.this.isJoining()) {
                return;
            }
            GMSMembership.this.setShutdown();
            MemberDisconnectedException shutdownCause = new MemberDisconnectedException(reason);
            GMSMembership.this.services.setShutdownCause(shutdownCause);
            GMSMembership.this.services.getCancelCriterion().cancel(reason);
            if (!inhibitForceDisconnectLogging) {
                logger.fatal(String.format("Membership service failure: %s", reason), (Throwable)shutdownCause);
            }
            if (this.isReconnectingDS()) {
                logger.info("Reconnecting system failed to connect");
                GMSMembership.this.uncleanShutdown(reason, new MemberDisconnectedException("reconnecting system failed to connect"));
                return;
            }
            GMSMembership.this.listener.saveConfig();
            LoggingThread reconnectThread = new LoggingThread("DisconnectThread", false, () -> {
                GMSMembership.this.lifecycleListener.forcedDisconnect();
                GMSMembership.this.uncleanShutdown(reason, shutdownCause);
            });
            reconnectThread.start();
        }

        @Override
        public void quorumLost(Collection<ID> failures, GMSMembershipView<ID> view) {
            boolean notify;
            boolean bl = notify = failures.size() > 1;
            if (!notify) {
                notify = GMSMembership.this.services.getConfig().isNetworkPartitionDetectionEnabled();
            }
            if (notify) {
                List remaining = GMSMembership.this.gmsMemberListToIDList(view.getMembers());
                remaining.removeAll(failures);
                if (inhibitForceDisconnectLogging && logger.isDebugEnabled()) {
                    logger.debug("<ExpectedException action=add>Possible loss of quorum</ExpectedException>");
                }
                logger.fatal("Possible loss of quorum due to the loss of {} cache processes: {}", (Object)failures.size(), failures);
                if (inhibitForceDisconnectLogging && logger.isDebugEnabled()) {
                    logger.debug("<ExpectedException action=remove>Possible loss of quorum</ExpectedException>");
                }
                try {
                    GMSMembership.this.listener.quorumLost(GMSMembership.this.gmsMemberCollectionToIDSet(failures), remaining);
                }
                catch (Exception e) {
                    logger.info("Quorum-loss listener threw an exception", (Throwable)e);
                }
            }
        }

        @Override
        public void processMessage(Message<ID> msg) throws MemberShunnedException {
            if (msg.getSender().isPartial()) {
                GMSMembership.this.replacePartialIdentifierInMessage(msg);
            }
            GMSMembership.this.handleOrDeferMessage(msg);
        }

        @Override
        public boolean isMulticastAllowed() {
            return !GMSMembership.this.disableMulticastForRollingUpgrade;
        }

        @Override
        public boolean shutdownInProgress() {
            return GMSMembership.this.shutdownInProgress;
        }

        @Override
        public boolean isCloseInProgress() {
            return GMSMembership.this.shutdownInProgress || GMSMembership.this.isCloseInProgress;
        }

        @Override
        public boolean isReconnectingDS() {
            return GMSMembership.this.wasReconnectingSystem && !GMSMembership.this.reconnectCompleted;
        }
    }

    static class BoundedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -3419897166186852692L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 1000;
        }
    }

    static class StartupEvent<ID extends MemberIdentifier> {
        static final int SURPRISE_CONNECT = 1;
        static final int VIEW = 2;
        static final int MESSAGE = 3;
        private final int kind;
        ID member;
        Message<ID> dmsg;
        MembershipView<ID> gmsView;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("kind=");
            switch (this.kind) {
                case 1: {
                    sb.append("connect; member = <").append(this.member).append(">");
                    break;
                }
                case 2: {
                    String text = this.gmsView.toString();
                    sb.append("view <").append(text).append(">");
                    break;
                }
                case 3: {
                    sb.append("message <").append(this.dmsg).append(">");
                    break;
                }
                default: {
                    sb.append("unknown=<").append(this.kind).append(">");
                }
            }
            return sb.toString();
        }

        StartupEvent(ID member) {
            this.kind = 1;
            this.member = member;
        }

        boolean isSurpriseConnect() {
            return this.kind == 1;
        }

        StartupEvent(MembershipView<ID> v) {
            this.kind = 2;
            this.gmsView = v;
        }

        boolean isGmsView() {
            return this.kind == 2;
        }

        StartupEvent(Message<ID> d) {
            this.kind = 3;
            this.dmsg = d;
        }

        boolean isDistributionMessage() {
            return this.kind == 3;
        }
    }

    static class EventProcessingLock {
    }
}

