/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.management.runtime.RegionRedundancyStatus;
import org.apache.geode.management.runtime.RestoreRedundancyResults;

public class RestoreRedundancyResultsImpl
implements RestoreRedundancyResults {
    public static final String NO_REDUNDANT_COPIES_FOR_REGIONS = "The following regions have redundancy configured but zero redundant copies: ";
    public static final String REDUNDANCY_NOT_SATISFIED_FOR_REGIONS = "Redundancy is partially satisfied for regions: ";
    public static final String REDUNDANCY_SATISFIED_FOR_REGIONS = "Redundancy is fully satisfied for regions: ";
    public static final String PRIMARY_TRANSFERS_COMPLETED = "Total primary transfers completed = ";
    public static final String PRIMARY_TRANSFER_TIME = "Total primary transfer time (ms) = ";
    private static final long serialVersionUID = -1174735246756963521L;
    protected Map<String, RegionRedundancyStatus> zeroRedundancyRegionsResults = new HashMap<String, RegionRedundancyStatus>();
    protected Map<String, RegionRedundancyStatus> underRedundancyRegionsResults = new HashMap<String, RegionRedundancyStatus>();
    protected Map<String, RegionRedundancyStatus> satisfiedRedundancyRegionsResults = new HashMap<String, RegionRedundancyStatus>();
    protected int totalPrimaryTransfersCompleted;
    protected long totalPrimaryTransferTime = 0L;
    protected boolean success = true;
    protected String statusMessage;
    protected final List<String> includedRegionsWithNoMembers = new ArrayList<String>();
    private RegionRedundancyStatus regionResult;

    public void setZeroRedundancyRegionsResults(Map<String, RegionRedundancyStatus> zeroRedundancyRegionsResults) {
        this.zeroRedundancyRegionsResults = zeroRedundancyRegionsResults;
    }

    public void setUnderRedundancyRegionsResults(Map<String, RegionRedundancyStatus> underRedundancyRegionsResults) {
        this.underRedundancyRegionsResults = underRedundancyRegionsResults;
    }

    public void setSatisfiedRedundancyRegionsResults(Map<String, RegionRedundancyStatus> satisfiedRedundancyRegionsResults) {
        this.satisfiedRedundancyRegionsResults = satisfiedRedundancyRegionsResults;
    }

    public void setTotalPrimaryTransfersCompleted(int totalPrimaryTransfersCompleted) {
        this.totalPrimaryTransfersCompleted = totalPrimaryTransfersCompleted;
    }

    public void setTotalPrimaryTransferTime(long totalPrimaryTransferTime) {
        this.totalPrimaryTransferTime = totalPrimaryTransferTime;
    }

    public void setRegionResult(RegionRedundancyStatus regionResult) {
        this.regionResult = regionResult;
    }

    public void addRegionResults(RestoreRedundancyResults results) {
        this.satisfiedRedundancyRegionsResults.putAll(results.getSatisfiedRedundancyRegionResults());
        this.underRedundancyRegionsResults.putAll(results.getUnderRedundancyRegionResults());
        this.zeroRedundancyRegionsResults.putAll(results.getZeroRedundancyRegionResults());
        this.totalPrimaryTransfersCompleted += results.getTotalPrimaryTransfersCompleted();
        this.totalPrimaryTransferTime += results.getTotalPrimaryTransferTime();
    }

    public void addRegionResult(RegionRedundancyStatus regionResult) {
        this.addToFilteredMaps(regionResult);
    }

    private void addToFilteredMaps(RegionRedundancyStatus regionResult) {
        switch (regionResult.getStatus()) {
            case NO_REDUNDANT_COPIES: {
                this.zeroRedundancyRegionsResults.put(regionResult.getRegionName(), regionResult);
                break;
            }
            case NOT_SATISFIED: {
                this.underRedundancyRegionsResults.put(regionResult.getRegionName(), regionResult);
                break;
            }
            case SATISFIED: {
                this.satisfiedRedundancyRegionsResults.put(regionResult.getRegionName(), regionResult);
            }
        }
    }

    @Override
    public RestoreRedundancyResults.Status getRegionOperationStatus() {
        boolean fullySatisfied = this.zeroRedundancyRegionsResults.isEmpty() && this.underRedundancyRegionsResults.isEmpty();
        return fullySatisfied ? RestoreRedundancyResults.Status.SUCCESS : RestoreRedundancyResults.Status.FAILURE;
    }

    @Override
    public String getRegionOperationMessage() {
        ArrayList<Object> messages = new ArrayList<Object>();
        if (!this.zeroRedundancyRegionsResults.isEmpty()) {
            messages.add(this.getResultsMessage(this.zeroRedundancyRegionsResults, NO_REDUNDANT_COPIES_FOR_REGIONS));
        }
        if (!this.underRedundancyRegionsResults.isEmpty()) {
            messages.add(this.getResultsMessage(this.underRedundancyRegionsResults, REDUNDANCY_NOT_SATISFIED_FOR_REGIONS));
        }
        if (!this.satisfiedRedundancyRegionsResults.isEmpty()) {
            messages.add(this.getResultsMessage(this.satisfiedRedundancyRegionsResults, REDUNDANCY_SATISFIED_FOR_REGIONS));
        }
        messages.add(PRIMARY_TRANSFERS_COMPLETED + this.totalPrimaryTransfersCompleted);
        messages.add(PRIMARY_TRANSFER_TIME + this.totalPrimaryTransferTime);
        return String.join((CharSequence)System.lineSeparator(), messages);
    }

    private String getResultsMessage(Map<String, RegionRedundancyStatus> regionResults, String baseMessage) {
        String message = baseMessage + System.lineSeparator();
        message = message + regionResults.values().stream().map(Object::toString).collect(Collectors.joining("," + System.lineSeparator()));
        return message;
    }

    @Override
    public RegionRedundancyStatus getRegionResult(String regionName) {
        this.regionResult = this.satisfiedRedundancyRegionsResults.get(regionName);
        if (this.regionResult == null) {
            this.regionResult = this.underRedundancyRegionsResults.get(regionName);
        }
        if (this.regionResult == null) {
            this.regionResult = this.zeroRedundancyRegionsResults.get(regionName);
        }
        return this.regionResult;
    }

    @Override
    public Map<String, RegionRedundancyStatus> getZeroRedundancyRegionResults() {
        return this.zeroRedundancyRegionsResults;
    }

    @Override
    public Map<String, RegionRedundancyStatus> getUnderRedundancyRegionResults() {
        return this.underRedundancyRegionsResults;
    }

    @Override
    public Map<String, RegionRedundancyStatus> getSatisfiedRedundancyRegionResults() {
        return this.satisfiedRedundancyRegionsResults;
    }

    @Override
    public Map<String, RegionRedundancyStatus> getRegionResults() {
        HashMap<String, RegionRedundancyStatus> combinedResults = new HashMap<String, RegionRedundancyStatus>(this.satisfiedRedundancyRegionsResults);
        combinedResults.putAll(this.underRedundancyRegionsResults);
        combinedResults.putAll(this.zeroRedundancyRegionsResults);
        return combinedResults;
    }

    @Override
    public int getTotalPrimaryTransfersCompleted() {
        return this.totalPrimaryTransfersCompleted;
    }

    @Override
    public long getTotalPrimaryTransferTime() {
        return this.totalPrimaryTransferTime;
    }

    @Override
    public List<String> getIncludedRegionsWithNoMembers() {
        return this.includedRegionsWithNoMembers;
    }

    @Override
    public boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public void addIncludedRegionsWithNoMembers(List<String> regions) {
        this.includedRegionsWithNoMembers.addAll(regions);
    }

    public String toString() {
        return "RestoreRedundancyResultsImpl{zeroRedundancyRegions=" + String.valueOf(this.zeroRedundancyRegionsResults) + ", underRedundancyRegions=" + String.valueOf(this.underRedundancyRegionsResults) + ", satisfiedRedundancyRegions=" + String.valueOf(this.satisfiedRedundancyRegionsResults) + ", totalPrimaryTransfersCompleted=" + this.totalPrimaryTransfersCompleted + ", totalPrimaryTransferTime=" + this.totalPrimaryTransferTime + ", success=" + this.success + ", message='" + this.statusMessage + "', includedRegionsWithNoMembers=" + String.valueOf(this.includedRegionsWithNoMembers) + "}";
    }
}

