/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.geode.management.api.EntityGroupInfo;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.RuntimeInfo;

public class EntityInfo<T extends AbstractConfiguration<R>, R extends RuntimeInfo> {
    private String id;
    @JsonInclude
    @JsonProperty
    private List<EntityGroupInfo<T, R>> groups = new ArrayList<EntityGroupInfo<T, R>>();

    public EntityInfo() {
    }

    public EntityInfo(String id, List<EntityGroupInfo<T, R>> groups) {
        this.id = id;
        this.groups = groups;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<EntityGroupInfo<T, R>> getGroups() {
        return this.groups;
    }

    public void setGroups(List<EntityGroupInfo<T, R>> groups) {
        this.groups = groups;
    }

    @JsonIgnore
    public List<T> getConfigurations() {
        return this.groups.stream().map(EntityGroupInfo::getConfiguration).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<R> getRuntimeInfos() {
        return this.groups.stream().flatMap(r -> r.getRuntimeInfo().stream()).collect(Collectors.toList());
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Links getLinks() {
        if (this.groups.isEmpty()) {
            return null;
        }
        return this.groups.get(0).getLinks();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityInfo that = (EntityInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.groups);
    }

    public String toString() {
        return "ConfigurationInfo{id='" + this.id + "', groups=" + String.valueOf(this.groups) + "}";
    }
}

