/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.util.internal.GeodeJsonMapper;

public class ClassName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper mapper = GeodeJsonMapper.getMapper();
    private final String className;
    private final Properties initProperties;
    public static final ClassName EMPTY = new ClassName("");

    public ClassName(String className) {
        this(className, "{}");
    }

    public ClassName(String className, String jsonInitProperties) {
        this(className, ClassName.createProperties(jsonInitProperties));
    }

    private static Properties createProperties(String jsonInitProperties) {
        if (StringUtils.isBlank((CharSequence)jsonInitProperties)) {
            return new Properties();
        }
        try {
            return (Properties)mapper.readValue(jsonInitProperties, Properties.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON: " + jsonInitProperties, e);
        }
    }

    @JsonCreator
    public ClassName(@JsonProperty(value="className") String className, @JsonProperty(value="initProperties") Properties properties) {
        if (StringUtils.isBlank((CharSequence)className)) {
            this.className = "";
            this.initProperties = new Properties();
            return;
        }
        if (!ClassName.isClassNameValid(className)) {
            throw new IllegalArgumentException("Invalid className");
        }
        this.className = className;
        this.initProperties = properties == null ? new Properties() : properties;
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getInitProperties() {
        return this.initProperties;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.initProperties);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClassName)) {
            return false;
        }
        ClassName that = (ClassName)o;
        return this.className.equals(that.getClassName()) && this.getInitProperties().equals(that.getInitProperties());
    }

    public static boolean isClassNameValid(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return false;
        }
        String regex = "([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*";
        return Pattern.matches(regex, className);
    }
}

