/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.RestfulEndpoint;
import org.apache.geode.management.internal.CompletableFutureProxy;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class ClientClusterManagementService
implements ClusterManagementService {
    private final RestTemplate restTemplate;
    private final ScheduledExecutorService longRunningStatusPollingThreadPool;

    ClientClusterManagementService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.longRunningStatusPollingThreadPool = Executors.newScheduledThreadPool(1);
    }

    @Override
    public <T extends CacheElement> ClusterManagementRealizationResult create(T config) {
        String endPoint = this.getEndpoint(config);
        return (ClusterManagementRealizationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.postForEntity(endPoint, config, ClusterManagementRealizationResult.class, new Object[0]).getBody());
    }

    @Override
    public <T extends CacheElement> ClusterManagementRealizationResult delete(T config) {
        String uri = this.getIdentityEndPoint(config);
        return (ClusterManagementRealizationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange(uri + "?group={group}", HttpMethod.DELETE, null, ClusterManagementRealizationResult.class, new Object[]{config.getGroup()}).getBody());
    }

    @Override
    public <T extends CacheElement> ClusterManagementRealizationResult update(T config) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public <T extends CacheElement, R extends RuntimeInfo> ClusterManagementListResult<T, R> list(T config) {
        String endPoint = this.getEndpoint(config);
        return (ClusterManagementListResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.getForEntity(endPoint + "/?id={id}&group={group}", ClusterManagementListResult.class, new Object[]{config.getId(), config.getGroup()}).getBody());
    }

    @Override
    public <T extends CacheElement, R extends RuntimeInfo> ClusterManagementListResult<T, R> get(T config) {
        return (ClusterManagementListResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.getForEntity(this.getIdentityEndPoint(config), ClusterManagementListResult.class, new Object[0]).getBody());
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> start(A op) {
        ClusterManagementOperationResult result = (ClusterManagementOperationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.postForEntity("/experimental" + op.getEndpoint(), op, ClusterManagementOperationResult.class, new Object[0]).getBody());
        return this.reAnimate(result);
    }

    private <V extends OperationResult> ClusterManagementOperationResult<V> reAnimate(ClusterManagementOperationResult<V> result) {
        String uri = ClientClusterManagementService.stripPrefix("/management", result.getUri());
        CompletableFuture<Date> futureOperationEnded = new CompletableFuture<Date>();
        CompletableFutureProxy operationResult = new CompletableFutureProxy(this.restTemplate, uri, this.longRunningStatusPollingThreadPool, futureOperationEnded);
        return new ClusterManagementOperationResult(result, operationResult, result.getOperationStart(), futureOperationEnded, result.getOperator());
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<V> list(A opType) {
        ClusterManagementListOperationsResult result = (ClusterManagementListOperationsResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.getForEntity("/experimental" + opType.getEndpoint(), ClusterManagementListOperationsResult.class, new Object[0]).getBody());
        return new ClusterManagementListOperationsResult(result.getResult().stream().map(this::reAnimate).collect(Collectors.toList()));
    }

    private static String stripPrefix(String prefix, String s) {
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    private String getEndpoint(CacheElement config) {
        this.checkIsRestful(config);
        String endpoint = ((RestfulEndpoint)((Object)config)).getEndpoint();
        if (endpoint == null) {
            throw new IllegalArgumentException("unable to construct the uri with the current configuration.");
        }
        return "/experimental" + endpoint;
    }

    private String getIdentityEndPoint(CacheElement config) {
        this.checkIsRestful(config);
        String uri = ((RestfulEndpoint)((Object)config)).getIdentityEndPoint();
        if (uri == null) {
            throw new IllegalArgumentException("unable to construct the uri with the current configuration.");
        }
        return "/experimental" + uri;
    }

    private void checkIsRestful(CacheElement config) {
        if (!(config instanceof RestfulEndpoint)) {
            throw new IllegalArgumentException(String.format("The config type %s does not have a RESTful endpoint defined", config.getClass().getName()));
        }
    }

    private <T extends ClusterManagementResult> T assertSuccessful(T result) {
        if (!result.isSuccessful()) {
            throw new ClusterManagementException(result);
        }
        return result;
    }

    @Override
    public boolean isConnected() {
        try {
            return ((String)this.restTemplate.getForEntity("/experimental/ping", String.class, new Object[0]).getBody()).equals("pong");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.longRunningStatusPollingThreadPool.shutdownNow();
    }
}

