/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneDestroyIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.commands.LuceneCommandBase;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDestroyIndexFunction;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

public class LuceneDestroyIndexCommand
extends LuceneCommandBase {
    private static final LuceneDestroyIndexFunction destroyIndexFunction = new LuceneDestroyIndexFunction();

    @ShellMethod(value="Destroy the lucene index.", key={"destroy lucene index"})
    @CliMetaData(relatedTopic={"Region", "Data"})
    public ResultModel destroyIndex(@ShellOption(value={"name"}, defaultValue="__NULL__", help="Name of the lucene index to destroy.") String indexName, @ShellOption(value={"region"}, help="Name of the region defining the lucene index to be destroyed.") String regionPath) {
        if (indexName != null && StringUtils.isEmpty((CharSequence)indexName)) {
            return ResultModel.createInfo((String)CliStrings.format((String)"Index cannot be empty.", (Object[])new Object[0]));
        }
        if (!((String)regionPath).startsWith("/")) {
            regionPath = "/" + (String)regionPath;
        }
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE, "LUCENE");
        Set validVersionMembers = this.getNormalMembersWithSameOrNewerVersion(KnownVersion.GEODE_1_7_0);
        if (validVersionMembers.isEmpty()) {
            return ResultModel.createInfo((String)CliStrings.format((String)"Could not find any members greater than or equal to version {0}.", (Object)KnownVersion.GEODE_1_7_0));
        }
        LuceneDestroyIndexInfo indexInfo = new LuceneDestroyIndexInfo(indexName, (String)regionPath);
        ResultCollector rc = this.executeFunction((Function)destroyIndexFunction, indexInfo, validVersionMembers);
        List cliFunctionResults = (List)rc.getResult();
        ResultModel result = this.getDestroyIndexResult(cliFunctionResults, indexName, (String)regionPath);
        XmlEntity xmlEntity = this.findXmlEntity(cliFunctionResults);
        InternalConfigurationPersistenceService configurationPersistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (xmlEntity != null) {
            if (configurationPersistenceService == null) {
                result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                configurationPersistenceService.deleteXmlEntity(xmlEntity, null);
            }
        }
        return result;
    }

    private ResultModel getDestroyIndexResult(List<CliFunctionResult> cliFunctionResults, String indexName, String regionPath) {
        ResultModel result = new ResultModel();
        TabularResultModel tabularResult = result.addTable("lucene-indexes");
        String displayRegionPath = regionPath;
        if (displayRegionPath.startsWith("/")) {
            displayRegionPath = displayRegionPath.substring("/".length());
        }
        for (CliFunctionResult cliFunctionResult : cliFunctionResults) {
            tabularResult.accumulate("Member", cliFunctionResult.getMemberIdOrName());
            if (cliFunctionResult.isSuccessful()) {
                tabularResult.accumulate("Status", indexName == null ? CliStrings.format((String)"Successfully destroyed all lucene indexes from region {0}", (Object[])new Object[]{displayRegionPath}) : CliStrings.format((String)"Successfully destroyed lucene index {0} from region {1}", (Object[])new Object[]{indexName, displayRegionPath}));
                continue;
            }
            tabularResult.accumulate("Status", cliFunctionResult.getMessage());
        }
        return result;
    }

    private XmlEntity findXmlEntity(List<CliFunctionResult> functionResults) {
        return functionResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    @ShellMethodAvailability(value={"destroy lucene index"})
    public boolean indexCommandsAvailable() {
        return super.indexCommandsAvailable();
    }
}

