/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.File;
import java.io.IOException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.IndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneRawIndex;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexRepositoryImpl;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;

public class RawIndexRepositoryFactory
extends IndexRepositoryFactory {
    @Override
    public IndexRepository computeIndexRepository(Integer bucketId, LuceneSerializer serializer, InternalLuceneIndex index, PartitionedRegion userRegion, IndexRepository oldRepository, PartitionedRepositoryManager partitionedRepositoryManager) throws IOException {
        if (oldRepository != null) {
            oldRepository.cleanup();
        }
        LuceneRawIndex indexForRaw = (LuceneRawIndex)index;
        BucketRegion dataBucket = this.getMatchingBucket(userRegion, bucketId);
        ByteBuffersDirectory dir = null;
        if (indexForRaw.withPersistence()) {
            String bucketLocation = LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath() + "_" + bucketId);
            File location = new File(index.getName(), bucketLocation);
            if (!location.exists()) {
                location.mkdirs();
            }
            dir = new NIOFSDirectory(location.toPath());
        } else {
            dir = new ByteBuffersDirectory();
        }
        IndexWriterConfig config = new IndexWriterConfig(indexForRaw.getAnalyzer());
        IndexWriter writer = new IndexWriter((Directory)dir, config);
        return new IndexRepositoryImpl(null, writer, serializer, indexForRaw.getIndexStats(), (Region<?, ?>)dataBucket, null, "", indexForRaw);
    }
}

