/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.LuceneQuery;
import org.apache.geode.cache.lucene.LuceneQueryException;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.LuceneResultStruct;
import org.apache.geode.cache.lucene.PageableLuceneQueryResults;
import org.apache.geode.cache.lucene.internal.PageableLuceneQueryResultsImpl;
import org.apache.geode.cache.lucene.internal.distributed.EntryScore;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunctionContext;
import org.apache.geode.cache.lucene.internal.distributed.LuceneQueryFunction;
import org.apache.geode.cache.lucene.internal.distributed.TopEntries;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesFunctionCollector;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LuceneQueryImpl<K, V>
implements LuceneQuery<K, V> {
    public static final String LUCENE_QUERY_CANNOT_BE_EXECUTED_WITHIN_A_TRANSACTION = "Lucene Query cannot be executed within a transaction";
    Logger logger = LogService.getLogger();
    private int limit = 100;
    private int pageSize = 0;
    private String indexName;
    private LuceneQueryProvider query;
    private Region<K, V> region;
    private String defaultField;

    public LuceneQueryImpl(String indexName, Region<K, V> region, LuceneQueryProvider provider, int limit, int pageSize) {
        this.indexName = indexName;
        this.region = region;
        this.limit = limit;
        this.pageSize = pageSize;
        this.query = provider;
    }

    @Override
    public Collection<K> findKeys() throws LuceneQueryException {
        TopEntries<K> entries = this.findTopEntries();
        List<EntryScore<K>> hits = entries.getHits();
        return hits.stream().map(hit -> hit.getKey()).collect(Collectors.toList());
    }

    @Override
    public Collection<V> findValues() throws LuceneQueryException {
        List<LuceneResultStruct<K, V>> page = this.findResults();
        return page.stream().map(entry -> entry.getValue()).collect(Collectors.toList());
    }

    @Override
    public List<LuceneResultStruct<K, V>> findResults() throws LuceneQueryException {
        PageableLuceneQueryResults<K, V> pages = this.findPages(0);
        if (!pages.hasNext()) {
            return Collections.emptyList();
        }
        return pages.next();
    }

    @Override
    public PageableLuceneQueryResults<K, V> findPages() throws LuceneQueryException {
        return this.findPages(this.pageSize);
    }

    private PageableLuceneQueryResults<K, V> findPages(int pageSize) throws LuceneQueryException {
        TopEntries<K> entries = this.findTopEntries();
        return this.newPageableResults(pageSize, entries);
    }

    protected PageableLuceneQueryResults<K, V> newPageableResults(int pageSize, TopEntries<K> entries) {
        return new PageableLuceneQueryResultsImpl<K, V>(entries.getHits(), this.region, pageSize);
    }

    private TopEntries<K> findTopEntries() throws LuceneQueryException {
        TopEntriesCollectorManager manager = new TopEntriesCollectorManager(null, this.limit);
        LuceneFunctionContext<TopEntriesCollector> context = new LuceneFunctionContext<TopEntriesCollector>(this.query, this.indexName, manager, this.limit);
        if (this.region.getCache().getCacheTransactionManager().exists()) {
            throw new LuceneQueryException(LUCENE_QUERY_CANNOT_BE_EXECUTED_WITHIN_A_TRANSACTION);
        }
        TopEntries entries = null;
        try {
            TopEntriesFunctionCollector collector = new TopEntriesFunctionCollector(context);
            ResultCollector rc = this.onRegion().setArguments(context).withCollector((ResultCollector)collector).execute(LuceneQueryFunction.ID);
            entries = (TopEntries)rc.getResult();
        }
        catch (FunctionException e) {
            if (e.getCause() instanceof LuceneQueryException) {
                throw new LuceneQueryException(e);
            }
            if (e.getCause() instanceof TransactionException) {
                throw new LuceneQueryException(LUCENE_QUERY_CANNOT_BE_EXECUTED_WITHIN_A_TRANSACTION);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        catch (TransactionException e) {
            throw new LuceneQueryException(LUCENE_QUERY_CANNOT_BE_EXECUTED_WITHIN_A_TRANSACTION);
        }
        return entries;
    }

    protected Execution onRegion() {
        return FunctionService.onRegion(this.region);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

