/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.FixedPartitionResolver;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.DestroyLuceneIndexMessage;
import org.apache.geode.cache.lucene.internal.LuceneBucketListener;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.directory.DumpDirectoryFiles;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystemStats;
import org.apache.geode.cache.lucene.internal.partition.BucketTargetingFixedResolver;
import org.apache.geode.cache.lucene.internal.partition.BucketTargetingResolver;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;

public class LuceneIndexForPartitionedRegion
extends LuceneIndexImpl {
    protected Region fileAndChunkRegion;
    protected final FileSystemStats fileSystemStats;
    public static final String FILES_REGION_SUFFIX = ".files";

    public LuceneIndexForPartitionedRegion(String indexName, String regionPath, InternalCache cache) {
        super(indexName, regionPath, cache);
        String statsName = indexName + "-" + regionPath;
        this.fileSystemStats = new FileSystemStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    protected RepositoryManager createRepositoryManager(LuceneSerializer luceneSerializer) {
        LuceneSerializer mapper = luceneSerializer;
        if (mapper == null) {
            mapper = new HeterogeneousLuceneSerializer();
        }
        PartitionedRepositoryManager partitionedRepositoryManager = new PartitionedRepositoryManager(this, mapper);
        return partitionedRepositoryManager;
    }

    @Override
    protected void createLuceneListenersAndFileChunkRegions(PartitionedRepositoryManager partitionedRepositoryManager) {
        boolean withStorage;
        partitionedRepositoryManager.setUserRegionForRepositoryManager((PartitionedRegion)this.dataRegion);
        boolean withPersistence = this.withPersistence();
        RegionAttributes regionAttributes = this.dataRegion.getAttributes();
        boolean bl = withStorage = regionAttributes.getPartitionAttributes().getLocalMaxMemory() > 0;
        RegionShortcut regionShortCut = !withStorage ? RegionShortcut.PARTITION_PROXY : (withPersistence ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION);
        String fileRegionName = this.createFileRegionName();
        PartitionAttributes partitionAttributes = this.dataRegion.getPartitionAttributes();
        DistributionManager dm = this.cache.getInternalDistributedSystem().getDistributionManager();
        LuceneBucketListener lucenePrimaryBucketListener = new LuceneBucketListener(partitionedRepositoryManager, dm);
        if (!this.fileRegionExists(fileRegionName)) {
            this.fileAndChunkRegion = this.createRegion(fileRegionName, regionShortCut, this.regionPath, partitionAttributes, regionAttributes, (PartitionListener)lucenePrimaryBucketListener);
        }
        this.fileSystemStats.setBytesSupplier(() -> this.getFileAndChunkRegion().getPrStats().getDataStoreBytesInUse());
    }

    public PartitionedRegion getFileAndChunkRegion() {
        return (PartitionedRegion)this.fileAndChunkRegion;
    }

    public FileSystemStats getFileSystemStats() {
        return this.fileSystemStats;
    }

    boolean fileRegionExists(String fileRegionName) {
        return this.cache.getRegion(fileRegionName) != null;
    }

    public String createFileRegionName() {
        return LuceneServiceImpl.getUniqueIndexRegionName(this.indexName, this.regionPath, FILES_REGION_SUFFIX);
    }

    private PartitionAttributesFactory configureLuceneRegionAttributesFactory(PartitionAttributesFactory attributesFactory, PartitionAttributes<?, ?> dataRegionAttributes) {
        attributesFactory.setTotalNumBuckets(dataRegionAttributes.getTotalNumBuckets());
        attributesFactory.setRedundantCopies(dataRegionAttributes.getRedundantCopies());
        attributesFactory.setPartitionResolver(this.getPartitionResolver(dataRegionAttributes));
        attributesFactory.setRecoveryDelay(dataRegionAttributes.getRecoveryDelay());
        attributesFactory.setStartupRecoveryDelay(dataRegionAttributes.getStartupRecoveryDelay());
        return attributesFactory;
    }

    private PartitionResolver getPartitionResolver(PartitionAttributes dataRegionAttributes) {
        if (dataRegionAttributes.getPartitionResolver() instanceof FixedPartitionResolver) {
            return new BucketTargetingFixedResolver();
        }
        return new BucketTargetingResolver();
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionShortcut regionShortCut, String colocatedWithRegionName, PartitionAttributes partitionAttributes, RegionAttributes regionAttributes, PartitionListener lucenePrimaryBucketListener) {
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory();
        if (lucenePrimaryBucketListener != null) {
            partitionAttributesFactory.addPartitionListener(lucenePrimaryBucketListener);
        }
        partitionAttributesFactory.setColocatedWith(colocatedWithRegionName);
        this.configureLuceneRegionAttributesFactory(partitionAttributesFactory, partitionAttributes);
        RegionAttributes baseAttributes = this.cache.getRegionAttributes(regionShortCut.toString());
        AttributesFactory factory = new AttributesFactory(baseAttributes);
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        if (regionAttributes.getDataPolicy().withPersistence()) {
            factory.setDiskStoreName(regionAttributes.getDiskStoreName());
        }
        RegionAttributes attributes = factory.create();
        return this.createRegion(regionName, attributes);
    }

    public void close() {
    }

    @Override
    public void dumpFiles(String directory) {
        ResultCollector results = FunctionService.onRegion((Region)this.getDataRegion()).setArguments((Object)new String[]{directory, this.indexName}).execute(DumpDirectoryFiles.ID);
        results.getResult();
    }

    @Override
    public void destroy(boolean initiator) {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying index regionPath=" + this.regionPath + "; indexName=" + this.indexName + "; initiator=" + initiator);
        }
        super.destroy(initiator);
        if (initiator) {
            this.destroyOnRemoteMembers();
        }
        if (initiator) {
            this.fileAndChunkRegion.destroyRegion();
            if (logger.isDebugEnabled()) {
                logger.debug("Destroyed fileAndChunkRegion=" + this.fileAndChunkRegion.getName());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroyed index regionPath=" + this.regionPath + "; indexName=" + this.indexName + "; initiator=" + initiator);
        }
    }

    private void destroyOnRemoteMembers() {
        PartitionedRegion pr = (PartitionedRegion)this.getDataRegion();
        DistributionManager dm = pr.getDistributionManager();
        Set recipients = pr.getRegionAdvisor().adviseAllPRNodes();
        if (!recipients.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("LuceneIndexForPartitionedRegion: About to send destroy message recipients=" + recipients);
            }
            ReplyProcessor21 processor = new ReplyProcessor21(dm, (Collection)recipients);
            DestroyLuceneIndexMessage message = new DestroyLuceneIndexMessage(recipients, processor.getProcessorId(), this.regionPath, this.indexName);
            dm.putOutgoing((DistributionMessage)message);
            if (logger.isDebugEnabled()) {
                logger.debug("LuceneIndexForPartitionedRegion: Sent message recipients=" + recipients);
            }
            try {
                processor.waitForReplies();
            }
            catch (ReplyException e) {
                if (!(e.getCause() instanceof CancelException)) {
                    throw e;
                }
            }
            catch (InterruptedException e) {
                dm.getCancelCriterion().checkCancelInProgress((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

