/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.LuceneIndexForPartitionedRegion;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.directory.RegionDirectory;
import org.apache.geode.cache.lucene.internal.partition.BucketTargetingMap;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexRepositoryImpl;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class IndexRepositoryFactory {
    private static final Logger logger = LogService.getLogger();
    public static final String FILE_REGION_LOCK_FOR_BUCKET_ID = "FileRegionLockForBucketId:";
    public static final String APACHE_GEODE_INDEX_COMPLETE = "APACHE_GEODE_INDEX_COMPLETE";

    public IndexRepository computeIndexRepository(Integer bucketId, LuceneSerializer serializer, LuceneIndexImpl index, PartitionedRegion userRegion, IndexRepository oldRepository) throws IOException {
        LuceneIndexForPartitionedRegion indexForPR = (LuceneIndexForPartitionedRegion)index;
        PartitionedRegion fileRegion = indexForPR.getFileAndChunkRegion();
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot((InternalCache)fileRegion.getCache());
        PartitionRegionConfig prConfig = (PartitionRegionConfig)prRoot.get((Object)fileRegion.getRegionIdentifier());
        while (!prConfig.isColocationComplete()) {
            prConfig = (PartitionRegionConfig)prRoot.get((Object)fileRegion.getRegionIdentifier());
        }
        BucketRegion fileAndChunkBucket = this.getMatchingBucket(fileRegion, bucketId);
        BucketRegion dataBucket = this.getMatchingBucket(userRegion, bucketId);
        boolean success = false;
        if (fileAndChunkBucket == null) {
            if (oldRepository != null) {
                oldRepository.cleanup();
            }
            return null;
        }
        if (!fileAndChunkBucket.getBucketAdvisor().isPrimary()) {
            if (oldRepository != null) {
                oldRepository.cleanup();
            }
            return null;
        }
        if (oldRepository != null && !oldRepository.isClosed()) {
            return oldRepository;
        }
        if (oldRepository != null) {
            oldRepository.cleanup();
        }
        DistributedLockService lockService = this.getLockService();
        String lockName = this.getLockName(fileAndChunkBucket);
        while (!lockService.lock((Object)lockName, 100L, -1L)) {
            if (fileAndChunkBucket.getBucketAdvisor().isPrimary()) continue;
            return null;
        }
        boolean initialPdxReadSerializedFlag = DefaultQuery.getPdxReadSerialized();
        DefaultQuery.setPdxReadSerialized((boolean)true);
        try {
            Map bucketTargetingMap = this.getBucketTargetingMap(fileAndChunkBucket, bucketId);
            RegionDirectory dir = new RegionDirectory(bucketTargetingMap, indexForPR.getFileSystemStats());
            IndexWriterConfig config = new IndexWriterConfig(indexForPR.getAnalyzer());
            IndexWriter writer = new IndexWriter((Directory)dir, config);
            IndexRepositoryImpl repo = new IndexRepositoryImpl((Region<?, ?>)fileAndChunkBucket, writer, serializer, indexForPR.getIndexStats(), (Region<?, ?>)dataBucket, lockService, lockName, indexForPR);
            success = false;
            if (null != fileRegion.get((Object)APACHE_GEODE_INDEX_COMPLETE, (Object)bucketId)) {
                success = true;
                IndexRepositoryImpl indexRepositoryImpl = repo;
                return indexRepositoryImpl;
            }
            success = this.reindexUserDataRegion(bucketId, userRegion, fileRegion, dataBucket, success, repo);
            IndexRepositoryImpl indexRepositoryImpl = repo;
            return indexRepositoryImpl;
        }
        catch (IOException e) {
            logger.info("Exception thrown while constructing Lucene Index for bucket:" + bucketId + " for file region:" + fileAndChunkBucket.getFullPath());
            throw e;
        }
        catch (CacheClosedException e) {
            logger.info("CacheClosedException thrown while constructing Lucene Index for bucket:" + bucketId + " for file region:" + fileAndChunkBucket.getFullPath());
            throw e;
        }
        finally {
            if (!success) {
                lockService.unlock((Object)lockName);
                DefaultQuery.setPdxReadSerialized((boolean)initialPdxReadSerializedFlag);
            }
        }
    }

    private boolean reindexUserDataRegion(Integer bucketId, PartitionedRegion userRegion, PartitionedRegion fileRegion, BucketRegion dataBucket, boolean success, IndexRepository repo) throws IOException {
        HashSet<IndexRepository> affectedRepos = new HashSet<IndexRepository>();
        for (Object key : dataBucket.keySet()) {
            Object value = this.getValue(userRegion.getEntry(key));
            if (value != null) {
                repo.update(key, value);
            } else {
                repo.delete(key);
            }
            affectedRepos.add(repo);
        }
        for (IndexRepository affectedRepo : affectedRepos) {
            affectedRepo.commit();
        }
        fileRegion.put((Object)APACHE_GEODE_INDEX_COMPLETE, (Object)APACHE_GEODE_INDEX_COMPLETE, (Object)bucketId);
        success = true;
        return success;
    }

    private Object getValue(Region.Entry entry) {
        Object value;
        EntrySnapshot es = (EntrySnapshot)entry;
        try {
            value = es == null ? null : es.getRawValue(true);
        }
        catch (EntryDestroyedException e) {
            value = null;
        }
        return value;
    }

    private Map getBucketTargetingMap(BucketRegion region, int bucketId) {
        return new BucketTargetingMap(region, bucketId);
    }

    private String getLockName(BucketRegion fileAndChunkBucket) {
        return FILE_REGION_LOCK_FOR_BUCKET_ID + fileAndChunkBucket.getFullPath();
    }

    private DistributedLockService getLockService() {
        return DistributedLockService.getServiceNamed((String)"__PRLS");
    }

    protected BucketRegion getMatchingBucket(PartitionedRegion region, Integer bucketId) {
        region.getOrCreateNodeForBucketWrite(bucketId.intValue(), null);
        return region.getDataStore().getLocalBucketById(bucketId);
    }
}

