/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.distributed.WaitUntilFlushedFunctionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class WaitUntilFlushedFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = 1L;
    public static final String ID = WaitUntilFlushedFunction.class.getName();
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext context) {
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        ResultSender resultSender = ctx.getResultSender();
        Region region = ctx.getDataSet();
        Cache cache = region.getCache();
        WaitUntilFlushedFunctionContext arg = (WaitUntilFlushedFunctionContext)ctx.getArguments();
        String indexName = arg.getIndexName();
        if (indexName == null) {
            throw new IllegalArgumentException("Missing index name");
        }
        long timeout = arg.getTimeout();
        TimeUnit unit = arg.getTimeunit();
        LuceneService service = LuceneServiceProvider.get((GemFireCache)cache);
        LuceneIndexImpl index = (LuceneIndexImpl)service.getIndex(indexName, region.getFullPath());
        boolean result = false;
        String aeqId = LuceneServiceImpl.getUniqueIndexName(indexName, region.getFullPath());
        AsyncEventQueueImpl queue = (AsyncEventQueueImpl)cache.getAsyncEventQueue(aeqId);
        if (queue != null) {
            try {
                result = queue.waitUntilFlushed(timeout, unit);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            throw new IllegalArgumentException("The AEQ does not exist for the index " + indexName + " region " + region.getFullPath());
        }
        resultSender.lastResult((Object)result);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }
}

