/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneFunctionSerializable;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexStatus;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDescribeIndexFunction;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.exceptions.UserErrorException;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public abstract class LuceneCommandBase
extends GfshCommand {
    private static final LuceneDescribeIndexFunction describeIndexFunction = new LuceneDescribeIndexFunction();

    protected ResultModel toTabularResult(List<LuceneIndexDetails> indexDetailsList, boolean stats) {
        if (!indexDetailsList.isEmpty()) {
            ResultModel result = new ResultModel();
            TabularResultModel indexData = result.addTable("lucene-indexes");
            for (LuceneIndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Index Name", indexDetails.getIndexName());
                indexData.accumulate("Region Path", indexDetails.getRegionPath());
                indexData.accumulate("Server Name", indexDetails.getServerName());
                indexData.accumulate("Indexed Fields", indexDetails.getSearchableFieldNamesString());
                indexData.accumulate("Field Analyzer", indexDetails.getFieldAnalyzersString());
                indexData.accumulate("Serializer", indexDetails.getSerializerString());
                indexData.accumulate("Status", indexDetails.getStatus().toString());
                if (!stats) continue;
                LuceneIndexStatus luceneIndexStatus = indexDetails.getStatus();
                if (luceneIndexStatus == LuceneIndexStatus.NOT_INITIALIZED || luceneIndexStatus == LuceneIndexStatus.INDEXING_IN_PROGRESS) {
                    indexData.accumulate("Query Executions", "NA");
                    indexData.accumulate("Updates", "NA");
                    indexData.accumulate("Commits", "NA");
                    indexData.accumulate("Documents", "NA");
                    continue;
                }
                indexData.accumulate("Query Executions", indexDetails.getIndexStats().get("queryExecutions").toString());
                indexData.accumulate("Updates", indexDetails.getIndexStats().get("updates").toString());
                indexData.accumulate("Commits", indexDetails.getIndexStats().get("commits").toString());
                indexData.accumulate("Documents", indexDetails.getIndexStats().get("documents").toString());
            }
            return result;
        }
        return ResultModel.createInfo((String)"No lucene indexes found");
    }

    protected List<LuceneIndexDetails> getIndexDetails(LuceneIndexInfo indexInfo) throws Exception {
        ResultCollector<?, ?> rc = this.executeFunctionOnRegion((Function)describeIndexFunction, indexInfo, true);
        List funcResults = (List)rc.getResult();
        return funcResults.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected ResultCollector<?, ?> executeFunctionOnRegion(Function function, LuceneFunctionSerializable functionArguments, boolean returnAllMembers) {
        Set targetMembers = CliUtil.getRegionAssociatedMembers((String)functionArguments.getRegionPath(), (InternalCache)((InternalCache)this.getCache()), (boolean)returnAllMembers);
        if (targetMembers.isEmpty()) {
            throw new UserErrorException(CliStrings.format((String)"Could not find any members defining region {0}.", (Object[])new Object[]{functionArguments.getRegionPath()}));
        }
        return this.executeFunction(function, functionArguments, targetMembers);
    }

    protected boolean indexCommandsAvailable() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh == null) {
            return true;
        }
        return gfsh.isConnectedAndReady();
    }
}

