/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.FixedPartitionResolver;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.DestroyLuceneIndexMessage;
import org.apache.geode.cache.lucene.internal.LuceneBucketListener;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.directory.DumpDirectoryFiles;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystemStats;
import org.apache.geode.cache.lucene.internal.partition.BucketTargetingFixedResolver;
import org.apache.geode.cache.lucene.internal.partition.BucketTargetingResolver;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;

public class LuceneIndexForPartitionedRegion
extends LuceneIndexImpl {
    protected Region fileAndChunkRegion;
    protected final FileSystemStats fileSystemStats;
    public static final String FILES_REGION_SUFFIX = ".files";
    private final ExecutorService waitingThreadPoolFromDM;

    public LuceneIndexForPartitionedRegion(String indexName, String regionPath, InternalCache cache) {
        super(indexName, regionPath, cache);
        this.waitingThreadPoolFromDM = cache.getDistributionManager().getExecutors().getWaitingThreadPool();
        String statsName = indexName + "-" + regionPath;
        this.fileSystemStats = new FileSystemStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    protected RepositoryManager createRepositoryManager(LuceneSerializer luceneSerializer) {
        LuceneSerializer mapper = luceneSerializer;
        if (mapper == null) {
            mapper = new HeterogeneousLuceneSerializer();
        }
        PartitionedRepositoryManager partitionedRepositoryManager = new PartitionedRepositoryManager(this, mapper, this.waitingThreadPoolFromDM);
        return partitionedRepositoryManager;
    }

    @Override
    public boolean isIndexingInProgress() {
        PartitionedRegion userRegion = (PartitionedRegion)this.cache.getRegion(this.getRegionPath());
        Set fileRegionPrimaryBucketIds = this.getFileAndChunkRegion().getDataStore().getAllLocalPrimaryBucketIds();
        for (Integer bucketId : fileRegionPrimaryBucketIds) {
            BucketRegion userBucket = userRegion.getDataStore().getLocalBucketById(bucketId);
            if (userBucket.isEmpty() || this.isIndexAvailable(bucketId)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createLuceneListenersAndFileChunkRegions(PartitionedRepositoryManager partitionedRepositoryManager) {
        boolean withStorage;
        partitionedRepositoryManager.setUserRegionForRepositoryManager((PartitionedRegion)this.dataRegion);
        boolean withPersistence = this.withPersistence();
        RegionAttributes regionAttributes = this.dataRegion.getAttributes();
        boolean bl = withStorage = regionAttributes.getPartitionAttributes().getLocalMaxMemory() > 0;
        RegionShortcut regionShortCut = !withStorage ? RegionShortcut.PARTITION_PROXY : (withPersistence ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION);
        String fileRegionName = this.createFileRegionName();
        PartitionAttributes partitionAttributes = this.dataRegion.getPartitionAttributes();
        DistributionManager dm = this.cache.getInternalDistributedSystem().getDistributionManager();
        LuceneBucketListener lucenePrimaryBucketListener = new LuceneBucketListener(partitionedRepositoryManager, dm);
        if (!this.fileRegionExists(fileRegionName)) {
            this.fileAndChunkRegion = this.createRegion(fileRegionName, regionShortCut, this.regionPath, partitionAttributes, regionAttributes, (PartitionListener)lucenePrimaryBucketListener);
        }
        this.fileSystemStats.setBytesSupplier(() -> this.getFileAndChunkRegion().getPrStats().getDataStoreBytesInUse());
    }

    public PartitionedRegion getFileAndChunkRegion() {
        return (PartitionedRegion)this.fileAndChunkRegion;
    }

    public FileSystemStats getFileSystemStats() {
        return this.fileSystemStats;
    }

    boolean fileRegionExists(String fileRegionName) {
        return this.cache.getRegion(fileRegionName) != null;
    }

    public String createFileRegionName() {
        return LuceneServiceImpl.getUniqueIndexRegionName(this.indexName, this.regionPath, FILES_REGION_SUFFIX);
    }

    private PartitionAttributesFactory configureLuceneRegionAttributesFactory(PartitionAttributesFactory attributesFactory, PartitionAttributes<?, ?> dataRegionAttributes) {
        attributesFactory.setTotalNumBuckets(dataRegionAttributes.getTotalNumBuckets());
        attributesFactory.setRedundantCopies(dataRegionAttributes.getRedundantCopies());
        attributesFactory.setPartitionResolver(this.getPartitionResolver(dataRegionAttributes));
        attributesFactory.setRecoveryDelay(dataRegionAttributes.getRecoveryDelay());
        attributesFactory.setStartupRecoveryDelay(dataRegionAttributes.getStartupRecoveryDelay());
        return attributesFactory;
    }

    private PartitionResolver getPartitionResolver(PartitionAttributes dataRegionAttributes) {
        if (dataRegionAttributes.getPartitionResolver() instanceof FixedPartitionResolver) {
            return new BucketTargetingFixedResolver();
        }
        return new BucketTargetingResolver();
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionShortcut regionShortCut, String colocatedWithRegionName, PartitionAttributes partitionAttributes, RegionAttributes regionAttributes, PartitionListener lucenePrimaryBucketListener) {
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory();
        if (lucenePrimaryBucketListener != null) {
            partitionAttributesFactory.addPartitionListener(lucenePrimaryBucketListener);
        }
        partitionAttributesFactory.setColocatedWith(colocatedWithRegionName);
        this.configureLuceneRegionAttributesFactory(partitionAttributesFactory, partitionAttributes);
        RegionAttributes baseAttributes = this.cache.getRegionAttributes(regionShortCut.toString());
        AttributesFactory factory = new AttributesFactory(baseAttributes);
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        if (regionAttributes.getDataPolicy().withPersistence()) {
            factory.setDiskStoreName(regionAttributes.getDiskStoreName());
        }
        RegionAttributes attributes = factory.create();
        return this.createRegion(regionName, attributes);
    }

    public void close() {
    }

    @Override
    public void dumpFiles(String directory) {
        ResultCollector results = FunctionService.onRegion((Region)this.getDataRegion()).setArguments((Object)new String[]{directory, this.indexName}).execute(DumpDirectoryFiles.ID);
        results.getResult();
    }

    @Override
    public void destroy(boolean initiator) {
        block7: {
            if (logger.isDebugEnabled()) {
                logger.debug("Destroying index regionPath=" + this.regionPath + "; indexName=" + this.indexName + "; initiator=" + initiator);
            }
            super.destroy(initiator);
            if (initiator) {
                this.destroyOnRemoteMembers();
            }
            if (initiator) {
                try {
                    this.fileAndChunkRegion.destroyRegion();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Destroyed fileAndChunkRegion=" + this.fileAndChunkRegion.getName());
                    }
                }
                catch (RegionDestroyedException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("Already destroyed fileAndChunkRegion=" + this.fileAndChunkRegion.getName());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroyed index regionPath=" + this.regionPath + "; indexName=" + this.indexName + "; initiator=" + initiator);
        }
    }

    @Override
    public boolean isIndexAvailable(int id) {
        PartitionedRegion fileAndChunkRegion = this.getFileAndChunkRegion();
        return fileAndChunkRegion.get((Object)"APACHE_GEODE_INDEX_COMPLETE", (Object)id) != null || !LuceneServiceImpl.LUCENE_REINDEX;
    }

    private void destroyOnRemoteMembers() {
        DistributionManager dm = this.getDataRegion().getDistributionManager();
        Set recipients = dm.getOtherNormalDistributionManagerIds();
        if (!recipients.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("LuceneIndexForPartitionedRegion: About to send destroy message recipients=" + recipients);
            }
            ReplyProcessor21 processor = new ReplyProcessor21(dm, (Collection)recipients);
            DestroyLuceneIndexMessage message = new DestroyLuceneIndexMessage(recipients, processor.getProcessorId(), this.regionPath, this.indexName);
            dm.putOutgoing((DistributionMessage)message);
            if (logger.isDebugEnabled()) {
                logger.debug("LuceneIndexForPartitionedRegion: Sent message recipients=" + recipients);
            }
            try {
                processor.waitForReplies();
            }
            catch (ReplyException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalArgumentException) {
                    String fullRegionPath = this.regionPath.startsWith("/") ? this.regionPath : "/" + this.regionPath;
                    String indexNotFoundMessage = String.format("Lucene index %s was not found in region %s", this.indexName, fullRegionPath);
                    if (!cause.getLocalizedMessage().equals(indexNotFoundMessage)) {
                        throw e;
                    }
                } else if (!(cause instanceof CancelException)) {
                    throw e;
                }
            }
            catch (InterruptedException e) {
                dm.getCancelCriterion().checkCancelInProgress((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

