/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.xml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.xml.LuceneIndexXmlGenerator;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneIndexCreation
implements LuceneIndex,
Extension<Region<?, ?>> {
    private Region region;
    private String name;
    private Set<String> fieldNames = new LinkedHashSet<String>();
    private Map<String, Analyzer> fieldAnalyzers;

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzers() {
        if (this.fieldAnalyzers == null) {
            this.fieldAnalyzers = new HashMap<String, Analyzer>();
        }
        return this.fieldAnalyzers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames.toArray(new String[this.fieldNames.size()]);
    }

    @Override
    public String getRegionPath() {
        return this.region.getFullPath();
    }

    public XmlGenerator<Region<?, ?>> getXmlGenerator() {
        return new LuceneIndexXmlGenerator(this);
    }

    public void beforeCreate(Extensible<Region<?, ?>> source, Cache cache) {
        LuceneServiceImpl service = (LuceneServiceImpl)LuceneServiceProvider.get((GemFireCache)cache);
        StandardAnalyzer analyzer = this.fieldAnalyzers == null ? new StandardAnalyzer() : new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), this.fieldAnalyzers);
        service.createIndex(this.getName(), this.getRegionPath(), (Analyzer)analyzer, this.fieldAnalyzers, this.getFieldNames());
    }

    public void onCreate(Extensible<Region<?, ?>> source, Extensible<Region<?, ?>> target) {
    }

    protected void addField(String name) {
        this.fieldNames.add(name);
    }

    protected void addFieldAndAnalyzer(String name, Analyzer analyzer) {
        this.fieldNames.add(name);
        this.getFieldAnalyzers().put(name, analyzer);
    }

    public void addFieldNames(String[] fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
    }

    @Override
    public boolean waitUntilFlushed(long timeout, TimeUnit unit) {
        return true;
    }
}

