/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository.serializer;

import org.apache.geode.cache.lucene.internal.repository.serializer.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

class PdxLuceneSerializer
implements LuceneSerializer {
    private String[] indexedFields;
    private static final Logger logger = LogService.getLogger();

    public PdxLuceneSerializer(String[] indexedFields) {
        this.indexedFields = indexedFields;
    }

    @Override
    public void toDocument(Object value, Document doc) {
        PdxInstance pdx = (PdxInstance)value;
        for (String field : this.indexedFields) {
            Object fieldValue;
            if (!pdx.hasField(field) || (fieldValue = pdx.getField(field)) == null) continue;
            SerializerUtil.addField(doc, field, fieldValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PdxLuceneSerializer.toDocument:" + doc);
        }
    }
}

