/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneQueryInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneSearchResults;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneCreateIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDescribeIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneSearchIndexFunction;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.AbstractCommandsSupport;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneIndexCommands
extends AbstractCommandsSupport {
    private static final LuceneCreateIndexFunction createIndexFunction = new LuceneCreateIndexFunction();
    private static final LuceneDescribeIndexFunction describeIndexFunction = new LuceneDescribeIndexFunction();
    private static final LuceneSearchIndexFunction searchIndexFunction = new LuceneSearchIndexFunction();
    private List<LuceneSearchResults> searchResults = null;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    @CliCommand(value={"list lucene indexes"}, help="Display the list of lucene indexes created for all members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listIndex(@CliOption(key={"with-stats"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display lucene index stats") boolean stats) {
        try {
            return this.toTabularResult(this.getIndexListing(), stats);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"list lucene indexes"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().info(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while collecting all lucene index information across the Geode cluster: %1$s", LuceneIndexCommands.toString((Throwable)t, (boolean)this.isDebugging())));
        }
    }

    protected List<LuceneIndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getMembers(this.getCache()));
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute((Function)new LuceneListIndexFunction());
        List results = (List)resultsCollector.getResult();
        List<LuceneIndexDetails> sortedResults = results.stream().flatMap(set -> set.stream()).sorted().collect(Collectors.toList());
        LinkedHashSet<LuceneIndexDetails> uniqResults = new LinkedHashSet<LuceneIndexDetails>();
        uniqResults.addAll(sortedResults);
        sortedResults.clear();
        sortedResults.addAll(uniqResults);
        return sortedResults;
    }

    protected Result toTabularResult(List<LuceneIndexDetails> indexDetailsList, boolean stats) {
        if (!indexDetailsList.isEmpty()) {
            TabularResultData indexData = ResultBuilder.createTabularResultData();
            for (LuceneIndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Index Name", (Object)indexDetails.getIndexName());
                indexData.accumulate("Region Path", (Object)indexDetails.getRegionPath());
                indexData.accumulate("Server Name", (Object)indexDetails.getServerName());
                indexData.accumulate("Indexed Fields", (Object)indexDetails.getSearchableFieldNamesString());
                indexData.accumulate("Field Analyzer", (Object)indexDetails.getFieldAnalyzersString());
                indexData.accumulate("Status", (Object)(indexDetails.getInitialized() ? "Initialized" : "Defined"));
                if (!stats) continue;
                if (!indexDetails.getInitialized()) {
                    indexData.accumulate("Query Executions", (Object)"NA");
                    indexData.accumulate("Updates", (Object)"NA");
                    indexData.accumulate("Commits", (Object)"NA");
                    indexData.accumulate("Documents", (Object)"NA");
                    continue;
                }
                indexData.accumulate("Query Executions", (Object)indexDetails.getIndexStats().get("queryExecutions"));
                indexData.accumulate("Updates", (Object)indexDetails.getIndexStats().get("updates"));
                indexData.accumulate("Commits", (Object)indexDetails.getIndexStats().get("commits"));
                indexData.accumulate("Documents", (Object)indexDetails.getIndexStats().get("documents"));
            }
            return ResultBuilder.buildResult((ResultData)indexData);
        }
        return ResultBuilder.createInfoResult((String)"No lucene indexes found");
    }

    @CliCommand(value={"create lucene index"}, help="Create a lucene index that can be used to execute queries.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to create.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Name/Path of the region where the lucene index is created on.") String regionPath, @CliOption(key={"field"}, mandatory=true, help="fields on the region values which are stored in the lucene index.") @CliMetaData(valueSeparator=",") String[] fields, @CliOption(key={"analyzer"}, mandatory=false, unspecifiedDefaultValue="__NULL__", help="Type of the analyzer for each field.") @CliMetaData(valueSeparator=",") String[] analyzers, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", unspecifiedDefaultValue="__NULL__", help="Group of members in which the lucene index will be created.") @CliMetaData(valueSeparator=",") String[] groups) {
        Result result = null;
        Object xmlEntity = null;
        this.securityService.authorizeRegionManage(regionPath);
        try {
            Cache cache = this.getCache();
            LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath, fields, analyzers);
            ResultCollector<?, ?> rc = this.executeFunctionOnGroups(createIndexFunction, groups, indexInfo);
            List funcResults = (List)rc.getResult();
            TabularResultData tabularResult = ResultBuilder.createTabularResultData();
            for (CliFunctionResult cliFunctionResult : funcResults) {
                tabularResult.accumulate("Member", (Object)cliFunctionResult.getMemberIdOrName());
                if (cliFunctionResult.isSuccessful()) {
                    tabularResult.accumulate("Status", (Object)"Successfully created lucene index");
                    continue;
                }
                tabularResult.accumulate("Status", (Object)("Failed: " + cliFunctionResult.getMessage()));
            }
            result = ResultBuilder.buildResult((ResultData)tabularResult);
        }
        catch (CommandResultException crex) {
            result = crex.getResult();
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult((String)e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"describe lucene index"}, help="Display the describe of lucene indexes created for all members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to describe.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Name/Path of the region where the lucene index to be described exists.") String regionPath) {
        try {
            LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath);
            return this.toTabularResult(this.getIndexDetails(indexInfo), true);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"describe lucene index"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createInfoResult((String)e.getMessage());
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().info(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while collecting lucene index information across the Geode cluster: %1$s", LuceneIndexCommands.toString((Throwable)t, (boolean)this.isDebugging())));
        }
    }

    protected List<LuceneIndexDetails> getIndexDetails(LuceneIndexInfo indexInfo) throws Exception {
        this.securityService.authorizeRegionManage(indexInfo.getRegionPath());
        ResultCollector<?, ?> rc = this.executeFunctionOnGroups(describeIndexFunction, new String[0], indexInfo);
        List funcResults = (List)rc.getResult();
        return funcResults.stream().filter(indexDetails -> indexDetails != null).collect(Collectors.toList());
    }

    @CliCommand(value={"search lucene"}, help="Search lucene index")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result searchIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to search.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Name/Path of the region where the lucene index exists.") String regionPath, @CliOption(key={"queryStrings"}, mandatory=true, help="Query string to search the lucene index") String queryString, @CliOption(key={"defaultField"}, mandatory=true, help="Default field to search in") String defaultField, @CliOption(key={"limit"}, mandatory=false, unspecifiedDefaultValue="-1", help="Number of search results needed") int limit, @CliOption(key={"pageSize"}, mandatory=false, unspecifiedDefaultValue="-1", help="Number of results to be returned in a page") int pageSize, @CliOption(key={"keys-only"}, mandatory=false, unspecifiedDefaultValue="false", help="Return only keys of search results.") boolean keysOnly) {
        try {
            LuceneQueryInfo queryInfo = new LuceneQueryInfo(indexName, regionPath, queryString, defaultField, limit, keysOnly);
            if (pageSize == -1) {
                pageSize = Integer.MAX_VALUE;
            }
            this.searchResults = this.getSearchResults(queryInfo);
            return this.displayResults(pageSize, keysOnly);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"search lucene"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createInfoResult((String)e.getMessage());
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().info(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while searching lucene index across the Geode cluster: %1$s", LuceneIndexCommands.toString((Throwable)t, (boolean)this.isDebugging())));
        }
    }

    private Result displayResults(int pageSize, boolean keysOnly) throws Exception {
        if (this.searchResults.size() == 0) {
            return ResultBuilder.createInfoResult((String)"No results");
        }
        Gfsh gfsh = this.initGfsh();
        boolean pagination = this.searchResults.size() > pageSize;
        int fromIndex = 0;
        int toIndex = pageSize < this.searchResults.size() ? pageSize : this.searchResults.size();
        int currentPage = 1;
        int totalPages = (int)Math.ceil((float)this.searchResults.size() / (float)pageSize);
        boolean skipDisplay = false;
        String step = null;
        block10: while (true) {
            if (!skipDisplay) {
                CommandResult commandResult = (CommandResult)this.getResults(fromIndex, toIndex, keysOnly);
                if (!pagination) {
                    return commandResult;
                }
                Gfsh.println();
                while (commandResult.hasNextLine()) {
                    gfsh.printAsInfo(commandResult.nextLine());
                }
                gfsh.printAsInfo("\t\tPage " + currentPage + " of " + totalPages);
                String message = "Press n to move to next page, q to quit and p to previous page : ";
                step = gfsh.interact(message);
            }
            switch (step) {
                case "n": {
                    if (currentPage == totalPages) {
                        gfsh.printAsInfo("No more results to display.");
                        step = gfsh.interact("Press p to move to last page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    ++currentPage;
                    int current = fromIndex;
                    fromIndex = toIndex;
                    toIndex = pageSize + fromIndex >= this.searchResults.size() ? this.searchResults.size() : pageSize + fromIndex;
                    continue block10;
                }
                case "p": {
                    if (currentPage == 1) {
                        gfsh.printAsInfo("At the top of the search results.");
                        step = gfsh.interact("Press n to move to the first page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    --currentPage;
                    int current = fromIndex;
                    toIndex = fromIndex;
                    fromIndex = current - pageSize <= 0 ? 0 : current - pageSize;
                    continue block10;
                }
                case "q": {
                    return ResultBuilder.createInfoResult((String)"Search complete.");
                }
            }
            Gfsh.println((Object)"Invalid option");
        }
    }

    protected Gfsh initGfsh() {
        return Gfsh.getCurrentInstance();
    }

    private List<LuceneSearchResults> getSearchResults(LuceneQueryInfo queryInfo) throws Exception {
        this.securityService.authorizeRegionManage(queryInfo.getRegionPath());
        String[] groups = new String[]{};
        ResultCollector<?, ?> rc = this.executeSearch(queryInfo);
        List functionResults = (List)rc.getResult();
        return functionResults.stream().flatMap(set -> set.stream()).sorted().collect(Collectors.toList());
    }

    private Result getResults(int fromIndex, int toIndex, boolean keysonly) throws Exception {
        TabularResultData data = ResultBuilder.createTabularResultData();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!this.searchResults.get(i).getExeptionFlag()) {
                data.accumulate("key", (Object)this.searchResults.get(i).getKey());
                if (keysonly) continue;
                data.accumulate("value", (Object)this.searchResults.get(i).getValue());
                data.accumulate("score", (Object)Float.valueOf(this.searchResults.get(i).getScore()));
                continue;
            }
            throw new Exception(this.searchResults.get(i).getExceptionMessage());
        }
        return ResultBuilder.buildResult((ResultData)data);
    }

    protected ResultCollector<?, ?> executeFunctionOnGroups(FunctionAdapter function, String[] groups, LuceneIndexInfo indexInfo) throws IllegalArgumentException, CommandResultException {
        Set targetMembers;
        if (function != createIndexFunction) {
            targetMembers = CliUtil.getMembersForeRegionViaFunction((Cache)this.getCache(), (String)indexInfo.getRegionPath(), (boolean)true);
            if (targetMembers.isEmpty()) {
                throw new IllegalArgumentException("Region not found.");
            }
        } else {
            targetMembers = CliUtil.findMembersOrThrow((String[])groups, null);
        }
        return CliUtil.executeFunction((Function)function, (Object)indexInfo, (Set)targetMembers);
    }

    protected ResultCollector<?, ?> executeSearch(LuceneQueryInfo queryInfo) throws Exception {
        Set targetMembers = CliUtil.getMembersForeRegionViaFunction((Cache)this.getCache(), (String)queryInfo.getRegionPath(), (boolean)false);
        if (targetMembers.isEmpty()) {
            throw new IllegalArgumentException("Region not found.");
        }
        return CliUtil.executeFunction((Function)searchIndexFunction, (Object)queryInfo, (Set)targetMembers);
    }

    @CliAvailabilityIndicator(value={"search lucene", "create lucene index", "describe lucene index", "list lucene indexes"})
    public boolean indexCommandsAvailable() {
        return !CliUtil.isGfshVM() || LuceneIndexCommands.getGfsh() != null && LuceneIndexCommands.getGfsh().isConnectedAndReady();
    }
}

