/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.lucene.LuceneQueryException;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunctionContext;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexResultCollector;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;

public class LuceneFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;
    public static final String ID = LuceneFunction.class.getName();
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        TopEntriesCollectorManager manager;
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        ResultSender resultSender = ctx.getResultSender();
        Region region = ctx.getDataSet();
        LuceneFunctionContext searchContext = (LuceneFunctionContext)ctx.getArguments();
        if (searchContext == null) {
            throw new IllegalArgumentException("Missing search context");
        }
        LuceneQueryProvider queryProvider = searchContext.getQueryProvider();
        if (queryProvider == null) {
            throw new IllegalArgumentException("Missing query provider");
        }
        LuceneService service = LuceneServiceProvider.get((GemFireCache)region.getCache());
        LuceneIndexImpl index = (LuceneIndexImpl)service.getIndex(searchContext.getIndexName(), region.getFullPath());
        RepositoryManager repoManager = index.getRepositoryManager();
        LuceneIndexStats stats = index.getIndexStats();
        Query query = null;
        try {
            query = queryProvider.getQuery(index);
        }
        catch (LuceneQueryException e) {
            logger.warn("", (Throwable)((Object)e));
            throw new FunctionException((Throwable)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing lucene query: {}, on region {}", (Object)query, (Object)region.getFullPath());
        }
        int resultLimit = searchContext.getLimit();
        TopEntriesCollectorManager topEntriesCollectorManager = manager = searchContext == null ? null : searchContext.getCollectorManager();
        if (manager == null) {
            manager = new TopEntriesCollectorManager(null, resultLimit);
        }
        ArrayList results = new ArrayList();
        TopEntriesCollector mergedResult = null;
        try {
            long start = stats.startQuery();
            try {
                Collection<IndexRepository> repositories = repoManager.getRepositories(ctx);
                for (IndexRepository repo : repositories) {
                    Object collector = manager.newCollector(repo.toString());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Executing search on repo: " + repo.toString());
                    }
                    repo.query(query, resultLimit, (IndexResultCollector)collector);
                    results.add(collector);
                }
                mergedResult = (TopEntriesCollector)manager.reduce(results);
                stats.endQuery(start, mergedResult == null ? 0 : mergedResult.size());
            }
            catch (Throwable throwable) {
                stats.endQuery(start, mergedResult == null ? 0 : mergedResult.size());
                throw throwable;
            }
            resultSender.lastResult((Object)mergedResult);
        }
        catch (IOException | BucketNotFoundException e) {
            logger.warn("", e);
            throw new FunctionException(e);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }
}

