/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneQueryFactory;
import org.apache.geode.cache.lucene.internal.IndexListener;
import org.apache.geode.cache.lucene.internal.InternalLuceneService;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexFactory;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneQueryFactoryImpl;
import org.apache.geode.cache.lucene.internal.StringQueryProvider;
import org.apache.geode.cache.lucene.internal.directory.DumpDirectoryFiles;
import org.apache.geode.cache.lucene.internal.distributed.EntryScore;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunction;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunctionContext;
import org.apache.geode.cache.lucene.internal.distributed.TopEntries;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import org.apache.geode.cache.lucene.internal.filesystem.ChunkKey;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.management.LuceneServiceMBean;
import org.apache.geode.cache.lucene.internal.management.ManagementIndexListener;
import org.apache.geode.cache.lucene.internal.xml.LuceneServiceXmlGenerator;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneServiceImpl
implements InternalLuceneService {
    public static LuceneIndexFactory luceneIndexFactory = new LuceneIndexFactory();
    private static final Logger logger = LogService.getLogger();
    private GemFireCacheImpl cache;
    private final HashMap<String, LuceneIndex> indexMap = new HashMap();
    private final HashMap<String, LuceneIndexCreationProfile> definedIndexMap = new HashMap();
    private IndexListener managementListener;

    public void init(Cache cache) {
        if (cache == null) {
            throw new IllegalStateException(LocalizedStrings.CqService_CACHE_IS_NULL.toLocalizedString());
        }
        GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
        gfc.getCancelCriterion().checkCancelInProgress(null);
        this.cache = gfc;
        FunctionService.registerFunction((Function)new LuceneFunction());
        FunctionService.registerFunction((Function)new DumpDirectoryFiles());
        LuceneServiceImpl.registerDataSerializables();
    }

    public CacheServiceMBeanBase getMBean() {
        LuceneServiceMBean mbean = new LuceneServiceMBean(this);
        this.managementListener = new ManagementIndexListener(mbean);
        return mbean;
    }

    public Class<? extends CacheService> getInterface() {
        return InternalLuceneService.class;
    }

    public static String getUniqueIndexName(String indexName, String regionPath) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        String name = indexName + "#" + regionPath.replace('/', '_');
        return name;
    }

    @Override
    public void createIndex(String indexName, String regionPath, String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("At least one field must be indexed");
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        this.createIndex(indexName, regionPath, (Analyzer)analyzer, null, fields);
    }

    @Override
    public void createIndex(String indexName, String regionPath, Map<String, Analyzer> fieldAnalyzers) {
        if (fieldAnalyzers == null || fieldAnalyzers.isEmpty()) {
            throw new IllegalArgumentException("At least one field must be indexed");
        }
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), fieldAnalyzers);
        Set<String> fieldsSet = fieldAnalyzers.keySet();
        String[] fields = fieldsSet.toArray(new String[fieldsSet.size()]);
        this.createIndex(indexName, regionPath, (Analyzer)analyzer, fieldAnalyzers, fields);
    }

    public void createIndex(final String indexName, String regionPath, final Analyzer analyzer, final Map<String, Analyzer> fieldAnalyzers, final String ... fields) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        this.registerDefinedIndex(LuceneServiceImpl.getUniqueIndexName(indexName, regionPath), new LuceneIndexCreationProfile(indexName, regionPath, fields, analyzer, fieldAnalyzers));
        Region region = this.cache.getRegion(regionPath);
        if (region != null) {
            this.definedIndexMap.remove(LuceneServiceImpl.getUniqueIndexName(indexName, regionPath));
            throw new IllegalStateException("The lucene index must be created before region");
        }
        final String dataRegionPath = regionPath;
        this.cache.addRegionListener(new RegionListener(){

            public RegionAttributes beforeCreate(Region parent, String regionName, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) {
                String path;
                RegionAttributes updatedRA = attrs;
                String string = path = parent == null ? "/" + regionName : parent.getFullPath() + "/" + regionName;
                if (path.equals(dataRegionPath)) {
                    if (!attrs.getDataPolicy().withPartitioning()) {
                        throw new UnsupportedOperationException("Lucene indexes on replicated regions are not supported");
                    }
                    EvictionAttributes evictionAttributes = attrs.getEvictionAttributes();
                    EvictionAlgorithm evictionAlgorithm = evictionAttributes.getAlgorithm();
                    if (evictionAlgorithm != EvictionAlgorithm.NONE && evictionAttributes.getAction().isLocalDestroy()) {
                        throw new UnsupportedOperationException("Lucene indexes on regions with eviction and action local destroy are not supported");
                    }
                    String aeqId = LuceneServiceImpl.getUniqueIndexName(indexName, dataRegionPath);
                    if (!attrs.getAsyncEventQueueIds().contains(aeqId)) {
                        AttributesFactory af = new AttributesFactory(attrs);
                        af.addAsyncEventQueueId(aeqId);
                        updatedRA = af.create();
                    }
                    internalRegionArgs.addCacheServiceProfile((CacheServiceProfile)new LuceneIndexCreationProfile(indexName, dataRegionPath, fields, analyzer, fieldAnalyzers));
                }
                return updatedRA;
            }

            public void afterCreate(Region region) {
                if (region.getFullPath().equals(dataRegionPath)) {
                    LuceneServiceImpl.this.afterDataRegionCreated(indexName, analyzer, dataRegionPath, fieldAnalyzers, fields);
                    LuceneServiceImpl.this.cache.removeRegionListener((RegionListener)this);
                }
            }
        });
    }

    public void afterDataRegionCreated(String indexName, Analyzer analyzer, String dataRegionPath, Map<String, Analyzer> fieldAnalyzers, String ... fields) {
        LuceneIndexImpl index = this.createIndexRegions(indexName, dataRegionPath);
        index.setSearchableFields(fields);
        index.setAnalyzer(analyzer);
        index.setFieldAnalyzers(fieldAnalyzers);
        index.initialize();
        this.registerIndex(index);
        if (this.managementListener != null) {
            this.managementListener.afterIndexCreated(index);
        }
    }

    private LuceneIndexImpl createIndexRegions(String indexName, String regionPath) {
        Region dataregion = this.cache.getRegion(regionPath);
        if (dataregion == null) {
            logger.info("Data region " + regionPath + " not found");
            return null;
        }
        regionPath = dataregion.getFullPath();
        return luceneIndexFactory.create(indexName, regionPath, this.cache);
    }

    private void registerDefinedIndex(String regionAndIndex, LuceneIndexCreationProfile luceneIndexCreationProfile) {
        if (this.definedIndexMap.containsKey(regionAndIndex) || this.indexMap.containsKey(regionAndIndex)) {
            throw new IllegalArgumentException("Lucene index already exists in region");
        }
        this.definedIndexMap.put(regionAndIndex, luceneIndexCreationProfile);
    }

    @Override
    public LuceneIndex getIndex(String indexName, String regionPath) {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        return this.indexMap.get(LuceneServiceImpl.getUniqueIndexName(indexName, region.getFullPath()));
    }

    @Override
    public Collection<LuceneIndex> getAllIndexes() {
        return this.indexMap.values();
    }

    @Override
    public void destroyIndex(LuceneIndex index) {
        LuceneIndexImpl indexImpl = (LuceneIndexImpl)index;
        this.indexMap.remove(LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath()));
    }

    @Override
    public LuceneQueryFactory createLuceneQueryFactory() {
        return new LuceneQueryFactoryImpl((Cache)this.cache);
    }

    public XmlGenerator<Cache> getXmlGenerator() {
        return new LuceneServiceXmlGenerator();
    }

    public void beforeCreate(Extensible<Cache> source, Cache cache) {
    }

    public void onCreate(Extensible<Cache> source, Extensible<Cache> target) {
    }

    public void registerIndex(LuceneIndex index) {
        String regionAndIndex = LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath());
        if (!this.indexMap.containsKey(regionAndIndex)) {
            this.indexMap.put(regionAndIndex, index);
        }
        this.definedIndexMap.remove(regionAndIndex);
    }

    public void unregisterIndex(String region) {
        if (this.indexMap.containsKey(region)) {
            this.indexMap.remove(region);
        }
    }

    public static void registerDataSerializables() {
        DSFIDFactory.registerDSFID((int)2169, ChunkKey.class);
        DSFIDFactory.registerDSFID((int)2170, File.class);
        DSFIDFactory.registerDSFID((int)2171, LuceneFunctionContext.class);
        DSFIDFactory.registerDSFID((int)2172, StringQueryProvider.class);
        DSFIDFactory.registerDSFID((int)2173, TopEntriesCollectorManager.class);
        DSFIDFactory.registerDSFID((int)2174, EntryScore.class);
        DSFIDFactory.registerDSFID((int)2175, TopEntries.class);
        DSFIDFactory.registerDSFID((int)2176, TopEntriesCollector.class);
    }

    public Collection<LuceneIndexCreationProfile> getAllDefinedIndexes() {
        return this.definedIndexMap.values();
    }

    public LuceneIndexCreationProfile getDefinedIndex(String indexName, String regionPath) {
        return this.definedIndexMap.get(LuceneServiceImpl.getUniqueIndexName(indexName, regionPath));
    }
}

