/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.management;

import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.management.LuceneIndexMetrics;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class LuceneIndexStatsMonitor
extends MBeanStatsMonitor {
    private StatsRate updateRate;
    private StatsAverageLatency updateRateAverageLatency;
    private StatsRate commitRate;
    private StatsAverageLatency commitRateAverageLatency;
    private StatsRate queryRate;
    private StatsAverageLatency queryRateAverageLatency;
    public static final String LUCENE_SERVICE_MXBEAN_MONITOR_PREFIX = "LuceneServiceMXBeanMonitor_";

    public LuceneIndexStatsMonitor(LuceneIndex index) {
        super(LUCENE_SERVICE_MXBEAN_MONITOR_PREFIX + index.getRegionPath() + "_" + index.getName());
        this.addStatisticsToMonitor(((LuceneIndexImpl)index).getIndexStats().getStats());
        this.configureMetrics();
    }

    private void configureMetrics() {
        this.queryRate = new StatsRate("queryExecutions", StatType.INT_TYPE, (MBeanStatsMonitor)this);
        this.updateRate = new StatsRate("updates", StatType.INT_TYPE, (MBeanStatsMonitor)this);
        this.commitRate = new StatsRate("commits", StatType.INT_TYPE, (MBeanStatsMonitor)this);
        this.queryRateAverageLatency = new StatsAverageLatency("queryExecutions", StatType.INT_TYPE, "queryExecutionTime", (MBeanStatsMonitor)this);
        this.updateRateAverageLatency = new StatsAverageLatency("updates", StatType.INT_TYPE, "updateTime", (MBeanStatsMonitor)this);
        this.commitRateAverageLatency = new StatsAverageLatency("commits", StatType.INT_TYPE, "commitTime", (MBeanStatsMonitor)this);
    }

    protected LuceneIndexMetrics getIndexMetrics(LuceneIndex index) {
        int queryExecutions = this.getStatistic("queryExecutions").intValue();
        long queryExecutionTime = this.getStatistic("queryExecutionTime").longValue();
        float queryRateValue = this.queryRate.getRate();
        long queryRateAverageLatencyValue = this.queryRateAverageLatency.getAverageLatency();
        int queryExecutionsInProgress = this.getStatistic("queryExecutionsInProgress").intValue();
        long queryExecutionTotalHits = this.getStatistic("queryExecutionTotalHits").longValue();
        int updates = this.getStatistic("updates").intValue();
        long updateTime = this.getStatistic("updateTime").longValue();
        float updateRateValue = this.updateRate.getRate();
        long updateRateAverageLatencyValue = this.updateRateAverageLatency.getAverageLatency();
        int updatesInProgress = this.getStatistic("updatesInProgress").intValue();
        int commits = this.getStatistic("commits").intValue();
        long commitTime = this.getStatistic("commitTime").longValue();
        float commitRateValue = this.commitRate.getRate();
        long commitRateAverageLatencyValue = this.commitRateAverageLatency.getAverageLatency();
        int commitsInProgress = this.getStatistic("commitsInProgress").intValue();
        int documents = this.getStatistic("documents").intValue();
        return new LuceneIndexMetrics(index.getRegionPath(), index.getName(), queryExecutions, queryExecutionTime, queryRateValue, queryRateAverageLatencyValue, queryExecutionsInProgress, queryExecutionTotalHits, updates, updateTime, updateRateValue, updateRateAverageLatencyValue, updatesInProgress, commits, commitTime, commitRateValue, commitRateAverageLatencyValue, commitsInProgress, documents);
    }
}

