/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneEventListener;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.xml.LuceneIndexCreation;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public abstract class LuceneIndexImpl
implements InternalLuceneIndex {
    protected static final Logger logger = LogService.getLogger();
    protected final String indexName;
    protected final String regionPath;
    protected final Cache cache;
    protected final LuceneIndexStats indexStats;
    protected boolean hasInitialized = false;
    protected Map<String, Analyzer> fieldAnalyzers;
    protected String[] searchableFieldNames;
    protected RepositoryManager repositoryManager;
    protected Analyzer analyzer;
    protected LocalRegion dataRegion;

    protected LuceneIndexImpl(String indexName, String regionPath, Cache cache) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.cache = cache;
        String statsName = indexName + "-" + regionPath;
        this.indexStats = new LuceneIndexStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    protected LocalRegion getDataRegion() {
        return (LocalRegion)this.cache.getRegion(this.regionPath);
    }

    protected boolean withPersistence() {
        RegionAttributes ra = this.dataRegion.getAttributes();
        DataPolicy dp = ra.getDataPolicy();
        boolean withPersistence = dp.withPersistence();
        return withPersistence;
    }

    protected void setSearchableFields(String[] fields) {
        this.searchableFieldNames = fields;
    }

    @Override
    public boolean waitUntilFlushed(int maxWaitInMillisecond) {
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
        AsyncEventQueue queue = this.cache.getAsyncEventQueue(aeqId);
        boolean flushed = false;
        if (queue != null) {
            long start = System.nanoTime();
            while (System.nanoTime() - start < TimeUnit.MILLISECONDS.toNanos(maxWaitInMillisecond)) {
                if (0 == queue.size()) {
                    flushed = true;
                    break;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            throw new IllegalArgumentException("The AEQ does not exist for the index " + this.indexName + " region " + this.regionPath);
        }
        return flushed;
    }

    @Override
    public String[] getFieldNames() {
        return this.searchableFieldNames;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer == null ? new StandardAnalyzer() : analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers == null ? null : Collections.unmodifiableMap(fieldAnalyzers);
    }

    public LuceneIndexStats getIndexStats() {
        return this.indexStats;
    }

    protected void initialize() {
        if (!this.hasInitialized) {
            this.dataRegion = this.getDataRegion();
            this.repositoryManager = this.createRepositoryManager();
            this.createAEQ((Region)this.dataRegion);
            this.addExtension(this.dataRegion);
            this.hasInitialized = true;
        }
    }

    protected abstract RepositoryManager createRepositoryManager();

    protected AsyncEventQueue createAEQ(Region dataRegion) {
        return this.createAEQ(this.createAEQFactory(dataRegion));
    }

    private AsyncEventQueueFactoryImpl createAEQFactory(Region dataRegion) {
        AsyncEventQueueFactoryImpl factory = (AsyncEventQueueFactoryImpl)this.cache.createAsyncEventQueueFactory();
        if (dataRegion instanceof PartitionedRegion) {
            factory.setParallel(true);
        } else {
            factory.setParallel(false);
        }
        factory.setMaximumQueueMemory(1000);
        factory.setDispatcherThreads(10);
        factory.setIsMetaQueue(true);
        if (dataRegion.getAttributes().getDataPolicy().withPersistence()) {
            factory.setPersistent(true);
        }
        factory.setDiskStoreName(dataRegion.getAttributes().getDiskStoreName());
        factory.setDiskSynchronous(dataRegion.getAttributes().isDiskSynchronous());
        factory.setForwardExpirationDestroy(true);
        return factory;
    }

    private AsyncEventQueue createAEQ(AsyncEventQueueFactoryImpl factory) {
        LuceneEventListener listener = new LuceneEventListener(this.repositoryManager);
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.getName(), this.regionPath);
        AsyncEventQueue indexQueue = factory.create(aeqId, (AsyncEventListener)listener);
        return indexQueue;
    }

    protected void addExtension(LocalRegion dataRegion) {
        LuceneIndexCreation creation = new LuceneIndexCreation();
        creation.setName(this.getName());
        creation.addFieldNames(this.getFieldNames());
        creation.setRegion((Region)dataRegion);
        creation.setFieldAnalyzers(this.getFieldAnalyzers());
        dataRegion.getExtensionPoint().addExtension((Extension)creation);
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionAttributes<K, V> attributes) {
        InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true);
        try {
            return ((GemFireCacheImpl)this.cache).createVMRegion(regionName, attributes, ira);
        }
        catch (Exception e) {
            InternalGemFireError ige = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            ige.initCause((Throwable)e);
            throw ige;
        }
    }
}

