/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.repository.serializer.LuceneSerializer;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;

public abstract class AbstractPartitionedRepositoryManager
implements RepositoryManager {
    protected final ConcurrentHashMap<Integer, IndexRepository> indexRepositories = new ConcurrentHashMap();
    protected final PartitionedRegion userRegion;
    protected final LuceneSerializer serializer;
    protected final LuceneIndexImpl index;

    public AbstractPartitionedRepositoryManager(LuceneIndexImpl index, LuceneSerializer serializer) {
        this.index = index;
        this.userRegion = (PartitionedRegion)index.getCache().getRegion(index.getRegionPath());
        this.serializer = serializer;
    }

    @Override
    public IndexRepository getRepository(Region region, Object key, Object callbackArg) throws BucketNotFoundException {
        BucketRegion userBucket = this.userRegion.getBucketRegion(key, callbackArg);
        if (userBucket == null) {
            throw new BucketNotFoundException("User bucket was not found for region " + region + "key " + key + " callbackarg " + callbackArg);
        }
        return this.getRepository(userBucket.getId());
    }

    @Override
    public Collection<IndexRepository> getRepositories(RegionFunctionContext ctx) throws BucketNotFoundException {
        Region region = ctx.getDataSet();
        Set buckets = ((InternalRegionFunctionContext)ctx).getLocalBucketSet(region);
        ArrayList<IndexRepository> repos = new ArrayList<IndexRepository>(buckets.size());
        for (Integer bucketId : buckets) {
            BucketRegion userBucket = this.userRegion.getDataStore().getLocalBucketById(bucketId);
            if (userBucket == null) {
                throw new BucketNotFoundException("User bucket was not found for region " + region + "bucket id " + bucketId);
            }
            repos.add(this.getRepository(userBucket.getId()));
        }
        return repos;
    }

    public abstract IndexRepository createOneIndexRepository(Integer var1, LuceneSerializer var2, LuceneIndexImpl var3, PartitionedRegion var4) throws IOException;

    protected IndexRepository getRepository(Integer bucketId) throws BucketNotFoundException {
        IndexRepository repo = this.indexRepositories.get(bucketId);
        if (repo != null && !repo.isClosed()) {
            return repo;
        }
        repo = this.indexRepositories.compute(bucketId, (key, oldRepository) -> {
            if (oldRepository != null && !oldRepository.isClosed()) {
                return oldRepository;
            }
            if (oldRepository != null) {
                oldRepository.cleanup();
            }
            try {
                return this.createOneIndexRepository(bucketId, this.serializer, this.index, this.userRegion);
            }
            catch (IOException e) {
                throw new InternalGemFireError("Unable to create index repository", (Throwable)e);
            }
        });
        if (repo == null) {
            throw new BucketNotFoundException("Colocated index buckets not found for bucket id " + bucketId);
        }
        return repo;
    }
}

