/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.repository.serializer;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;

public class SerializerUtil {
    private static final String KEY_FIELD = "_KEY";
    private static ThreadLocal<ByteArrayOutputStream> LOCAL_BUFFER = new ThreadLocal<ByteArrayOutputStream>(){

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream();
        }
    };

    private SerializerUtil() {
    }

    public static void addKey(Object key, Document doc) {
        if (key instanceof String) {
            doc.add((IndexableField)new StringField(KEY_FIELD, (String)key, Field.Store.YES));
        } else {
            doc.add((IndexableField)new StringField(KEY_FIELD, SerializerUtil.keyToBytes(key), Field.Store.YES));
        }
    }

    public static boolean addField(Document doc, String field, Object fieldValue) {
        Class<?> clazz = fieldValue.getClass();
        if (clazz == String.class) {
            doc.add((IndexableField)new TextField(field, (String)fieldValue, Field.Store.NO));
        } else if (clazz == Long.class) {
            doc.add((IndexableField)new LongField(field, ((Long)fieldValue).longValue(), Field.Store.NO));
        } else if (clazz == Integer.class) {
            doc.add((IndexableField)new IntField(field, ((Integer)fieldValue).intValue(), Field.Store.NO));
        } else if (clazz == Float.class) {
            doc.add((IndexableField)new FloatField(field, ((Float)fieldValue).floatValue(), Field.Store.NO));
        } else if (clazz == Double.class) {
            doc.add((IndexableField)new DoubleField(field, ((Double)fieldValue).doubleValue(), Field.Store.NO));
        } else {
            return false;
        }
        return true;
    }

    public static boolean isSupported(Class<?> type) {
        return type == String.class || type == Long.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Double.TYPE || type == Long.class || type == Integer.class || type == Float.class || type == Double.class;
    }

    public static Object getKey(Document doc) {
        IndexableField field = doc.getField(KEY_FIELD);
        if (field.stringValue() != null) {
            return field.stringValue();
        }
        return SerializerUtil.keyFromBytes(field.binaryValue());
    }

    public static Term getKeyTerm(Document doc) {
        IndexableField field = doc.getField(KEY_FIELD);
        if (field.stringValue() != null) {
            return new Term(KEY_FIELD, field.stringValue());
        }
        return new Term(KEY_FIELD, field.binaryValue());
    }

    public static Term toKeyTerm(Object key) {
        if (key instanceof String) {
            return new Term(KEY_FIELD, (String)key);
        }
        return new Term(KEY_FIELD, SerializerUtil.keyToBytes(key));
    }

    private static Object keyFromBytes(BytesRef bytes) {
        try {
            return BlobHelper.deserializeBlob((byte[])bytes.bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalGemFireError((Throwable)e);
        }
    }

    private static BytesRef keyToBytes(Object key) {
        ByteArrayOutputStream buffer = LOCAL_BUFFER.get();
        try {
            DataOutputStream out = new DataOutputStream(buffer);
            DataSerializer.writeObject((Object)key, (DataOutput)out);
            out.flush();
            BytesRef result = new BytesRef(buffer.toByteArray());
            buffer.reset();
            return result;
        }
        catch (IOException e) {
            throw new InternalGemFireError("Unable to serialize key", (Throwable)e);
        }
    }
}

