/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.repository;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepository;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexResultCollector;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.SerializerUtil;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;

public class IndexRepositoryImpl
implements IndexRepository {
    private static final boolean APPLY_ALL_DELETES = System.getProperty("gemfire.IndexRepository.APPLY_ALL_DELETES", "true").equalsIgnoreCase("true");
    private final IndexWriter writer;
    private final LuceneSerializer serializer;
    private final SearcherManager searcherManager;
    private Region<?, ?> region;

    public IndexRepositoryImpl(Region<?, ?> region, IndexWriter writer, LuceneSerializer serializer) throws IOException {
        this.region = region;
        this.writer = writer;
        this.searcherManager = new SearcherManager(writer, APPLY_ALL_DELETES, null);
        this.serializer = serializer;
    }

    @Override
    public void create(Object key, Object value) throws IOException {
        Document doc = new Document();
        SerializerUtil.addKey(key, doc);
        this.serializer.toDocument(value, doc);
        this.writer.addDocument((Iterable)doc);
    }

    @Override
    public void update(Object key, Object value) throws IOException {
        Document doc = new Document();
        SerializerUtil.addKey(key, doc);
        this.serializer.toDocument(value, doc);
        this.writer.updateDocument(SerializerUtil.getKeyTerm(doc), (Iterable)doc);
    }

    @Override
    public void delete(Object key) throws IOException {
        Term keyTerm = SerializerUtil.toKeyTerm(key);
        this.writer.deleteDocuments(new Term[]{keyTerm});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Query query, int limit, IndexResultCollector collector) throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs docs = searcher.search(query, limit);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                Document doc = searcher.doc(scoreDoc.doc);
                Object key = SerializerUtil.getKey(doc);
                collector.collect(key, scoreDoc.score);
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    @Override
    public synchronized void commit() throws IOException {
        this.writer.commit();
        this.searcherManager.maybeRefresh();
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public LuceneSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isClosed() {
        return this.region.isDestroyed();
    }
}

