/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.filesystem;

import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public class FileSystem {
    private final ConcurrentMap<String, File> fileRegion;
    private final ConcurrentMap<ChunkKey, byte[]> chunkRegion;
    static final int CHUNK_SIZE = 0x100000;

    public FileSystem(ConcurrentMap<String, File> fileRegion, ConcurrentMap<ChunkKey, byte[]> chunkRegion) {
        this.fileRegion = fileRegion;
        this.chunkRegion = chunkRegion;
    }

    public Collection<String> listFileNames() {
        return this.fileRegion.keySet();
    }

    public File createFile(String name) throws IOException {
        File file = new File(this, name);
        if (null != this.fileRegion.putIfAbsent(name, file)) {
            throw new IOException("File exists.");
        }
        return file;
    }

    public File getFile(String name) throws FileNotFoundException {
        File file = (File)this.fileRegion.get(name);
        if (null == file) {
            throw new FileNotFoundException(name);
        }
        file.setFileSystem(this);
        return file;
    }

    public void deleteFile(String name) throws FileNotFoundException {
        File file = (File)this.fileRegion.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        ChunkKey key = new ChunkKey(file.id, 0);
        while (null != this.chunkRegion.remove(key)) {
            ++key.chunkId;
        }
    }

    public void renameFile(String source, String dest) throws IOException {
        File sourceFile = (File)this.fileRegion.get(source);
        if (null == sourceFile) {
            throw new FileNotFoundException(source);
        }
        File destFile = this.createFile(dest);
        destFile.chunks = sourceFile.chunks;
        destFile.created = sourceFile.created;
        destFile.length = sourceFile.length;
        destFile.modified = sourceFile.modified;
        destFile.id = sourceFile.id;
        this.updateFile(destFile);
        this.fileRegion.remove(source);
    }

    byte[] getChunk(File file, int id) {
        ChunkKey key = new ChunkKey(file.id, id);
        if (id >= file.chunks) {
            while (this.chunkRegion.containsKey(key)) {
                this.chunkRegion.remove(key);
                ++key.chunkId;
            }
            return null;
        }
        byte[] chunk = (byte[])this.chunkRegion.get(key);
        return chunk;
    }

    public void putChunk(File file, int id, byte[] chunk) {
        ChunkKey key = new ChunkKey(file.id, id);
        this.chunkRegion.put(key, chunk);
    }

    void updateFile(File file) {
        this.fileRegion.put(file.getName(), file);
    }

    public ConcurrentMap<String, File> getFileRegion() {
        return this.fileRegion;
    }

    public ConcurrentMap<ChunkKey, byte[]> getChunkRegion() {
        return this.chunkRegion;
    }
}

