/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.filesystem;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileInputStream;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileOutputStream;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileSystem;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.SeekableInputStream;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class File
implements DataSerializableFixedID {
    private transient FileSystem fileSystem;
    private transient int chunkSize;
    private String name;
    long length = 0L;
    int chunks = 0;
    long created;
    long modified = this.created = System.currentTimeMillis();
    UUID id = UUID.randomUUID();

    public File() {
    }

    File(FileSystem fileSystem, String name) {
        this.setFileSystem(fileSystem);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getLength() {
        return this.length;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public SeekableInputStream getInputStream() {
        return new FileInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new FileOutputStream(this);
    }

    void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.chunkSize = 0x100000;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2170;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.name, (DataOutput)out);
        out.writeLong(this.length);
        out.writeInt(this.chunks);
        out.writeLong(this.created);
        out.writeLong(this.modified);
        out.writeLong(this.id.getMostSignificantBits());
        out.writeLong(this.id.getLeastSignificantBits());
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString((DataInput)in);
        this.length = in.readLong();
        this.chunks = in.readInt();
        this.created = in.readLong();
        this.modified = in.readLong();
        long high = in.readLong();
        long low = in.readLong();
        this.id = new UUID(high, low);
    }
}

