/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.distributed;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.lucene.LuceneService;
import com.gemstone.gemfire.cache.lucene.LuceneServiceProvider;
import com.gemstone.gemfire.cache.lucene.internal.InternalLuceneIndex;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollector;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepository;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexResultCollector;
import com.gemstone.gemfire.cache.lucene.internal.repository.RepositoryManager;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.BucketNotFoundException;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;

public class LuceneFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;
    public static final String ID = LuceneFunction.class.getName();
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext context) {
        TopEntriesCollectorManager manager;
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        ResultSender resultSender = ctx.getResultSender();
        Region region = ctx.getDataSet();
        LuceneFunctionContext searchContext = (LuceneFunctionContext)ctx.getArguments();
        if (searchContext == null) {
            resultSender.sendException((Throwable)new IllegalArgumentException("Missing search context"));
            return;
        }
        LuceneQueryProvider queryProvider = searchContext.getQueryProvider();
        if (queryProvider == null) {
            resultSender.sendException((Throwable)new IllegalArgumentException("Missing query provider"));
            return;
        }
        LuceneService service = LuceneServiceProvider.get(region.getCache());
        InternalLuceneIndex index = (InternalLuceneIndex)service.getIndex(searchContext.getIndexName(), region.getFullPath());
        RepositoryManager repoManager = index.getRepositoryManager();
        Query query = null;
        try {
            query = queryProvider.getQuery(index);
        }
        catch (QueryException e) {
            resultSender.sendException((Throwable)e);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing lucene query: {}, on region {}", new Object[]{query, region.getFullPath()});
        }
        int resultLimit = searchContext.getLimit();
        TopEntriesCollectorManager topEntriesCollectorManager = manager = searchContext == null ? null : searchContext.getCollectorManager();
        if (manager == null) {
            manager = new TopEntriesCollectorManager(null, resultLimit);
        }
        ArrayList results = new ArrayList();
        try {
            Collection<IndexRepository> repositories = repoManager.getRepositories(ctx);
            for (IndexRepository repo : repositories) {
                Object collector = manager.newCollector(repo.toString());
                logger.debug("Executing search on repo: " + repo.toString());
                repo.query(query, resultLimit, (IndexResultCollector)collector);
                results.add(collector);
            }
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            resultSender.sendException((Throwable)e);
            return;
        }
        catch (BucketNotFoundException e) {
            logger.warn("", (Throwable)e);
            resultSender.sendException((Throwable)e);
            return;
        }
        try {
            TopEntriesCollector mergedResult = (TopEntriesCollector)manager.reduce(results);
            resultSender.lastResult((Object)mergedResult);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            resultSender.sendException((Throwable)e);
            return;
        }
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }
}

