/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.LuceneQueryResults;
import com.gemstone.gemfire.cache.lucene.LuceneResultStruct;
import com.gemstone.gemfire.cache.lucene.internal.LuceneResultStructImpl;
import com.gemstone.gemfire.cache.lucene.internal.distributed.EntryScore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LuceneQueryResultsImpl<K, V>
implements LuceneQueryResults<K, V> {
    private final List<EntryScore> hits;
    private float maxScore = Float.MIN_VALUE;
    private final Region<K, V> userRegion;
    private int currentHit = 0;
    private int pageSize;

    public LuceneQueryResultsImpl(List<EntryScore> hits, Region<K, V> userRegion, int pageSize) {
        this.hits = hits;
        this.userRegion = userRegion;
        this.pageSize = pageSize == 0 ? Integer.MAX_VALUE : pageSize;
    }

    @Override
    public List<LuceneResultStruct<K, V>> getNextPage() {
        if (!this.hasNextPage()) {
            return null;
        }
        int end = this.currentHit + this.pageSize;
        end = end > this.hits.size() ? this.hits.size() : end;
        List<EntryScore> scores = this.hits.subList(this.currentHit, end);
        ArrayList<Object> keys = new ArrayList<Object>(this.hits.size());
        for (EntryScore score : scores) {
            keys.add(score.getKey());
        }
        Map values = this.userRegion.getAll(keys);
        ArrayList<LuceneResultStruct<K, V>> results = new ArrayList<LuceneResultStruct<K, V>>(this.hits.size());
        for (EntryScore score : scores) {
            Object value = values.get(score.getKey());
            results.add(new LuceneResultStructImpl(score.getKey(), value, score.getScore()));
        }
        this.currentHit = end;
        return results;
    }

    @Override
    public boolean hasNextPage() {
        return this.hits.size() > this.currentHit;
    }

    @Override
    public int size() {
        return this.hits.size();
    }

    @Override
    public float getMaxScore() {
        if (this.maxScore == Float.MIN_VALUE) {
            for (EntryScore score : this.hits) {
                this.maxScore = Math.max(this.maxScore, score.getScore());
            }
        }
        return this.maxScore;
    }
}

