/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.lucene.internal.LuceneEventListener;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexImpl;
import com.gemstone.gemfire.cache.lucene.internal.LuceneServiceImpl;
import com.gemstone.gemfire.cache.lucene.internal.PartitionedRepositoryManager;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.HeterogenousLuceneSerializer;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;

public class LuceneIndexForPartitionedRegion
extends LuceneIndexImpl {
    private final Cache cache;

    public LuceneIndexForPartitionedRegion(String indexName, String regionPath, Cache cache) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.cache = cache;
    }

    @Override
    public void initialize() {
        if (!this.hasInitialized) {
            boolean withStorage;
            PartitionedRegion dataRegion = (PartitionedRegion)this.cache.getRegion(this.regionPath);
            assert (dataRegion != null);
            RegionAttributes ra = dataRegion.getAttributes();
            DataPolicy dp = ra.getDataPolicy();
            boolean isPartitionedRegion = ra.getPartitionAttributes() != null;
            boolean withPersistence = dp.withPersistence();
            boolean bl = isPartitionedRegion ? ra.getPartitionAttributes().getLocalMaxMemory() > 0 : (withStorage = dp.withStorage());
            RegionShortcut regionShortCut = isPartitionedRegion ? (withPersistence ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION) : (withPersistence ? RegionShortcut.REPLICATE_PERSISTENT : RegionShortcut.REPLICATE);
            if (!withStorage) {
                throw new IllegalStateException("The data region to create lucene index should be with storage");
            }
            String fileRegionName = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath) + ".files";
            this.fileRegion = this.cache.getRegion(fileRegionName);
            PartitionAttributes partitionAttributes = dataRegion.getPartitionAttributes();
            if (null == this.fileRegion) {
                this.fileRegion = this.cache.createRegionFactory(regionShortCut).setPartitionAttributes(new PartitionAttributesFactory().setColocatedWith(this.regionPath).setTotalNumBuckets(partitionAttributes.getTotalNumBuckets()).create()).create(fileRegionName);
            }
            String chunkRegionName = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath) + ".chunks";
            this.chunkRegion = this.cache.getRegion(chunkRegionName);
            if (null == this.chunkRegion) {
                this.chunkRegion = this.cache.createRegionFactory(regionShortCut).setPartitionAttributes(new PartitionAttributesFactory().setColocatedWith(fileRegionName).setTotalNumBuckets(partitionAttributes.getTotalNumBuckets()).create()).create(chunkRegionName);
            }
            HeterogenousLuceneSerializer mapper = new HeterogenousLuceneSerializer(this.getFieldNames());
            this.repositoryManager = new PartitionedRepositoryManager(dataRegion, (PartitionedRegion)this.fileRegion, (PartitionedRegion)this.chunkRegion, mapper, this.analyzer);
            AsyncEventQueueFactoryImpl factory = (AsyncEventQueueFactoryImpl)this.cache.createAsyncEventQueueFactory();
            if (withPersistence) {
                factory.setPersistent(true);
            }
            factory.setParallel(true);
            factory.setMaximumQueueMemory(1000);
            factory.setDispatcherThreads(1);
            factory.setIsMetaQueue(true);
            LuceneEventListener listener = new LuceneEventListener(this.repositoryManager);
            String aeqId = LuceneServiceImpl.getUniqueIndexName(this.getName(), this.regionPath);
            AsyncEventQueueImpl aeq = (AsyncEventQueueImpl)this.cache.getAsyncEventQueue(aeqId);
            AsyncEventQueue indexQueue = factory.create(aeqId, (AsyncEventListener)listener);
            this.addExtension(dataRegion);
            this.hasInitialized = true;
        }
    }

    public void close() {
    }
}

