/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.EnumSet;
import java.util.Set;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;

public class UseJacksonForJsonPathRule
extends SerializableExternalResource {
    private boolean hadDefaults;
    private JsonProvider jsonProvider;
    private MappingProvider mappingProvider;
    private Set<Option> options;

    public void before() {
        this.saveDefaults();
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public void after() {
        this.restoreDefaults();
    }

    private void saveDefaults() {
        try {
            Configuration defaultConfiguration = Configuration.defaultConfiguration();
            this.jsonProvider = defaultConfiguration.jsonProvider();
            this.mappingProvider = defaultConfiguration.mappingProvider();
            this.options = defaultConfiguration.getOptions();
            this.hadDefaults = true;
        }
        catch (NoClassDefFoundError ignore) {
            this.hadDefaults = false;
        }
    }

    private void restoreDefaults() {
        if (!this.hadDefaults) {
            return;
        }
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){

            public JsonProvider jsonProvider() {
                return UseJacksonForJsonPathRule.this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return UseJacksonForJsonPathRule.this.mappingProvider;
            }

            public Set<Option> options() {
                return UseJacksonForJsonPathRule.this.options;
            }
        });
    }
}

