/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.compiler;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.geode.test.compiler.CompiledSourceCode;
import org.apache.geode.test.compiler.UncompiledSourceCode;

public class JavaCompiler {
    private File tempDir = Files.createTempDir();
    private String classpath;

    public JavaCompiler() {
        this.tempDir.deleteOnExit();
        this.classpath = System.getProperty("java.class.path");
    }

    public void addToClasspath(File jarFile) {
        this.classpath = this.classpath + File.pathSeparator + jarFile.getAbsolutePath();
    }

    public List<CompiledSourceCode> compile(File ... sourceFiles) throws IOException {
        String[] sourceFileContents = (String[])Arrays.stream(sourceFiles).map(this::readFileToString).toArray(String[]::new);
        return this.compile(sourceFileContents);
    }

    public List<CompiledSourceCode> compile(String ... sourceFileContents) throws IOException {
        UncompiledSourceCode[] uncompiledSourceCodes = (UncompiledSourceCode[])Arrays.stream(sourceFileContents).map(UncompiledSourceCode::fromSourceCode).toArray(UncompiledSourceCode[]::new);
        return this.compile(uncompiledSourceCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompiledSourceCode> compile(UncompiledSourceCode ... uncompiledSources) throws IOException {
        File temporarySourcesDirectory = this.createSubdirectory(this.tempDir, "sources");
        File temporaryClassesDirectory = this.createSubdirectory(this.tempDir, "classes");
        List<String> options = Stream.of("-d", temporaryClassesDirectory.getAbsolutePath(), "-classpath", this.classpath).collect(Collectors.toList());
        try {
            for (UncompiledSourceCode sourceCode : uncompiledSources) {
                File sourceFile = new File(temporarySourcesDirectory, sourceCode.simpleClassName + ".java");
                FileUtils.writeStringToFile((File)sourceFile, (String)sourceCode.sourceCode, (Charset)Charsets.UTF_8);
                options.add(sourceFile.getAbsolutePath());
            }
            int exitCode = ToolProvider.getSystemJavaCompiler().run(System.in, System.out, System.err, options.toArray(new String[0]));
            if (exitCode != 0) {
                throw new RuntimeException("Unable to compile the given source code. See System.err for details.");
            }
            ArrayList<CompiledSourceCode> compiledSourceCodes = new ArrayList<CompiledSourceCode>();
            JavaCompiler.addCompiledClasses(compiledSourceCodes, "", temporaryClassesDirectory);
            ArrayList<CompiledSourceCode> arrayList = compiledSourceCodes;
            return arrayList;
        }
        finally {
            FileUtils.deleteDirectory((File)temporaryClassesDirectory);
        }
    }

    private static void addCompiledClasses(List<CompiledSourceCode> ret, String pkgName, File dir) throws IOException {
        for (File file : dir.listFiles()) {
            String qname;
            String filename = file.getName();
            if (file.isDirectory()) {
                qname = pkgName + filename + ".";
                JavaCompiler.addCompiledClasses(ret, qname, file);
                continue;
            }
            if (filename.endsWith(".class")) {
                qname = pkgName + filename.substring(0, filename.length() - 6);
                ret.add(new CompiledSourceCode(qname, FileUtils.readFileToByteArray((File)file)));
                continue;
            }
            System.err.println("Unexpected file : " + file.getAbsolutePath());
        }
    }

    private File createSubdirectory(File parent, String directoryName) {
        File subdirectory = parent.toPath().resolve(directoryName).toFile();
        if (!subdirectory.exists()) {
            subdirectory.mkdirs();
        }
        if (!subdirectory.exists() || !subdirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory" + subdirectory.getAbsolutePath());
        }
        return subdirectory;
    }

    private String readFileToString(File file) {
        try {
            return FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

