/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.test.junit.rules.serializable;

import com.gemstone.gemfire.test.junit.rules.serializable.FieldSerializationUtils;
import com.gemstone.gemfire.test.junit.rules.serializable.SerializableTestRule;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.junit.rules.TestName;
import org.junit.runner.Description;

public class SerializableTestName
extends TestName
implements SerializableTestRule {
    protected void starting(Description description) {
        super.starting(description);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("SerializationProxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private final String name;

        SerializationProxy(SerializableTestName instance) {
            this.name = (String)FieldSerializationUtils.readField(TestName.class, instance, "name");
        }

        private Object readResolve() {
            SerializableTestName instance = new SerializableTestName();
            FieldSerializationUtils.writeField(TestName.class, instance, "name", this.name);
            return instance;
        }
    }
}

