/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell.unsafe;

import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.apache.geode.internal.process.signal.AbstractSignalNotificationHandler;
import org.apache.geode.internal.process.signal.Signal;
import org.apache.geode.internal.process.signal.SignalEvent;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.unsafe.internal.sun.misc.SignalHandler;
import org.jline.reader.LineReader;

public class GfshSignalHandler
extends AbstractSignalNotificationHandler
implements SignalHandler {
    private final Map<Signal, SignalHandler> originalSignalHandlers = Collections.synchronizedMap(new Hashtable(Signal.values().length));

    public GfshSignalHandler() {
        for (Signal signal : Signal.values()) {
            if (!Signal.SIGINT.equals((Object)signal)) continue;
            this.originalSignalHandlers.put(signal, org.apache.geode.unsafe.internal.sun.misc.Signal.handle((org.apache.geode.unsafe.internal.sun.misc.Signal)new org.apache.geode.unsafe.internal.sun.misc.Signal(signal.getName()), (SignalHandler)this));
        }
    }

    public void handle(org.apache.geode.unsafe.internal.sun.misc.Signal sig) {
        this.notifyListeners(new SignalEvent((Object)sig, Signal.valueOfName((String)sig.getName())));
        try {
            this.handleDefault(sig, Gfsh.getConsoleReader());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleDefault(org.apache.geode.unsafe.internal.sun.misc.Signal sig, LineReader lineReader) throws IOException {
        Signal signal = Signal.valueOfName((String)sig.getName());
        switch (signal) {
            case SIGINT: {
                if (lineReader == null) break;
                lineReader.getTerminal().writer().println();
                break;
            }
            default: {
                SignalHandler handler = this.getOriginalSignalHandler(signal);
                if (handler == null) break;
                handler.handle(sig);
            }
        }
    }

    private SignalHandler getOriginalSignalHandler(Signal signal) {
        SignalHandler handler = this.originalSignalHandlers.get(signal);
        return handler == SignalHandler.SIG_DFL || handler == SignalHandler.SIG_IGN ? null : handler;
    }
}

