/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell.jline;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.jline.reader.LineReader;
import org.jline.reader.impl.history.DefaultHistory;

public class GfshHistory
extends DefaultHistory {
    private boolean autoFlush = true;
    private Path historyFilePath = null;

    public void setHistoryFilePath(Path path) {
        block9: {
            this.historyFilePath = path;
            if (this.historyFilePath != null) {
                try {
                    Files.createDirectories(this.historyFilePath.getParent(), new FileAttribute[0]);
                    if (Files.exists(this.historyFilePath, new LinkOption[0]) && Files.size(this.historyFilePath) != 0L) break block9;
                    try (BufferedWriter writer = Files.newBufferedWriter(this.historyFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                        writer.write("# " + String.valueOf(new Date()));
                        writer.newLine();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void attach(LineReader reader) {
        try {
            super.attach(reader);
        }
        catch (Exception e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof IllegalArgumentException) || cause.getMessage() == null || !cause.getMessage().contains("Bad history file syntax")) continue;
                this.migrateOldHistoryFile();
                try {
                    super.attach(reader);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void migrateOldHistoryFile() {
        if (this.historyFilePath == null || !Files.exists(this.historyFilePath, new LinkOption[0])) {
            return;
        }
        try {
            Path backupPath = this.historyFilePath.getParent().resolve(this.historyFilePath.getFileName().toString() + ".old");
            Files.move(this.historyFilePath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            try (BufferedWriter writer = Files.newBufferedWriter(this.historyFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                writer.write("# Migrated from old format on " + String.valueOf(new Date()));
                writer.newLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addToHistory(String buffer) {
        if (this.isAutoFlush()) {
            String redacted = ArgumentRedactor.redact((String)buffer.trim());
            super.add(redacted);
            if (this.historyFilePath != null) {
                try {
                    Files.createDirectories(this.historyFilePath.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(this.historyFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                        writer.write(redacted);
                        writer.newLine();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }
}

