/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;

class ScriptExecutionDetails {
    private final String filePath;
    private final List<CommandAndStatus> commandAndStatusList;

    ScriptExecutionDetails(String filePath) {
        this.filePath = filePath;
        this.commandAndStatusList = new ArrayList<CommandAndStatus>();
    }

    void addCommandAndStatus(String command, String status) {
        this.commandAndStatusList.add(new CommandAndStatus(command, status));
    }

    ResultModel getResult() {
        ResultModel result = new ResultModel();
        result.setHeader("************************* Execution Summary ***********************\nScript file: " + this.filePath);
        for (int i = 0; i < this.commandAndStatusList.size(); ++i) {
            int commandSrNo = i + 1;
            DataResultModel commandDetail = result.addData("command" + commandSrNo);
            CommandAndStatus commandAndStatus = this.commandAndStatusList.get(i);
            commandDetail.addData("Command-" + commandSrNo, commandAndStatus.command);
            commandDetail.addData("Status", commandAndStatus.status);
            if (commandAndStatus.status.equals("FAILED")) {
                result.setStatus(Result.Status.ERROR);
            }
            if (i == this.commandAndStatusList.size()) continue;
            result.setFooter(Gfsh.LINE_SEPARATOR);
        }
        return result;
    }

    void logScriptExecutionInfo(LogWrapper logWrapper, ResultModel result) {
        logWrapper.info(new CommandResult(result).asString());
    }

    static class CommandAndStatus {
        private final String command;
        private final String status;

        public CommandAndStatus(String command, String status) {
            this.command = command;
            this.status = status;
        }

        public String toString() {
            return this.command + "     " + this.status;
        }
    }
}

