/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.internal.SystemDescription;
import org.apache.geode.internal.lang.utils.ClassUtils;
import org.apache.geode.internal.logging.Banner;
import org.apache.geode.internal.process.signal.AbstractSignalNotificationHandler;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.HostName;
import org.apache.geode.internal.util.ProductVersionUtil;
import org.apache.geode.internal.util.SunAPINotFoundException;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtils;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.ExitShellRequest;
import org.apache.geode.management.internal.cli.shell.GfshCompleter;
import org.apache.geode.management.internal.cli.shell.GfshConfig;
import org.apache.geode.management.internal.cli.shell.GfshExecutionStrategy;
import org.apache.geode.management.internal.cli.shell.MultiCommandHelper;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.cli.shell.ScriptExecutionDetails;
import org.apache.geode.management.internal.cli.shell.jline.ANSIHandler;
import org.apache.geode.management.internal.cli.shell.jline.GfshHistory;
import org.apache.geode.management.internal.cli.shell.jline.GfshUnsupportedTerminal;
import org.apache.geode.management.internal.cli.shell.unsafe.GfshSignalHandler;
import org.apache.geode.management.internal.cli.util.CommentSkipHelper;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Gfsh
implements Runnable {
    public static final int DEFAULT_APP_FETCH_SIZE = 100;
    public static final int DEFAULT_APP_LAST_EXIT_STATUS = 0;
    public static final int DEFAULT_APP_COLLECTION_LIMIT = 20;
    public static final boolean DEFAULT_APP_QUIET_EXECUTION = false;
    public static final String DEFAULT_APP_QUERY_RESULTS_DISPLAY_MODE = "table";
    public static final String DEFAULT_APP_RESULT_VIEWER = "basic";
    public static final String EXTERNAL_RESULT_VIEWER = "external";
    public static final String GFSH_APP_NAME = "gfsh";
    public static final String LINE_INDENT = "    ";
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final int DEFAULT_WIDTH = 100;
    public static final String ENV_APP_NAME = "APP_NAME";
    public static final String ENV_APP_CONTEXT_PATH = "APP_CONTEXT_PATH";
    public static final String ENV_APP_FETCH_SIZE = "APP_FETCH_SIZE";
    public static final String ENV_APP_LAST_EXIT_STATUS = "APP_LAST_EXIT_STATUS";
    public static final String ENV_APP_COLLECTION_LIMIT = "APP_COLLECTION_LIMIT";
    public static final String ENV_APP_QUERY_RESULTS_DISPLAY_MODE = "APP_QUERY_RESULTS_DISPLAY_MODE";
    public static final String ENV_APP_QUIET_EXECUTION = "APP_QUIET_EXECUTION";
    public static final String ENV_APP_LOGGING_ENABLED = "APP_LOGGING_ENABLED";
    public static final String ENV_APP_LOG_FILE = "APP_LOG_FILE";
    public static final String ENV_APP_PWD = "APP_PWD";
    public static final String ENV_APP_RESULT_VIEWER = "APP_RESULT_VIEWER";
    public static final String ENV_SYS_USER = "SYS_USER";
    public static final String ENV_SYS_USER_HOME = "SYS_USER_HOME";
    public static final String ENV_SYS_HOST_NAME = "SYS_HOST_NAME";
    public static final String ENV_SYS_CLASSPATH = "SYS_CLASSPATH";
    public static final String ENV_SYS_JAVA_VERSION = "SYS_JAVA_VERSION";
    public static final String ENV_SYS_OS = "SYS_OS";
    public static final String ENV_SYS_OS_LINE_SEPARATOR = "SYS_OS_LINE_SEPARATOR";
    public static final String ENV_SYS_GEODE_HOME_DIR = "SYS_GEODE_HOME_DIR";
    private static final String DEFAULT_SECONDARY_PROMPT = ">";
    private static final int DEFAULT_HEIGHT = 100;
    private static final Object INSTANCE_LOCK = new Object();
    @MutableForTesting
    protected static PrintStream gfshout = System.out;
    @MutableForTesting
    protected static PrintStream gfsherr = System.err;
    protected static final ThreadLocal<Gfsh> gfshThreadLocal = new ThreadLocal();
    @MakeNotStatic
    private static volatile Gfsh instance;
    private static final ThreadLocal<Boolean> resultTypeTL;
    private static final String OS;
    protected static final Logger logger;
    private final Map<String, String> env = new TreeMap<String, String>();
    private final List<String> readonlyAppEnv = new ArrayList<String>();
    private final Map<String, String> expandedPropCommandsMap = new HashMap<String, String>();
    private final GfshExecutionStrategy executionStrategy;
    private final GfshParser parser;
    private final LogWrapper gfshFileLogger;
    private final GfshConfig gfshConfig;
    private final GfshHistory gfshHistory;
    private final ANSIHandler ansiHandler;
    private final boolean isHeadlessMode;
    private OperationInvoker operationInvoker;
    private int lastExecutionStatus;
    private Thread runner;
    private boolean debugON;
    private LineReader lineReader;
    private Terminal terminal;
    private boolean suppressScriptCmdOutput;
    private boolean isScriptRunning;
    private AbstractSignalNotificationHandler signalHandler;
    private ExitShellRequest exitShellRequest;
    private StringBuilder multiLineBuffer;

    public Gfsh() {
        this(null);
    }

    protected Gfsh(String[] args) {
        this(true, args, new GfshConfig());
    }

    protected Gfsh(boolean launchShell, String[] args, GfshConfig gfshConfig) {
        this.gfshConfig = gfshConfig;
        this.gfshFileLogger = LogWrapper.getInstance(null);
        this.gfshFileLogger.configure(this.gfshConfig);
        this.ansiHandler = ANSIHandler.getInstance(this.gfshConfig.isANSISupported());
        Banner banner = new Banner();
        this.gfshFileLogger.info(banner.getString());
        this.gfshHistory = new GfshHistory();
        this.gfshHistory.setHistoryFilePath(Paths.get(gfshConfig.getHistoryFileName(), new String[0]));
        this.initializeEnvironment();
        this.executionStrategy = new GfshExecutionStrategy(this);
        this.parser = new GfshParser(new CommandManager());
        String envProps = this.env.toString();
        envProps = envProps.substring(1, envProps.length() - 1);
        envProps = envProps.replaceAll(",", LINE_SEPARATOR);
        this.gfshFileLogger.config("***** gfsh Environment ******" + LINE_SEPARATOR + envProps);
        if (this.gfshFileLogger.fineEnabled()) {
            String gfshConfigStr = this.gfshConfig.toString();
            gfshConfigStr = gfshConfigStr.substring(0, gfshConfigStr.length() - 1);
            gfshConfigStr = gfshConfigStr.replaceAll(",", LINE_SEPARATOR);
            this.gfshFileLogger.fine("***** gfsh Configuration ******" + LINE_SEPARATOR + gfshConfigStr);
        }
        try {
            ClassUtils.forName((String)"sun.misc.Signal", (RuntimeException)((Object)new SunAPINotFoundException("WARNING!!! Not running a Sun JVM.  Could not find the sun.misc.Signal class; Signal handling disabled.")));
            this.signalHandler = new GfshSignalHandler();
        }
        catch (SunAPINotFoundException e) {
            this.signalHandler = new AbstractSignalNotificationHandler(){};
            this.gfshFileLogger.warning(e.getMessage());
        }
        if (this.gfshConfig.isTestConfig()) {
            instance = this;
        }
        boolean bl = this.isHeadlessMode = !launchShell;
        if (this.isHeadlessMode) {
            this.gfshFileLogger.config("Running in headless mode");
            System.setProperty("jline.terminal", GfshUnsupportedTerminal.class.getName());
            this.env.put(ENV_APP_QUIET_EXECUTION, String.valueOf(true));
        }
        this.redirectInternalJavaLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gfsh getInstance(boolean launchShell, String[] args, GfshConfig gfshConfig) {
        Gfsh localGfshInstance = instance;
        if (localGfshInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                localGfshInstance = instance;
                if (localGfshInstance == null) {
                    localGfshInstance = new Gfsh(launchShell, args, gfshConfig);
                    localGfshInstance.executeInitFileIfPresent();
                    instance = localGfshInstance;
                }
            }
        }
        return instance;
    }

    public static boolean isInfoResult() {
        if (resultTypeTL.get() == null) {
            return false;
        }
        return resultTypeTL.get();
    }

    public static void println() {
        gfshout.println();
    }

    public static void println(Object toPrint) {
        gfshout.println(toPrint);
    }

    public static void print(Object toPrint) {
        gfshout.print(toPrint);
    }

    public static void printlnErr(Object toPrint) {
        gfsherr.println(toPrint);
    }

    private static String readLine(LineReader reader, String prompt) {
        try {
            return reader.readLine(prompt);
        }
        catch (UserInterruptException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("User interrupted input with Ctrl-C");
            }
            return "";
        }
        catch (EndOfFileException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("End-of-file signal received (Ctrl-D)");
            }
            return null;
        }
    }

    private static String removeBackslash(String result) {
        if (result.endsWith("\\")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void redirectInternalJavaLoggers() {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        logger.debug("JUL loggers redirected to Log4j2 via log4j-jul bridge");
    }

    public static Gfsh getCurrentInstance() {
        return instance;
    }

    private static String extractKey(String input) {
        return input.substring("${".length(), input.length() - "}".length());
    }

    public static LineReader getConsoleReader() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh == null ? null : gfsh.lineReader;
    }

    public static String wrapText(String string, int indentationLevel, int terminalWidth) {
        if (terminalWidth <= 1) {
            return string;
        }
        int maxLineLength = terminalWidth - 1;
        StringBuilder stringBuf = new StringBuilder();
        int index = 0;
        int startOfCurrentLine = 0;
        while (index < string.length()) {
            for (int i = 0; i < indentationLevel; ++i) {
                stringBuf.append(LINE_INDENT);
            }
            for (int currentLineLength = LINE_INDENT.length() * indentationLevel; index < string.length() && currentLineLength < maxLineLength && string.charAt(index) != '\n'; ++index, ++currentLineLength) {
            }
            if (index != string.length() && string.charAt(index) == '\n') {
                stringBuf.append(string, startOfCurrentLine, index);
                stringBuf.append(LINE_SEPARATOR);
                startOfCurrentLine = ++index;
            } else if (index == string.length() || string.charAt(index) == ' ') {
                stringBuf.append(string, startOfCurrentLine, index);
                if (index != string.length()) {
                    stringBuf.append(LINE_SEPARATOR);
                }
            } else {
                int spaceCharIndex = string.lastIndexOf(" ", index);
                if (spaceCharIndex == -1 || spaceCharIndex < startOfCurrentLine) {
                    stringBuf.append(string, startOfCurrentLine, index).append(LINE_SEPARATOR);
                } else {
                    stringBuf.append(string, startOfCurrentLine, spaceCharIndex).append(LINE_SEPARATOR);
                    index = spaceCharIndex + 1;
                }
            }
            startOfCurrentLine = ++index;
        }
        return stringBuf.toString();
    }

    private void initializeEnvironment() {
        this.env.put(ENV_SYS_USER, System.getProperty("user.name"));
        this.env.put(ENV_SYS_USER_HOME, System.getProperty("user.home"));
        this.env.put(ENV_SYS_HOST_NAME, new HostName().determineHostName());
        this.env.put(ENV_SYS_CLASSPATH, System.getProperty("java.class.path"));
        this.env.put(ENV_SYS_JAVA_VERSION, System.getProperty("java.version"));
        this.env.put(ENV_SYS_OS, System.getProperty("os.name"));
        this.env.put(ENV_SYS_OS_LINE_SEPARATOR, System.lineSeparator());
        this.env.put(ENV_SYS_GEODE_HOME_DIR, System.getenv("GEODE_HOME"));
        this.env.put(ENV_APP_NAME, GFSH_APP_NAME);
        this.readonlyAppEnv.add(ENV_APP_NAME);
        this.env.put(ENV_APP_LOGGING_ENABLED, String.valueOf(!Level.OFF.equals((Object)this.gfshConfig.getLogLevel())));
        this.readonlyAppEnv.add(ENV_APP_LOGGING_ENABLED);
        this.env.put(ENV_APP_LOG_FILE, this.gfshConfig.getLogFilePath());
        this.readonlyAppEnv.add(ENV_APP_LOG_FILE);
        this.env.put(ENV_APP_PWD, System.getProperty("user.dir"));
        this.readonlyAppEnv.add(ENV_APP_PWD);
        this.env.put(ENV_APP_FETCH_SIZE, String.valueOf(100));
        this.env.put(ENV_APP_LAST_EXIT_STATUS, String.valueOf(0));
        this.readonlyAppEnv.add(ENV_APP_LAST_EXIT_STATUS);
        this.env.put(ENV_APP_COLLECTION_LIMIT, String.valueOf(20));
        this.env.put(ENV_APP_QUERY_RESULTS_DISPLAY_MODE, DEFAULT_APP_QUERY_RESULTS_DISPLAY_MODE);
        this.env.put(ENV_APP_QUIET_EXECUTION, String.valueOf(false));
        this.env.put(ENV_APP_RESULT_VIEWER, DEFAULT_APP_RESULT_VIEWER);
    }

    public AbstractSignalNotificationHandler getSignalHandler() {
        return this.signalHandler;
    }

    public String readPassword(String textToPrompt) {
        if (this.isHeadlessMode && this.isQuietMode()) {
            return null;
        }
        return this.readWithMask(textToPrompt, Character.valueOf('*'));
    }

    public String readText(String textToPrompt) {
        if (this.isHeadlessMode && this.isQuietMode()) {
            return null;
        }
        return this.interact(textToPrompt);
    }

    public void start() {
        this.runner = new LoggingThread(this.getShellName(), false, (Runnable)this);
        this.runner.start();
    }

    protected String getShellName() {
        return "Gfsh Launcher";
    }

    public void stop() {
        this.closeShell();
        LogWrapper.close();
        if (this.operationInvoker != null && this.operationInvoker.isConnected()) {
            this.operationInvoker.stop();
        }
        instance = null;
    }

    private void closeShell() {
        try {
            if (this.operationInvoker != null && this.operationInvoker.isConnected()) {
                try {
                    this.operationInvoker.stop();
                    if (this.gfshFileLogger.fineEnabled()) {
                        this.gfshFileLogger.fine("Operation invoker disconnected");
                    }
                }
                catch (Exception e) {
                    this.gfshFileLogger.warning("Error disconnecting operation invoker", e);
                }
            }
            if (this.gfshHistory != null) {
                try {
                    this.gfshHistory.setAutoFlush(true);
                    if (this.gfshFileLogger.fineEnabled()) {
                        this.gfshFileLogger.fine("Command history saved");
                    }
                }
                catch (Exception e) {
                    this.gfshFileLogger.warning("Failed to save command history", e);
                }
            }
            if (this.lineReader != null) {
                try {
                    this.lineReader = null;
                    if (this.gfshFileLogger.fineEnabled()) {
                        this.gfshFileLogger.fine("LineReader closed");
                    }
                }
                catch (Exception e) {
                    this.gfshFileLogger.warning("Error closing LineReader", e);
                }
            }
            if (this.terminal != null) {
                try {
                    this.terminal.close();
                    if (this.gfshFileLogger.fineEnabled()) {
                        this.gfshFileLogger.fine("Terminal closed");
                    }
                }
                catch (Exception e) {
                    this.gfshFileLogger.warning("Error closing terminal", e);
                }
            }
            if (this.signalHandler != null) {
                try {
                    this.signalHandler = null;
                    if (this.gfshFileLogger.fineEnabled()) {
                        this.gfshFileLogger.fine("Signal handlers unregistered");
                    }
                }
                catch (Exception e) {
                    this.gfshFileLogger.warning("Error unregistering signal handlers", e);
                }
            }
            try {
                gfshThreadLocal.remove();
                resultTypeTL.remove();
                if (this.gfshFileLogger.fineEnabled()) {
                    this.gfshFileLogger.fine("ThreadLocal state cleaned");
                }
            }
            catch (Exception e) {
                this.gfshFileLogger.warning("Error cleaning ThreadLocal state", e);
            }
            if (this.exitShellRequest == null) {
                this.exitShellRequest = ExitShellRequest.NORMAL_EXIT;
            }
            if (this.gfshFileLogger.fineEnabled()) {
                this.gfshFileLogger.fine("Shell closed successfully");
            }
        }
        catch (Exception e) {
            this.gfshFileLogger.severe("Error during shell shutdown", e);
        }
    }

    public ExitShellRequest getExitShellRequest() {
        return this.exitShellRequest;
    }

    public void waitForComplete() throws InterruptedException {
        this.runner.join();
    }

    private void executeInitFileIfPresent() {
        String initFileName = this.gfshConfig.getInitFileName();
        if (initFileName != null) {
            this.gfshFileLogger.info("Using " + initFileName);
            try {
                File gfshInitFile = new File(initFileName);
                boolean continueOnError = false;
                this.executeScript(gfshInitFile, this.isQuietMode(), continueOnError);
            }
            catch (Exception exception) {
                this.gfshFileLogger.severe(initFileName, exception);
                this.setLastExecutionStatus(-1);
            }
        }
    }

    protected Collection<URL> findResources(String resourceName) {
        return null;
    }

    protected GfshExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public GfshParser getParser() {
        return this.parser;
    }

    public LogWrapper getGfshFileLogger() {
        return this.gfshFileLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CommandResult executeCommand(String line) {
        if (line == null || line.trim().isEmpty()) {
            return null;
        }
        try {
            Object result;
            GfshParseResult parseResult;
            String expandedLine;
            String string = expandedLine = !line.contains("$") ? line : this.expandProperties(line);
            if (!line.equals(expandedLine)) {
                this.expandedPropCommandsMap.put(expandedLine, line);
            }
            try {
                parseResult = this.parser.parse(expandedLine);
            }
            catch (IllegalArgumentException e) {
                String errorMessage = e.getClass().getName() + ": " + e.getMessage();
                ResultModel errorResult2 = ResultModel.createError(errorMessage);
                this.setLastExecutionStatus(-1);
                CommandResult commandResult = new CommandResult(errorResult2);
                this.expandedPropCommandsMap.clear();
                return commandResult;
            }
            catch (Exception e) {
                this.logWarning("Error parsing command: " + expandedLine, e);
                ResultModel errorResult = ResultModel.createError("Parse error: " + e.getMessage());
                this.setLastExecutionStatus(-1);
                CommandResult errorResult2 = new CommandResult(errorResult);
                this.expandedPropCommandsMap.clear();
                return errorResult2;
            }
            if (parseResult == null) {
                String commandName = this.extractCommandNameForError(expandedLine);
                ResultModel errorResult = ResultModel.createError("Command '" + commandName + "' not found");
                this.setLastExecutionStatus(-1);
                CommandResult errorResult2 = new CommandResult(errorResult);
                return errorResult2;
            }
            try {
                result = this.executionStrategy.execute(parseResult);
            }
            catch (Exception e) {
                this.logWarning("Error executing command: " + expandedLine, e);
                ResultModel errorResult = ResultModel.createError("Execution error: " + e.getMessage());
                this.setLastExecutionStatus(-1);
                CommandResult commandResult = new CommandResult(errorResult);
                this.expandedPropCommandsMap.clear();
                return commandResult;
            }
            CommandResult commandResult = this.convertToCommandResult(result);
            if (commandResult != null && Result.Status.ERROR.equals((Object)commandResult.getStatus())) {
                this.setLastExecutionStatus(-2);
            } else {
                this.setLastExecutionStatus(0);
            }
            if (this.gfshFileLogger.fineEnabled()) {
                this.logCommandToOutput(expandedLine);
            }
            CommandResult commandResult2 = commandResult;
            return commandResult2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.expandedPropCommandsMap.clear();
        }
    }

    private CommandResult convertToCommandResult(Object result) {
        if (result == null) {
            return new CommandResult(ResultModel.createError("Command returned no result"));
        }
        if (result instanceof CommandResult) {
            return (CommandResult)result;
        }
        if (result instanceof ResultModel) {
            return new CommandResult((ResultModel)result);
        }
        if (result instanceof String) {
            return new CommandResult(ResultModel.createInfo((String)result));
        }
        return new CommandResult(ResultModel.createInfo(result.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeScriptLine(String line) {
        boolean success = false;
        String withPropsExpanded = line;
        try {
            if (line.contains("$")) {
                withPropsExpanded = this.expandProperties(line);
            }
            String logMessage = "Command String to execute .. ";
            if (!line.equals(withPropsExpanded)) {
                if (!this.isQuietMode()) {
                    Gfsh.println("Post substitution: " + withPropsExpanded);
                }
                logMessage = "Command String after substitution : ";
                this.expandedPropCommandsMap.put(withPropsExpanded, line);
            }
            if (this.gfshFileLogger.fineEnabled()) {
                this.gfshFileLogger.fine(logMessage + ArgumentRedactor.redact((String)withPropsExpanded));
            }
            success = this.executeScriptLineInternal(withPropsExpanded);
        }
        catch (Exception e) {
            this.setLastExecutionStatus(-1);
        }
        finally {
            this.gfshHistory.setAutoFlush(true);
            this.gfshHistory.addToHistory(line);
            this.gfshHistory.setAutoFlush(false);
            this.expandedPropCommandsMap.clear();
        }
        return success;
    }

    private boolean executeScriptLineInternal(String line) {
        try {
            GfshParseResult parseResult;
            try {
                parseResult = this.parser.parse(line);
            }
            catch (IllegalArgumentException e) {
                String errorMessage = e.getClass().getName() + ": " + e.getMessage();
                ResultModel errorResult = ResultModel.createError(errorMessage);
                this.handleExecutionResult(errorResult);
                this.setLastExecutionStatus(-1);
                return false;
            }
            if (parseResult == null) {
                String commandName = this.extractCommandNameForError(line);
                ResultModel errorResult = ResultModel.createError("Command '" + commandName + "' not found");
                this.handleExecutionResult(errorResult);
                this.setLastExecutionStatus(-1);
                return false;
            }
            Object result = this.executionStrategy.execute(parseResult);
            this.handleExecutionResult(result);
            return this.getLastExecutionStatus() == 0;
        }
        catch (Exception e) {
            this.logWarning("Error executing command: " + line, e);
            this.setLastExecutionStatus(-1);
            return false;
        }
    }

    private String extractCommandNameForError(String line) {
        if (line == null || line.trim().isEmpty()) {
            return "";
        }
        String[] tokens = line.trim().split("\\s+");
        for (int wordCount = Math.min(5, tokens.length); wordCount >= 1; --wordCount) {
            StringBuilder candidateCommand = new StringBuilder();
            for (int i = 0; i < wordCount; ++i) {
                String token;
                if (i > 0) {
                    candidateCommand.append(" ");
                }
                if ((token = tokens[i]).startsWith("--")) break;
                candidateCommand.append(token);
            }
            String candidate = candidateCommand.toString();
            if (wordCount <= 1 || candidate.split("\\s+").length != wordCount) continue;
            return candidate;
        }
        return tokens[0];
    }

    public String interact(String textToPrompt) {
        try {
            return this.lineReader.readLine(textToPrompt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String readWithMask(String textToPrompt, Character mask) {
        try {
            return this.lineReader.readLine(textToPrompt, mask);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printBannerAndWelcome() {
        this.printAsInfo(this.getBanner());
        this.printAsInfo(this.getWelcomeMessage());
    }

    public String getBanner() {
        String sb = "    _________________________     __" + LINE_SEPARATOR + "   / _____/ ______/ ______/ /____/ /" + LINE_SEPARATOR + "  / /  __/ /___  /_____  / _____  / " + LINE_SEPARATOR + " / /__/ / ____/  _____/ / /    / /  " + LINE_SEPARATOR + "/______/_/      /______/_/    /_/    " + this.getVersion() + LINE_SEPARATOR;
        return this.ansiHandler.decorateString(sb, ANSIHandler.ANSIStyle.BLUE);
    }

    protected String getProductName() {
        return GFSH_APP_NAME;
    }

    public String getVersion() {
        return this.getVersion(false);
    }

    public String getVersion(boolean full) {
        return full ? this.getFullVersion() : this.getShortVersion();
    }

    private String getShortVersion() {
        return ProductVersionUtil.getDistributionVersion().getVersion();
    }

    private String getFullVersion() {
        try {
            return ((StringBuilder)ProductVersionUtil.appendFullVersion((Appendable)new StringBuilder())).append(System.lineSeparator()).append(SystemDescription.getRunningOnInfo()).append(System.lineSeparator()).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getGeodeSerializationVersion() {
        return KnownVersion.CURRENT.getName();
    }

    public String getWelcomeMessage() {
        return this.ansiHandler.decorateString("Monitor and Manage " + ProductVersionUtil.getDistributionVersion().getName(), ANSIHandler.ANSIStyle.CYAN);
    }

    protected void handleExecutionResult(Object result) {
        try {
            if (result instanceof Result) {
                Result commandResult = (Result)result;
                boolean isError = Result.Status.ERROR.equals((Object)commandResult.getStatus());
                if (isError) {
                    this.setLastExecutionStatus(-2);
                } else {
                    this.setLastExecutionStatus(0);
                }
                if (this.useExternalViewer(commandResult)) {
                    CliUtils.runLessCommandAsExternalViewer(commandResult);
                } else {
                    if (!this.isScriptRunning) {
                        while (commandResult.hasNextLine()) {
                            String nextLine = commandResult.nextLine();
                            this.write(nextLine, isError);
                        }
                    } else if (!this.suppressScriptCmdOutput) {
                        while (commandResult.hasNextLine()) {
                            this.write(commandResult.nextLine(), isError);
                        }
                    }
                    commandResult.resetToFirstLine();
                }
                resultTypeTL.set(null);
            }
            if (result != null && !(result instanceof Result)) {
                this.printAsInfo(result.toString());
            }
        }
        catch (Exception e) {
            this.printAsWarning(e.getMessage());
            this.logToFile(e.getMessage(), e);
        }
    }

    private boolean useExternalViewer(Result result) {
        boolean flag;
        boolean bl = flag = EXTERNAL_RESULT_VIEWER.equals(this.getEnvProperty(ENV_APP_RESULT_VIEWER)) && this.isUnix();
        if (result instanceof CommandResult) {
            CommandResult commandResult = (CommandResult)result;
            resultTypeTL.set(commandResult.getType().equals("info"));
            return flag && !commandResult.getType().equals("info");
        }
        return false;
    }

    private boolean isUnix() {
        return !OS.contains("win");
    }

    private void write(String message, boolean isError) {
        if (isError) {
            this.printAsWarning(message);
        } else {
            Gfsh.println(message);
        }
    }

    protected LineReader createConsoleReader() {
        LineReader lineReader;
        this.migrateHistoryFileIfNeeded();
        GfshCompleter completer = new GfshCompleter(this.parser);
        this.lineReader = lineReader = LineReaderBuilder.builder().terminal(this.terminal).history((History)this.gfshHistory).variable("history-file", (Object)Paths.get(this.getHistoryFileName(), new String[0])).variable("history-size", (Object)this.gfshConfig.getHistorySize()).completer((Completer)completer).build();
        return lineReader;
    }

    private void migrateHistoryFileIfNeeded() {
        try {
            Path historyPath = Paths.get(this.getHistoryFileName(), new String[0]);
            if (!Files.exists(historyPath, new LinkOption[0])) {
                return;
            }
            List<String> lines = Files.readAllLines(historyPath);
            boolean hasOldFormat = false;
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.startsWith("//") || trimmed.startsWith("#")) {
                    hasOldFormat = true;
                    break;
                }
                if (!trimmed.contains(":") || trimmed.matches("^\\d+:\\d+:.*")) continue;
                hasOldFormat = true;
                break;
            }
            if (hasOldFormat) {
                Path backupPath = historyPath.getParent().resolve(historyPath.getFileName().toString() + ".old");
                Files.move(historyPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
                this.gfshFileLogger.info("Migrated old history file format. Backup saved to: " + String.valueOf(backupPath));
            }
        }
        catch (IOException e) {
            this.gfshFileLogger.warning("Could not migrate history file", e);
        }
    }

    protected void logCommandToOutput(String processedLine) {
        String originalString = this.expandedPropCommandsMap.get(processedLine);
        if (originalString != null) {
            this.gfshFileLogger.info(ArgumentRedactor.redact((String)originalString));
            this.gfshFileLogger.info(ArgumentRedactor.redact((String)"// Post substitution"));
            this.gfshFileLogger.info(ArgumentRedactor.redact((String)("//" + processedLine)));
        } else {
            this.gfshFileLogger.info(ArgumentRedactor.redact((String)processedLine));
        }
    }

    public String versionInfo() {
        return this.getVersion();
    }

    public int getTerminalHeight() {
        return this.terminal != null ? this.terminal.getHeight() : 100;
    }

    public int getTerminalWidth() {
        if (this.terminal != null) {
            return this.terminal.getWidth();
        }
        Map<String, String> env = System.getenv();
        String columnsFromEnv = env.get("COLUMNS");
        if (columnsFromEnv != null) {
            return Integer.parseInt(columnsFromEnv);
        }
        return 100;
    }

    public int getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public void setLastExecutionStatus(int lastExecutionStatus) {
        this.lastExecutionStatus = lastExecutionStatus;
        this.env.put(ENV_APP_LAST_EXIT_STATUS, String.valueOf(lastExecutionStatus));
    }

    public void printAsInfo(String message) {
        if (this.isHeadlessMode) {
            Gfsh.println(message);
        } else {
            logger.info(message);
        }
    }

    public void printAsWarning(String message) {
        if (this.isHeadlessMode) {
            Gfsh.printlnErr(message);
        } else {
            logger.warn(message);
        }
    }

    public void printAsSevere(String message) {
        if (this.isHeadlessMode) {
            Gfsh.printlnErr(message);
        } else {
            logger.error(message);
        }
    }

    public void logInfo(String message, Throwable t) {
        if (this.debugON) {
            logger.info(message, t);
        } else {
            logger.info(message);
        }
        if (this.gfshFileLogger.infoEnabled()) {
            this.gfshFileLogger.info(message, t);
        }
    }

    public void logWarning(String message, Throwable t) {
        if (this.debugON) {
            logger.warn(message, t);
        } else {
            logger.warn(message);
        }
        if (this.gfshFileLogger.warningEnabled()) {
            this.gfshFileLogger.warning(message, t);
        }
    }

    public void logSevere(String message, Throwable t) {
        if (this.debugON) {
            logger.error(message, t);
        } else {
            logger.error(message);
        }
        if (this.gfshFileLogger.severeEnabled()) {
            this.gfshFileLogger.severe(message, t);
        }
    }

    public boolean logToFile(String message, Throwable t) {
        boolean loggedMessage = false;
        if (this.gfshFileLogger != null) {
            this.gfshFileLogger.info(message, t);
            loggedMessage = true;
        }
        return loggedMessage;
    }

    public ResultModel executeScript(File scriptFile, boolean quiet, boolean continueOnError) {
        ResultModel result = null;
        String initialIsQuiet = this.getEnvProperty(ENV_APP_QUIET_EXECUTION);
        try {
            BufferedReader reader;
            this.isScriptRunning = true;
            if (scriptFile == null) {
                throw new IllegalArgumentException("Given script file is null.");
            }
            if (!scriptFile.exists()) {
                throw new IllegalArgumentException("Given script file does not exist.");
            }
            if (scriptFile.exists() && scriptFile.isDirectory()) {
                throw new IllegalArgumentException(scriptFile.getPath() + " is a directory.");
            }
            ScriptExecutionDetails scriptInfo = new ScriptExecutionDetails(scriptFile.getPath());
            if (scriptFile.exists()) {
                this.setEnvProperty(ENV_APP_QUIET_EXECUTION, String.valueOf(quiet));
                this.suppressScriptCmdOutput = quiet;
                reader = new BufferedReader(new FileReader(scriptFile));
                String lineRead = "";
                StringBuilder linesBuffer = new StringBuilder();
                String linesBufferString = "";
                int commandSrNum = 0;
                CommentSkipHelper commentSkipper = new CommentSkipHelper();
                block5: while (this.exitShellRequest == null && (lineRead = reader.readLine()) != null) {
                    String lineWithoutComments;
                    if (linesBuffer == null) {
                        linesBuffer = new StringBuilder();
                    }
                    if ((lineWithoutComments = commentSkipper.skipComments(lineRead)) == null || lineWithoutComments.isEmpty()) continue;
                    if (linesBuffer.length() != 0) {
                        linesBuffer.append(" ");
                    }
                    linesBuffer.append(lineWithoutComments);
                    linesBufferString = linesBuffer.toString();
                    if (!linesBufferString.endsWith("\\")) {
                        List<String> commandList = MultiCommandHelper.getMultipleCommands(linesBufferString);
                        for (String cmdLet : commandList) {
                            if (cmdLet.isEmpty()) continue;
                            String redactedCmdLet = ArgumentRedactor.redact((String)cmdLet);
                            Gfsh.println(++commandSrNum + ". Executing - " + redactedCmdLet);
                            Gfsh.println();
                            boolean executeSuccess = this.executeScriptLine(cmdLet);
                            if (!executeSuccess) {
                                this.setLastExecutionStatus(-1);
                            }
                            scriptInfo.addCommandAndStatus(cmdLet, this.getLastExecutionStatus() == -1 || this.getLastExecutionStatus() == -2 ? "FAILED" : "PASSED");
                            if (this.getLastExecutionStatus() != -1 && this.getLastExecutionStatus() != -2 || continueOnError) continue;
                            break block5;
                        }
                        linesBuffer = null;
                        linesBufferString = null;
                        continue;
                    }
                    linesBuffer.deleteCharAt(linesBuffer.length() - 1);
                }
            } else {
                throw new CommandProcessingException(scriptFile.getPath() + " doesn't exist.", 5, scriptFile);
            }
            reader.close();
            result = scriptInfo.getResult();
            scriptInfo.logScriptExecutionInfo(this.gfshFileLogger, result);
            if (quiet) {
                result = ResultModel.createInfo("");
            }
        }
        catch (IOException e) {
            throw new CommandProcessingException("Error while reading file " + String.valueOf(scriptFile), 11, e);
        }
        finally {
            this.setEnvProperty(ENV_APP_QUIET_EXECUTION, initialIsQuiet);
            this.isScriptRunning = false;
        }
        return result;
    }

    public String setEnvProperty(String propertyName, String propertyValue) {
        if (propertyName == null || propertyValue == null) {
            throw new IllegalArgumentException("Environment Property name and/or value can not be set to null.");
        }
        if (propertyName.startsWith("SYS") || this.readonlyAppEnv.contains(propertyName)) {
            throw new IllegalArgumentException("The Property " + propertyName + " can not be modified.");
        }
        return this.env.put(propertyName, propertyValue);
    }

    public String getEnvProperty(String propertyName) {
        return this.env.get(propertyName);
    }

    public String getEnvAppContextPath() {
        String path = this.getEnvProperty(ENV_APP_CONTEXT_PATH);
        if (path == null) {
            return "";
        }
        return path;
    }

    public Map<String, String> getEnv() {
        return new TreeMap<String, String>(this.env);
    }

    public boolean isQuietMode() {
        return Boolean.parseBoolean(this.env.get(ENV_APP_QUIET_EXECUTION));
    }

    public void promptLoop() {
        String line = null;
        String prompt = this.getPromptText();
        this.gfshHistory.setAutoFlush(false);
        this.multiLineBuffer = null;
        while (this.exitShellRequest == null && (line = Gfsh.readLine(this.lineReader, prompt)) != null) {
            if (line.trim().isEmpty()) {
                if (this.multiLineBuffer != null) {
                    this.multiLineBuffer = null;
                    prompt = this.getPromptText();
                    continue;
                }
                prompt = this.getPromptText();
                continue;
            }
            if (this.multiLineBuffer == null) {
                this.multiLineBuffer = new StringBuilder();
            } else {
                this.multiLineBuffer.append(" ");
            }
            this.multiLineBuffer.append(line);
            String accumulatedCommand = this.multiLineBuffer.toString();
            if (!accumulatedCommand.endsWith("\\")) {
                List<String> commandList = MultiCommandHelper.getMultipleCommands(accumulatedCommand);
                for (String cmdLet : commandList) {
                    CommandResult result;
                    String trimmedCommand = cmdLet.trim();
                    if (trimmedCommand.isEmpty() || (result = this.executeCommand(cmdLet)) == null) continue;
                    this.handleExecutionResult(result);
                }
                this.multiLineBuffer = null;
                prompt = this.getPromptText();
                continue;
            }
            this.multiLineBuffer.deleteCharAt(this.multiLineBuffer.length() - 1);
            prompt = this.getDefaultSecondaryPrompt();
        }
        if (line == null) {
            this.exitShellRequest = ExitShellRequest.NORMAL_EXIT;
            this.gfshFileLogger.info("Exiting gfsh, it seems Ctrl-D was pressed.");
        }
        Gfsh.println((line == null ? LINE_SEPARATOR : "") + "Exiting... ");
    }

    String getDefaultSecondaryPrompt() {
        return this.ansiHandler.decorateString(DEFAULT_SECONDARY_PROMPT, ANSIHandler.ANSIStyle.YELLOW);
    }

    public boolean isConnectedAndReady() {
        return this.operationInvoker != null && this.operationInvoker.isConnected() && this.operationInvoker.isReady();
    }

    public static boolean isCurrentInstanceConnectedAndReady() {
        return Gfsh.getCurrentInstance() != null && Gfsh.getCurrentInstance().isConnectedAndReady();
    }

    public OperationInvoker getOperationInvoker() {
        return this.operationInvoker;
    }

    public void setOperationInvoker(OperationInvoker operationInvoker) {
        this.operationInvoker = operationInvoker;
    }

    public GfshConfig getGfshConfig() {
        return this.gfshConfig;
    }

    protected String getHistoryFileName() {
        return this.gfshConfig.getHistoryFileName();
    }

    public void clearHistory() {
        try {
            this.gfshHistory.purge();
        }
        catch (IOException e) {
            this.printAsWarning("Failed to clear history: " + e.getMessage());
        }
        if (!this.gfshConfig.deleteHistoryFile()) {
            this.printAsWarning("Gfsh history file is not deleted");
        }
    }

    public String getLogFilePath() {
        return this.gfshConfig.getLogFilePath();
    }

    public boolean isLoggingEnabled() {
        return this.gfshConfig.isLoggingEnabled();
    }

    protected String getPromptText() {
        int clusterId;
        String defaultPrompt = this.gfshConfig.getDefaultPrompt();
        String contextPath = "";
        Object clusterString = "";
        if (this.getOperationInvoker() != null && this.isConnectedAndReady() && (clusterId = this.getOperationInvoker().getClusterId()) != -1) {
            clusterString = "Cluster-" + clusterId + " ";
        }
        defaultPrompt = MessageFormat.format(defaultPrompt, clusterString, contextPath);
        return this.ansiHandler.decorateString(defaultPrompt, ANSIHandler.ANSIStyle.YELLOW);
    }

    public void notifyDisconnect(String endPoints) {
        String message = CliStrings.format((String)"No longer connected to {0}.", (Object[])new Object[]{endPoints});
        if (this.exitShellRequest != null) {
            this.printAsInfo(LINE_SEPARATOR + message);
            if (this.gfshFileLogger.infoEnabled()) {
                this.gfshFileLogger.info(message);
            }
        } else {
            if (!this.isHeadlessMode) {
                this.printAsSevere(LINE_SEPARATOR + message);
            }
            if (this.gfshFileLogger.infoEnabled()) {
                this.gfshFileLogger.info(message);
            }
        }
        this.setEnvProperty(ENV_APP_CONTEXT_PATH, this.getEnvAppContextPath());
    }

    public boolean getDebug() {
        return this.debugON;
    }

    public void setDebug(boolean flag) {
        this.debugON = flag;
    }

    public boolean isHeadlessMode() {
        return this.isHeadlessMode;
    }

    public GfshHistory getGfshHistory() {
        return this.gfshHistory;
    }

    protected String expandProperties(String input) {
        String output = input;
        try (Scanner s = new Scanner(output);){
            String foundInLine;
            while ((foundInLine = s.findInLine("(\\$[\\{]\\w+[\\}])")) != null) {
                String envProperty = this.getEnvProperty(Gfsh.extractKey(foundInLine));
                envProperty = envProperty != null ? envProperty : "";
                output = output.replace(foundInLine, envProperty);
            }
        }
        return output;
    }

    @Override
    public void run() {
        try {
            if (!this.isHeadlessMode) {
                this.initializeTerminal();
                this.createConsoleReader();
            }
            this.printBannerAndWelcome();
            this.promptLoop();
        }
        catch (Exception e) {
            this.gfshFileLogger.severe("Error in shell main loop", e);
        }
    }

    private void initializeTerminal() throws IOException {
        if (this.terminal == null) {
            this.terminal = TerminalBuilder.builder().system(true).build();
        }
    }

    static {
        resultTypeTL = new ThreadLocal();
        OS = System.getProperty("os.name").toLowerCase();
        logger = LogService.getLogger();
    }
}

