/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.management.internal.cli.result.Align;
import org.apache.geode.management.internal.cli.result.Column;
import org.apache.geode.management.internal.cli.result.RowGroup;
import org.apache.geode.management.internal.cli.result.Screen;

class Row {
    private final RowGroup rowGroup;
    private final Character rowSeparator;
    private final List<Column> columns = new ArrayList<Column>();
    private final boolean isTableWideSeparator;
    private final Screen screen;
    private String columnSeparator;
    private boolean isBlank;

    Row(RowGroup rowGroup, Screen screen) {
        this(rowGroup, screen, null, false);
    }

    Row(RowGroup rowGroup, Screen screen, Character rowSeparator, boolean isTableWideSeparator) {
        this.rowGroup = rowGroup;
        this.screen = screen;
        this.rowSeparator = rowSeparator;
        this.isTableWideSeparator = isTableWideSeparator;
    }

    public String toString() {
        return "Row{columns=" + String.valueOf(this.columns) + "}";
    }

    Row newLeftCol(Object value) {
        Column column = new Column(value, Align.LEFT);
        this.columns.add(column);
        return this;
    }

    Row newRightCol(Object value) {
        Column column = new Column(value, Align.RIGHT);
        this.columns.add(column);
        return this;
    }

    Row newCenterCol(Object value) {
        Column column = new Column(value, Align.CENTER);
        this.columns.add(column);
        return this;
    }

    int getNumCols() {
        return this.columns.size();
    }

    int getMaxColLength(int colNum) {
        if (colNum >= this.columns.size()) {
            return 0;
        }
        return this.columns.get(colNum).getLength();
    }

    void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    String buildRow(boolean isTabularResult) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.rowSeparator != null) {
            if (this.isTableWideSeparator) {
                int maxColLength = this.rowGroup.getTable().getMaxLength();
                if (isTabularResult) {
                    maxColLength = this.screen.trimWidthForScreen(maxColLength);
                }
                for (int j = 0; j < maxColLength; ++j) {
                    stringBuilder.append(this.rowSeparator);
                }
            } else {
                int maxNumCols = this.rowGroup.getNumCols();
                for (int i = 0; i < maxNumCols; ++i) {
                    int maxColLength = this.rowGroup.getColSize(i);
                    for (int j = 0; j < maxColLength; ++j) {
                        stringBuilder.append(this.rowSeparator);
                    }
                    if (i >= maxNumCols - 1) continue;
                    stringBuilder.append(this.rowGroup.getColumnSeparator());
                }
            }
        } else {
            for (int i = 0; i < this.columns.size(); ++i) {
                boolean lastColumn = i >= this.columns.size() - 1;
                stringBuilder.append(this.columns.get(i).buildColumn(this.rowGroup.getColSize(i), lastColumn));
                if (lastColumn) continue;
                stringBuilder.append(this.getColumnSeparator());
            }
        }
        return stringBuilder.toString();
    }

    boolean isBlank() {
        return this.isBlank;
    }

    void setBlank(boolean blank) {
        this.isBlank = blank;
    }

    @VisibleForTesting
    boolean isEmpty() {
        return this.columns.isEmpty();
    }

    private String getColumnSeparator() {
        return this.columnSeparator != null ? this.columnSeparator : this.rowGroup.getColumnSeparator();
    }
}

