/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.cli.domain.DeploymentInfo;
import org.apache.geode.management.internal.functions.CacheRealizationFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public class DeployFunction
implements InternalFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.DeployFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<Object[]> context) {
        String memberIdentifier = "";
        try {
            String memberId;
            Object[] args = (Object[])context.getArguments();
            List jarFilenames = (List)args[0];
            List jarStreams = (List)args[1];
            InternalCache cache = (InternalCache)context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberIdentifier = memberId = !member.getName().equals("") ? member.getName() : member.getId();
            LinkedList results = new LinkedList();
            List deployments = jarFilenames.stream().map(jarFileName -> new Deployment(jarFileName, this.getDeployedBy(cache), Instant.now().toString())).collect(Collectors.toList());
            for (int i = 0; i < deployments.size(); ++i) {
                Deployment deployment = (Deployment)deployments.get(i);
                Execution execution = FunctionService.onMember((DistributedMember)member).setArguments(Arrays.asList(deployment, CacheElementOperation.CREATE, jarStreams.get(i)));
                List functionResult = (List)execution.execute((Function)new CacheRealizationFunction()).getResult();
                functionResult.forEach(entry -> {
                    if (entry != null) {
                        if (entry instanceof Throwable) {
                            logger.warn("Error executing CacheRealizationFunction.", (Throwable)entry);
                        } else if (entry instanceof RealizationResult) {
                            RealizationResult realizationResult = (RealizationResult)entry;
                            results.add(new DeploymentInfo(memberId, deployment.getFileName(), realizationResult.getMessage()));
                        }
                    }
                });
            }
            CliFunctionResult result = new CliFunctionResult(memberIdentifier, results);
            context.getResultSender().lastResult((Object)result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberIdentifier, false, null);
            context.getResultSender().lastResult((Object)result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable throwable) {
            SystemFailure.checkFailure();
            logger.error("Could not deploy JAR file {}", (Object)throwable.getMessage(), (Object)throwable);
            CliFunctionResult result = new CliFunctionResult(memberIdentifier, (Object)throwable, null);
            context.getResultSender().lastResult((Object)result);
        }
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }

    private String getDeployedBy(InternalCache cache) {
        Subject subject = null;
        try {
            subject = cache.getSecurityService().getSubject();
        }
        catch (AuthenticationRequiredException e) {
            logger.debug("getDeployedBy: no user information is found.", (Throwable)e);
        }
        return subject == null ? null : subject.getPrincipal().toString();
    }
}

