/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.Undefined;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.util.internal.GeodeJsonMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataCommandResult
implements Serializable {
    private static final long serialVersionUID = 2601227194108110936L;
    public static final Logger logger = LogManager.getLogger();
    public static final String DATA_INFO_SECTION = "data-info";
    public static final String QUERY_SECTION = "query";
    public static final String LOCATION_SECTION = "location";
    private String command;
    private Object putResult;
    private Object getResult;
    private List<SelectResultRow> selectResult;
    private String queryTraceString;
    public static final String RESULT_FLAG = "Result";
    public static final String NUM_ROWS = "Rows";
    public static final String MISSING_VALUE = "<NULL>";
    private List<KeyInfo> locateEntryLocations;
    private KeyInfo locateEntryResult;
    private boolean hasResultForAggregation;
    private Object removeResult;
    private Object inputKey;
    private Object inputValue;
    private Object inputQuery;
    private Throwable error;
    private String errorString;
    private String infoString;
    private String keyClass;
    private String valueClass;
    private int limit;
    private boolean operationCompletedSuccessfully;
    public static final String NEW_LINE = GfshParser.LINE_SEPARATOR;
    public static final int ROW_TYPE_STRUCT_RESULT = 100;
    public static final int ROW_TYPE_BEAN = 200;
    public static final int ROW_TYPE_PRIMITIVE = 300;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isGet()) {
            sb.append(" Type  : Get").append(NEW_LINE);
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.getResult != null) {
                sb.append(" ReturnValue Class : ").append(this.getResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue : ").append(this.getResult).append(NEW_LINE);
        } else if (this.isPut()) {
            sb.append(" Type  : Put");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.putResult != null) {
                sb.append(" ReturnValue Class : ").append(this.putResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue  : ").append(this.putResult).append(NEW_LINE);
            sb.append(" Value  : ").append(this.inputValue).append(NEW_LINE);
        } else if (this.isRemove()) {
            sb.append(" Type  : Remove");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.removeResult != null) {
                sb.append(" ReturnValue Class : ").append(this.removeResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue  : ").append(this.removeResult).append(NEW_LINE);
        } else if (this.isLocateEntry()) {
            sb.append(" Type  : Locate Entry");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            sb.append(" Results  : ").append(this.locateEntryResult).append(NEW_LINE);
            sb.append(" Locations  : ").append(this.locateEntryLocations).append(NEW_LINE);
        }
        if (this.errorString != null) {
            sb.append(" ERROR ").append(this.errorString);
        }
        return sb.toString();
    }

    public boolean isGet() {
        return "get".equals(this.command);
    }

    public boolean isPut() {
        return "put".equals(this.command);
    }

    public boolean isRemove() {
        return "remove".equals(this.command);
    }

    public boolean isLocateEntry() {
        return "locate entry".equals(this.command);
    }

    public boolean isSelect() {
        return QUERY_SECTION.equals(this.command);
    }

    public List<SelectResultRow> getSelectResult() {
        return this.selectResult;
    }

    public static DataCommandResult createGetResult(Object inputKey, Object value, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "get";
        result.inputKey = inputKey;
        result.getResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createGetInfoResult(Object inputKey, Object value, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "get";
        result.inputKey = inputKey;
        result.getResult = value;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createLocateEntryResult(Object inputKey, KeyInfo locationResult, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "locate entry";
        result.inputKey = inputKey;
        if (flag) {
            result.hasResultForAggregation = true;
        }
        result.locateEntryResult = locationResult;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createLocateEntryInfoResult(Object inputKey, KeyInfo locationResult, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "locate entry";
        result.inputKey = inputKey;
        if (flag) {
            result.hasResultForAggregation = true;
        }
        result.locateEntryResult = locationResult;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createPutResult(Object inputKey, Object value, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "put";
        result.inputKey = inputKey;
        result.putResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createPutInfoResult(Object inputKey, Object value, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "put";
        result.inputKey = inputKey;
        result.putResult = value;
        result.error = error;
        result.infoString = infoString;
        return result;
    }

    public static DataCommandResult createRemoveResult(Object inputKey, Object value, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "remove";
        result.inputKey = inputKey;
        result.removeResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createRemoveInfoResult(Object inputKey, Object value, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "remove";
        result.inputKey = inputKey;
        result.removeResult = value;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createSelectResult(Object inputQuery, List<SelectResultRow> value, String queryTraceString, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = QUERY_SECTION;
        result.inputQuery = inputQuery;
        result.queryTraceString = queryTraceString;
        result.selectResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createSelectInfoResult(Object inputQuery, List<SelectResultRow> value, int limit, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = QUERY_SECTION;
        result.inputQuery = inputQuery;
        result.limit = limit;
        result.selectResult = value;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Object getPutResult() {
        return this.putResult;
    }

    public void setPutResult(Object putResult) {
        this.putResult = putResult;
    }

    public Object getGetResult() {
        return this.getResult;
    }

    public void setGetResult(Object getResult) {
        this.getResult = getResult;
    }

    public Object getRemoveResult() {
        return this.removeResult;
    }

    public void setRemoveResult(Object removeResult) {
        this.removeResult = removeResult;
    }

    public Object getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(Object inputKey) {
        this.inputKey = inputKey;
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(Object inputValue) {
        this.inputValue = inputValue;
    }

    public Throwable getErorr() {
        return this.error;
    }

    public void setErorr(Throwable erorr) {
        this.error = erorr;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public String getInfoString() {
        return this.infoString;
    }

    public void setInfoString(String infoString) {
        this.infoString = infoString;
    }

    public String getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(String keyClass) {
        this.keyClass = keyClass;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
    }

    public List<KeyInfo> getLocateEntryLocations() {
        return this.locateEntryLocations;
    }

    public ResultModel toResultModel() {
        if (StringUtils.isEmpty((CharSequence)this.keyClass)) {
            this.keyClass = "java.lang.String";
        }
        if (StringUtils.isEmpty((CharSequence)this.valueClass)) {
            this.valueClass = "java.lang.String";
        }
        ResultModel result = new ResultModel();
        DataResultModel data = result.addData(DATA_INFO_SECTION);
        if (this.errorString != null) {
            data.addData("Message", this.errorString);
            data.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
            return result;
        }
        data.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
        if (this.infoString != null) {
            data.addData("Message", this.infoString);
        }
        if (this.isGet()) {
            this.toResultModel_isGet(data);
        } else if (this.isLocateEntry()) {
            this.toResultModel_isLocate(result, data);
        } else if (this.isPut()) {
            this.toResultModel_isPut(data);
        } else if (this.isRemove()) {
            this.toResultModel_isRemove(data);
        }
        return result;
    }

    private void toResultModel_isGet(DataResultModel data) {
        data.addData("Key Class", this.getKeyClass());
        data.addData("Key", this.inputKey);
        data.addData("Value Class", this.getValueClass());
        data.addData("Value", this.getResult != null ? this.getResult.toString() : "null");
    }

    private void toResultModel_isLocate(ResultModel result, DataResultModel data) {
        data.addData("Key Class", this.getKeyClass());
        data.addData("Key", this.inputKey);
        if (this.locateEntryLocations != null) {
            TabularResultModel locationTable = result.addTable(LOCATION_SECTION);
            int totalLocations = 0;
            for (KeyInfo info : this.locateEntryLocations) {
                List<Object[]> locations = info.getLocations();
                if (locations == null) continue;
                if (locations.size() == 1) {
                    Object[] array = locations.get(0);
                    boolean found = (Boolean)array[1];
                    if (!found) continue;
                    ++totalLocations;
                    boolean primary = (Boolean)array[3];
                    String bucketId = (String)array[4];
                    locationTable.accumulate("MemberName", info.getMemberName());
                    locationTable.accumulate("MemberId", info.getMemberId());
                    if (bucketId == null) continue;
                    if (primary) {
                        locationTable.accumulate("Primary", "*Primary PR*");
                    } else {
                        locationTable.accumulate("Primary", "No");
                    }
                    locationTable.accumulate("BucketId", bucketId);
                    continue;
                }
                for (Object[] array : locations) {
                    String regionPath = (String)array[0];
                    boolean found = (Boolean)array[1];
                    if (!found) continue;
                    ++totalLocations;
                    boolean primary = (Boolean)array[3];
                    String bucketId = (String)array[4];
                    locationTable.accumulate("MemberName", info.getMemberName());
                    locationTable.accumulate("MemberId", info.getMemberId());
                    locationTable.accumulate("RegionPath", regionPath);
                    if (bucketId == null) continue;
                    if (primary) {
                        locationTable.accumulate("Primary", "*Primary PR*");
                    } else {
                        locationTable.accumulate("Primary", "No");
                    }
                    locationTable.accumulate("BucketId", bucketId);
                }
            }
            data.addData("Locations Found", totalLocations);
        } else {
            data.addData("Location Info ", "Could not find location information");
        }
    }

    private void toResultModel_isPut(DataResultModel data) {
        data.addData("Key Class", this.getKeyClass());
        data.addData("Key", this.inputKey);
        data.addData("Value Class", this.getValueClass());
        data.addData("Old Value", this.putResult != null ? this.putResult.toString() : "null");
    }

    private void toResultModel_isRemove(DataResultModel data) {
        if (this.inputKey != null) {
            data.addData("Key Class", this.getKeyClass());
            data.addData("Key", this.inputKey);
        }
    }

    public ResultModel toSelectCommandResult() {
        ResultModel result = new ResultModel();
        DataResultModel data = result.addData(DATA_INFO_SECTION);
        if (!this.operationCompletedSuccessfully) {
            result.setStatus(Result.Status.ERROR);
            data.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
            if (this.errorString != null) {
                data.addData("Message", this.errorString);
            } else if (this.infoString != null) {
                data.addData("Message", this.infoString);
            }
            return result;
        }
        TabularResultModel table = result.addTable(QUERY_SECTION);
        data.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
        if (this.infoString != null) {
            data.addData("Message", this.infoString);
        }
        if (this.inputQuery != null) {
            if (this.limit > 0) {
                data.addData("Limit", this.limit);
            }
            if (this.selectResult != null) {
                data.addData(NUM_ROWS, this.selectResult.size());
                if (this.queryTraceString != null) {
                    data.addData("Query Trace", this.queryTraceString);
                }
                this.buildTable(table, 0, this.selectResult.size());
            }
        }
        return result;
    }

    private void buildTable(TabularResultModel table, int startCount, int endCount) {
        int lastRowExclusive = Math.min(this.selectResult.size(), endCount + 1);
        List<SelectResultRow> paginatedRows = this.selectResult.subList(startCount, lastRowExclusive);
        ArrayList<String> possibleColumns = new ArrayList<String>();
        for (SelectResultRow row : paginatedRows) {
            for (String column : row.getColumnValues().keySet()) {
                if (possibleColumns.contains(column)) continue;
                possibleColumns.add(column);
            }
        }
        for (SelectResultRow row : paginatedRows) {
            Map<String, String> columnValues = row.getColumnValues();
            for (String column : possibleColumns) {
                table.accumulate(column, columnValues.getOrDefault(column, MISSING_VALUE));
            }
        }
    }

    public Object getInputQuery() {
        return this.inputQuery;
    }

    public void setInputQuery(Object inputQuery) {
        this.inputQuery = inputQuery;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void aggregate(DataCommandResult result) {
        if (!this.isLocateEntry()) {
            return;
        }
        if (this.locateEntryLocations == null) {
            this.locateEntryLocations = new ArrayList<KeyInfo>();
        }
        if (result == null) {
            if (this.locateEntryResult != null) {
                this.locateEntryLocations.add(this.locateEntryResult);
            }
            return;
        }
        if (result.errorString != null && !result.errorString.equals(this.errorString)) {
            this.errorString = result.errorString + " " + this.errorString;
        }
        if (!this.operationCompletedSuccessfully && result.infoString != null && !result.infoString.equals(this.infoString)) {
            this.infoString = result.infoString;
        }
        if (result.hasResultForAggregation) {
            this.operationCompletedSuccessfully = true;
            this.infoString = result.infoString;
            if (result.locateEntryResult != null) {
                this.locateEntryLocations.add(result.locateEntryResult);
            }
        }
    }

    public static class KeyInfo
    implements Serializable {
        private String memberId;
        private String memberName;
        private String host;
        private int pid;
        private ArrayList<Object[]> locations = null;

        public void addLocation(Object[] locationArray) {
            if (this.locations == null) {
                this.locations = new ArrayList();
            }
            this.locations.add(locationArray);
        }

        public List<Object[]> getLocations() {
            return this.locations;
        }

        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPid() {
            return this.pid;
        }

        public void setPid(int pid) {
            this.pid = pid;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ Member : ").append(this.host).append("(").append(this.memberId).append(") , ");
            for (Object[] array : this.locations) {
                boolean primary = (Boolean)array[3];
                String bucketId = (String)array[4];
                sb.append(" [ Primary : ").append(primary).append(" , BucketId : ").append(bucketId).append(" ]");
            }
            sb.append(" }");
            return sb.toString();
        }

        public boolean hasLocation() {
            if (this.locations == null) {
                return false;
            }
            for (Object[] array : this.locations) {
                boolean found = (Boolean)array[1];
                if (!found) continue;
                return true;
            }
            return false;
        }
    }

    public static class SelectResultRow
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int type;
        private final Map<String, String> columnValues;

        public SelectResultRow(int type, Object value) {
            this.type = type;
            this.columnValues = this.createColumnValues(value);
        }

        public Map<String, String> getColumnValues() {
            return this.columnValues;
        }

        private Map<String, String> createColumnValues(Object value) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (value == null || DataCommandResult.MISSING_VALUE.equals(value)) {
                result.put("Value", DataCommandResult.MISSING_VALUE);
            } else if (this.type == 300) {
                result.put(DataCommandResult.RESULT_FLAG, value.toString());
            } else if (value instanceof Undefined) {
                result.put("Value", "UNDEFINED");
            } else {
                this.resolveObjectToColumns(result, value);
            }
            return result;
        }

        private void resolveObjectToColumns(Map<String, String> columnData, Object value) {
            if (value instanceof PdxInstance) {
                this.resolvePdxToColumns(columnData, (PdxInstance)value);
            } else if (value instanceof Struct) {
                this.resolveStructToColumns(columnData, (StructImpl)value);
            } else if (value instanceof UUID) {
                columnData.put(DataCommandResult.RESULT_FLAG, this.valueToJson(value));
            } else {
                ObjectMapper mapper = GeodeJsonMapper.getMapperWithAlwaysInclusion();
                JsonNode node = mapper.valueToTree(value);
                node.fieldNames().forEachRemaining(field -> {
                    try {
                        columnData.put((String)field, mapper.writeValueAsString((Object)node.get(field)));
                    }
                    catch (JsonProcessingException e) {
                        columnData.put((String)field, e.getMessage());
                    }
                });
            }
        }

        private void resolvePdxToColumns(Map<String, String> columnData, PdxInstance pdx) {
            for (String field : pdx.getFieldNames()) {
                columnData.put(field, this.valueToJson(pdx.getField(field)));
            }
        }

        private void resolveStructToColumns(Map<String, String> columnData, StructImpl struct) {
            for (String field : struct.getFieldNames()) {
                columnData.put(field, this.valueToJson(struct.get(field)));
            }
        }

        private String valueToJson(Object value) {
            if (value == null) {
                return "null";
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof PdxInstance) {
                return JSONFormatter.toJSON((PdxInstance)((PdxInstance)value));
            }
            ObjectMapper mapper = GeodeJsonMapper.getMapperWithAlwaysInclusion();
            try {
                return mapper.writeValueAsString(value);
            }
            catch (JsonProcessingException jex) {
                return jex.getMessage();
            }
        }
    }
}

