/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.management.internal.cli.domain.PoolProperty;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class PoolPropertyConverter
implements Converter<String, PoolProperty[]> {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\{\\s*'name'\\s*:\\s*'([^']*)'\\s*,\\s*'value'\\s*:\\s*'([^']*)'\\s*\\}");

    public PoolProperty[] convert(@NonNull String source) {
        if (source == null || source.trim().isEmpty()) {
            return new PoolProperty[0];
        }
        ArrayList<PoolProperty> properties = new ArrayList<PoolProperty>();
        Matcher matcher = PROPERTY_PATTERN.matcher(source);
        while (matcher.find()) {
            PoolProperty property = new PoolProperty();
            property.setName(matcher.group(1));
            property.setValue(matcher.group(2));
            properties.add(property);
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("Invalid pool-properties format. Expected: {'name':'name1','value':'value1'},{'name':'name2','value':'value2'}. Got: " + source);
        }
        return properties.toArray(new PoolProperty[0]);
    }
}

