/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class LogLevelConverter
implements Converter<String, String> {
    private final Set<String> logLevels = Arrays.stream(Level.values()).map(Level::name).collect(Collectors.toSet());

    public Set<String> getCompletionValues() {
        return this.logLevels;
    }

    public String convert(@NonNull String source) {
        if (!this.logLevels.contains(source.toUpperCase())) {
            throw new IllegalArgumentException("Invalid log level: " + source + ". Valid levels: " + String.valueOf(this.logLevels));
        }
        return source;
    }
}

