/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;
import org.apache.geode.management.internal.cli.help.Helper;

public class HelpCommandCompletionProvider
implements ValueCompletionProvider {
    @Override
    public boolean supports(Class<?> targetType) {
        return String.class.equals(targetType);
    }

    @Override
    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String optionName = context.getOptionName();
        String commandName = context.getCommandName();
        if (optionName == null || !optionName.equals("command")) {
            return completions;
        }
        if (commandName == null || !commandName.equals("help")) {
            return completions;
        }
        Object cmdMgr = context.getCommandManager();
        if (cmdMgr == null || !(cmdMgr instanceof CommandManager)) {
            return completions;
        }
        CommandManager commandManager = (CommandManager)cmdMgr;
        Helper helper = commandManager.getHelper();
        if (helper == null) {
            return completions;
        }
        Set<String> allCommands = helper.getCommands();
        String partial = partialValue == null ? "" : partialValue;
        for (String cmd : allCommands) {
            if (!partial.isEmpty() && !cmd.startsWith(partial)) continue;
            completions.add(new Completion(cmd));
        }
        return completions;
    }
}

