/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;

public class EnumCompletionProvider
implements ValueCompletionProvider {
    @Override
    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        if (!targetType.isEnum()) {
            return Collections.emptyList();
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        ?[] constants = targetType.getEnumConstants();
        if (constants == null) {
            return Collections.emptyList();
        }
        Arrays.sort(constants, (a, b) -> a.toString().compareTo(b.toString()));
        String lowerPartial = partialValue.toLowerCase();
        for (Object constant : constants) {
            String value = constant.toString();
            if (!lowerPartial.isEmpty() && (!value.toLowerCase().startsWith(lowerPartial) || value.equalsIgnoreCase(partialValue))) continue;
            completions.add(new Completion(value));
        }
        return completions;
    }

    @Override
    public boolean supports(Class<?> targetType) {
        return targetType.isEnum();
    }
}

