/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class StatusServerCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Display the status of a Geode Cache Server.", key={"status server"})
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public ResultModel statusServer(@ShellOption(value={"name"}, help="Member name or ID of the Cache Server in the Geode cluster.") String member, @ShellOption(value={"pid"}, help="Process ID (PID) of the running Geode Cache Server. Deprecated: Since Geode 1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @ShellOption(value={"dir"}, help="Working directory in which the Cache Server is running. The default is the current directory.") String workingDirectory) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)member)) {
            if (this.isConnectedAndReady()) {
                MemberMXBean serverProxy = MXBeanProvider.getMemberMXBean(member);
                if (serverProxy != null) {
                    return ResultModel.createInfo(ServerLauncher.ServerState.fromJson((String)serverProxy.status()).toString());
                }
                return ResultModel.createError(CliStrings.format((String)"No Geode Cache Server with member name or ID {0} could be found.", (Object)member));
            }
            return ResultModel.createError(CliStrings.format((String)"Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)"Cache Server"));
        }
        ServerLauncher serverLauncher = new ServerLauncher.Builder().setCommand(ServerLauncher.Command.STATUS).setDisableDefaultServer(Boolean.valueOf(true)).setPid(pid).setWorkingDirectory(workingDirectory).build();
        ServerLauncher.ServerState status = serverLauncher.status();
        if (status.getStatus().equals((Object)AbstractLauncher.Status.NOT_RESPONDING) || status.getStatus().equals((Object)AbstractLauncher.Status.STOPPED)) {
            return ResultModel.createError(status.toString());
        }
        return ResultModel.createInfo(status.toString());
    }
}

