/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.JdkTool;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class StartJVisualVMCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Start the JDK's Java VisualVM (jvisualvm) tool in a separate process. Java VisualVM will be launched, but connecting to Geode must be done manually.", key={"start jvisualvm"})
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public ResultModel startJVisualVM(@ShellOption(value={"J"}, help="Arguments passed to the JVM on which JConsole will run.") String[] jvmArgs) throws IOException {
        String jvisualvmProcessOutput = this.getProcessOutput(jvmArgs);
        ResultModel result = new ResultModel();
        InfoResultModel infoResultModel = result.addInfo();
        if (StringUtils.isNotBlank((CharSequence)jvisualvmProcessOutput)) {
            infoResultModel.addLine(System.lineSeparator());
            infoResultModel.addLine(jvisualvmProcessOutput);
        }
        return result;
    }

    String getProcessOutput(String[] jvmArgs) throws IOException {
        Object[] jvisualvmCommandLine = this.createJVisualVMCommandLine(jvmArgs);
        if (this.isDebugging()) {
            this.getGfsh().printAsInfo(String.format("JVisualVM command-line (%1$s)", Arrays.toString(jvisualvmCommandLine)));
        }
        Process jvisualvmProcess = Runtime.getRuntime().exec((String[])jvisualvmCommandLine);
        this.getGfsh().printAsInfo("Launched JVisualVM");
        return ProcessStreamReader.waitAndCaptureProcessStandardErrorStream((Process)jvisualvmProcess);
    }

    String[] createJVisualVMCommandLine(String[] jvmArgs) {
        ArrayList<Object> commandLine = new ArrayList<Object>();
        commandLine.add(JdkTool.getJVisualVMPathname());
        if (jvmArgs != null) {
            for (String arg : jvmArgs) {
                commandLine.add("-J" + arg);
            }
        }
        return commandLine.toArray(new String[0]);
    }
}

